/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.ColorsResource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.EntriesResource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.TexturesResource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class Resources {
    public final Map<String, Resource<?>> resources;

    public Resources(Map<String, Resource<?>> resources) {
        this.resources = resources;
    }

    public static Resources emptyResource() {
        return new Resources(new LinkedHashMap());
    }

    public static Resources fromNBT(CompoundTag tag) {
        LinkedHashMap map = new LinkedHashMap();
        for (String key : tag.getAllKeys()) {
            Optional<AnnotationDetector.Wrapper> resource = AnnotationDetector.REGISTER_RESOURCES.stream().filter(wrapper -> ((LDLRegister)wrapper.annotation()).name().equals(key)).findFirst();
            if (resource.isEmpty()) continue;
            map.put(key, (Resource)resource.get().creator().get());
        }
        Resources resources = new Resources(map);
        resources.deserializeNBT(tag);
        return resources;
    }

    @Deprecated(since="1.21")
    public static Resources defaultResource() {
        Resources resources = Resources.of(new EntriesResource(), new ColorsResource(), new TexturesResource());
        resources.resources.values().forEach(Resource::buildDefault);
        return resources;
    }

    public static Resources of(Resource<?> ... resources) {
        LinkedHashMap map = new LinkedHashMap();
        for (Resource<?> resource : resources) {
            map.put(resource.name(), resource);
        }
        return new Resources(map);
    }

    public void merge(Resources resources) {
        this.resources.forEach((k, v) -> {
            if (resources.resources.containsKey(k)) {
                Resource<?> f = resources.resources.get(k);
                v.merge(f);
            }
        });
    }

    public void load() {
        this.resources.values().forEach(Resource::onLoad);
    }

    public void dispose() {
        this.resources.values().forEach(Resource::unLoad);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.resources.forEach((key, resource) -> tag.put(key, (Tag)resource.serializeNBT()));
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.resources.forEach((k, v) -> v.deserializeNBT(nbt.getCompound(k)));
    }
}

