/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data.resource;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.IRendererResourceContainer;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.io.File;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="ldlib.gui.editor.group.renderer", group="resource")
public class IRendererResource
extends Resource<IRenderer> {
    public static final String RESOURCE_NAME = "ldlib.gui.editor.group.renderer";

    public IRendererResource() {
        super(new File(LDLib.getLDLibDir(), "assets/resources/renderers"));
        this.addBuiltinResource("empty", IRenderer.EMPTY);
    }

    @Override
    public void buildDefault() {
        this.addBuiltinResource("furnace", new IModelRenderer(new ResourceLocation("block/furnace")));
    }

    @Override
    public String name() {
        return RESOURCE_NAME;
    }

    @Override
    public ResourceContainer<IRenderer, ? extends Widget> createContainer(ResourcePanel resourcePanel) {
        return new IRendererResourceContainer(this, resourcePanel);
    }

    @Override
    @Nullable
    public Tag serialize(IRenderer renderer) {
        if (renderer instanceof ISerializableRenderer) {
            ISerializableRenderer serializableRenderer = (ISerializableRenderer)renderer;
            return ISerializableRenderer.serializeWrapper(serializableRenderer);
        }
        return null;
    }

    @Override
    public IRenderer deserialize(Tag tag) {
        CompoundTag compoundTag;
        ISerializableRenderer renderer;
        if (tag instanceof CompoundTag && (renderer = ISerializableRenderer.deserializeWrapper(compoundTag = (CompoundTag)tag)) != null) {
            return renderer;
        }
        return IRenderer.EMPTY;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.getBuiltinResources().clear();
        this.addBuiltinResource("empty", IRenderer.EMPTY);
        for (String key : nbt.getAllKeys()) {
            this.addBuiltinResource(key, this.deserialize(nbt.get(key)));
        }
    }
}

