/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data.resource;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.StaticResource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

public abstract class Resource<T> {
    private static final Map<String, StaticResource<?>> STATIC_RESOURCES = new HashMap();
    private final Map<String, T> builtinResources = new LinkedHashMap<String, T>();
    @Nullable
    private final File staticLocation;
    @Nullable
    private StaticResource<T> staticResource;

    public Resource() {
        this.staticLocation = null;
    }

    public Resource(@Nullable File staticLocation) {
        this.staticLocation = staticLocation;
    }

    public void buildDefault() {
    }

    public void onLoad() {
        this.getStaticResource().loadAndUpdateStaticResource();
    }

    public void unLoad() {
    }

    public StaticResource<T> getStaticResource() {
        if (!this.supportStaticResource()) {
            return StaticResource.empty();
        }
        if (this.staticResource == null) {
            this.staticResource = STATIC_RESOURCES.computeIfAbsent(this.name(), name -> {
                Optional<AnnotationDetector.Wrapper> resource = AnnotationDetector.REGISTER_RESOURCES.stream().filter(wrapper -> ((LDLRegister)wrapper.annotation()).name().equals(name)).findFirst();
                return resource.map(wrapper -> new StaticResource((Resource)wrapper.creator().get())).orElse(StaticResource.empty());
            });
        }
        return this.staticResource;
    }

    public T removeBuiltinResource(String key) {
        return this.builtinResources.remove(key);
    }

    public T removeStaticResource(File file) {
        if (this.getStaticResource().staticResources.containsKey(file)) {
            this.getStaticResource().staticResourcesLastModified.remove(file);
        }
        if (file.isFile() && file.exists()) {
            try {
                file.delete();
            }
            catch (Exception e) {
                LDLib.LOGGER.error("Failed to delete static resource file {} from {}: ", new Object[]{file, this, e});
            }
        }
        return this.getStaticResource().staticResources.remove(file);
    }

    public T removeResource(Either<String, File> key) {
        return (T)key.map(this::removeBuiltinResource, this::removeStaticResource);
    }

    public boolean hasBuiltinResource(String key) {
        return this.builtinResources.containsKey(key);
    }

    public boolean hasStaticResource(File file) {
        return this.getStaticResource().staticResources.containsKey(file);
    }

    public boolean hasResource(Either<String, File> key) {
        return (Boolean)key.map(this::hasBuiltinResource, this::hasStaticResource);
    }

    public void addBuiltinResource(String key, T resource) {
        if (this.supportBuiltInResource()) {
            this.builtinResources.put(key, resource);
        }
    }

    public void addResource(Either<String, File> key, T resource) {
        if (key.left().isPresent()) {
            this.addBuiltinResource((String)key.left().get(), resource);
        } else if (key.right().isPresent()) {
            this.addStaticResource((File)key.right().get(), resource);
        }
    }

    public void addStaticResource(File file, T resource) {
        if (this.supportStaticResource()) {
            Tag data = this.serialize(resource);
            if (data == null) {
                return;
            }
            CompoundTag fileData = new CompoundTag();
            fileData.put("data", data);
            fileData.putString("type", this.name());
            try {
                NbtIo.write((CompoundTag)fileData, (File)file);
                this.getStaticResource().staticResources.put(file, resource);
                this.getStaticResource().staticResourcesLastModified.put(file, file.lastModified());
            }
            catch (IOException e) {
                LDLib.LOGGER.error("Failed to save static resource file {} from {}: ", new Object[]{file, this, e});
            }
        }
    }

    public T getBuiltinResource(String key) {
        return this.builtinResources.get(key);
    }

    public T getStaticResource(File file) {
        return this.getStaticResource().staticResources.get(file);
    }

    public T getResource(Either<String, File> key) {
        return (T)key.map(this::getBuiltinResource, this::getStaticResource);
    }

    public T getBuiltinResourceOrDefault(String key, T defaultValue) {
        return this.builtinResources.getOrDefault(key, defaultValue);
    }

    public T getStaticResourceOrDefault(File file, T defaultValue) {
        return this.getStaticResource().staticResources.getOrDefault(file, defaultValue);
    }

    public T getResourceOrDefault(Either<String, File> key, T defaultValue) {
        return (T)key.map(k -> this.getBuiltinResourceOrDefault((String)k, defaultValue), f -> this.getStaticResourceOrDefault((File)f, defaultValue));
    }

    public void merge(Resource<T> resource) {
        resource.builtinResources.forEach((k, v) -> {
            if (!this.builtinResources.containsKey(k)) {
                this.builtinResources.put((String)k, (T)v);
            }
        });
    }

    public Stream<Map.Entry<Either<String, File>, T>> allResources() {
        return Stream.concat(this.getStaticResource().staticResources.entrySet().stream().map(entry -> Map.entry(Either.right((Object)((File)entry.getKey())), entry.getValue())), this.builtinResources.entrySet().stream().map(entry -> Map.entry(Either.left((Object)((String)entry.getKey())), entry.getValue())));
    }

    public abstract String name();

    public abstract ResourceContainer<T, ? extends Widget> createContainer(ResourcePanel var1);

    @Nullable
    public abstract Tag serialize(T var1);

    public abstract T deserialize(Tag var1);

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.builtinResources.forEach((key, value) -> {
            Tag nbt = this.serialize(value);
            if (nbt != null) {
                tag.put(key, nbt);
            }
        });
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.builtinResources.clear();
        for (String key : nbt.getAllKeys()) {
            this.builtinResources.put(key, this.deserialize(nbt.get(key)));
        }
    }

    public String getResourceName(Either<String, File> key) {
        return (String)key.map(k -> k, this::getStaticResourceName);
    }

    public boolean supportBuiltInResource() {
        return true;
    }

    public boolean supportStaticResource() {
        return this.staticLocation != null && (this.staticLocation.isDirectory() || this.staticLocation.mkdirs());
    }

    public String getStaticResourceSuffix() {
        return ".nbt";
    }

    public File getStaticResourceFile(String name) {
        return new File(this.staticLocation, name + this.getStaticResourceSuffix());
    }

    public String getStaticResourceName(File file) {
        return file.getName().substring(0, file.getName().length() - this.getStaticResourceSuffix().length());
    }

    public boolean loadAndUpdateStaticResource() {
        if (this.supportStaticResource()) {
            return this.getStaticResource().loadAndUpdateStaticResource();
        }
        return false;
    }

    public String toString() {
        return this.name();
    }

    public Map<String, T> getBuiltinResources() {
        return this.builtinResources;
    }

    @Nullable
    public File getStaticLocation() {
        return this.staticLocation;
    }
}

