/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ILDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.MenuPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.StringTabContainer;
import com.lowdragmc.lowdraglib.gui.editor.ui.ToolPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.HistoryView;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.util.TreeNode;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.MenuWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Editor
extends WidgetGroup
implements ILDLRegister {
    @OnlyIn(value=Dist.CLIENT)
    public static Editor INSTANCE;
    protected final File workSpace;
    protected IProject currentProject;
    @Nullable
    protected File currentProjectFile;
    protected MenuPanel menuPanel;
    protected StringTabContainer tabPages;
    protected ConfigPanel configPanel;
    protected ResourcePanel resourcePanel;
    protected WidgetGroup floatView;
    protected ToolPanel toolPanel;
    protected String copyType;
    protected Object copied;
    protected final List<HistoryItem> history = new ArrayList<HistoryItem>();
    @Nullable
    protected HistoryItem currentHistory;
    private boolean isWaitingForSave = false;

    public Editor(String modID) {
        this(new File(LDLib.getLDLibDir(), "assets/" + modID));
        if (LDLib.isClient() && !this.workSpace.exists() && !this.workSpace.mkdirs()) {
            LDLib.LOGGER.error("Failed to create work space for mod: " + modID);
        }
    }

    public Editor(File workSpace) {
        super(0, 0, 10, 10);
        this.setClientSideWidget();
        this.workSpace = workSpace;
    }

    @Override
    public void setGui(ModularUI gui) {
        if (gui != null) {
            gui.mainGroup.setClientSideWidget();
            gui.mainGroup.setAllowXEIIngredientOverMouse(false);
        }
        super.setGui(gui);
        if (this.isRemote()) {
            if (gui == null) {
                INSTANCE = null;
            } else {
                INSTANCE = this;
                this.getGui().registerCloseListener(() -> {
                    INSTANCE = null;
                });
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onScreenSizeUpdate(int screenWidth, int screenHeight) {
        this.setSize(new Size(screenWidth, screenHeight));
        super.onScreenSizeUpdate(screenWidth, screenHeight);
        this.clearAllWidgets();
        this.initEditorViews();
        int lastPageIndex = this.tabPages == null ? -1 : this.tabPages.getTabIndex();
        this.loadProject(this.currentProject);
        if (this.tabPages != null) {
            this.tabPages.switchTabIndex(lastPageIndex);
        }
    }

    public void initEditorViews() {
        this.toolPanel = new ToolPanel(this);
        this.configPanel = new ConfigPanel(this);
        this.tabPages = new StringTabContainer(this);
        this.resourcePanel = new ResourcePanel(this);
        this.menuPanel = new MenuPanel(this);
        this.floatView = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget(this.tabPages);
        this.addWidget(this.toolPanel);
        this.addWidget(this.configPanel);
        this.addWidget(this.resourcePanel);
        this.addWidget(this.menuPanel);
        this.addWidget(this.floatView);
    }

    public DialogWidget openDialog(DialogWidget dialog) {
        this.addWidget(dialog);
        Position pos = dialog.getPosition();
        Size size = dialog.getSize();
        if (pos.x + size.width > this.getGui().getScreenWidth()) {
            dialog.addSelfPosition(pos.x + size.width - this.getGui().getScreenWidth(), 0);
        } else if (pos.x < 0) {
            dialog.addSelfPosition(-pos.x, 0);
        }
        if (pos.y + size.height > this.getGui().getScreenHeight()) {
            dialog.addSelfPosition(0, pos.y + size.height - this.getGui().getScreenHeight());
        } else if (pos.y < 0) {
            dialog.addSelfPosition(0, -pos.y);
        }
        return dialog;
    }

    public <T, C> MenuWidget<T, C> openMenu(double posX, double posY, TreeNode<T, C> menuNode) {
        MenuWidget<T, C> menu = new MenuWidget<T, C>((int)posX, (int)posY, 14, menuNode).setNodeTexture(MenuWidget.NODE_TEXTURE).setLeafTexture(MenuWidget.LEAF_TEXTURE).setNodeHoverTexture(MenuWidget.NODE_HOVER_TEXTURE);
        this.waitToAdded(menu.setBackground(MenuWidget.BACKGROUND));
        return menu;
    }

    public void openMenu(double posX, double posY, TreeBuilder.Menu menuBuilder) {
        if (menuBuilder == null) {
            return;
        }
        this.openMenu(posX, posY, menuBuilder.build()).setCrossLinePredicate(TreeBuilder.Menu::isCrossLine).setKeyIconSupplier(TreeBuilder.Menu::getIcon).setKeyNameSupplier(TreeBuilder.Menu::getName).setOnNodeClicked(TreeBuilder.Menu::handle);
    }

    public void addRawHistory(String name, CompoundTag date) {
        this.addRawHistory(name, date, null);
    }

    public void addRawHistory(String name, CompoundTag date, @Nullable Object source) {
        if (this.currentProject != null) {
            int index;
            if (this.currentHistory != null && (index = this.history.indexOf(this.currentHistory)) >= 0) {
                while (this.history.size() > index + 1) {
                    this.history.remove(this.history.size() - 1);
                }
            }
            this.currentHistory = new HistoryItem(name, date, source);
            this.history.add(this.currentHistory);
            for (Widget widget : this.floatView.widgets) {
                if (!(widget instanceof HistoryView)) continue;
                HistoryView historyView = (HistoryView)widget;
                historyView.loadList();
                break;
            }
        }
    }

    public void addAutoHistory(String name, @Nullable Object source) {
        if (this.currentProject != null) {
            String historyName = LocalizationUtils.format(name, new Object[0]);
            CompoundTag data = (CompoundTag)this.currentProject.serializeNBT();
            if (!this.getHistory().isEmpty()) {
                HistoryItem latestHistory = this.getHistory().get(this.getHistory().size() - 1);
                if (!data.equals((Object)latestHistory.date())) {
                    if (latestHistory.name().equals(historyName) && Objects.equals(latestHistory.source(), source)) {
                        this.getHistory().remove(latestHistory);
                    }
                    this.addRawHistory(historyName, data, source);
                }
            } else {
                this.addRawHistory(historyName, data, source);
            }
        }
    }

    public void jumpToHistory(HistoryItem historyItem) {
        if (this.currentProject != null && this.history.contains(historyItem)) {
            int lastPageIndex = this.tabPages.getTabIndex();
            this.currentProject.deserializeNBT(historyItem.date());
            this.loadProject(this.currentProject);
            this.tabPages.switchTabIndex(lastPageIndex);
            this.currentHistory = historyItem;
        }
    }

    public void loadProject(IProject project) {
        if (this.currentProject != null && this.currentProject != project) {
            this.history.clear();
            this.currentProject.onClosed(this);
            this.currentProjectFile = null;
        }
        this.currentProject = project;
        this.tabPages.clearAllWidgets();
        this.toolPanel.clearAllWidgets();
        this.toolPanel.hide(false);
        this.configPanel.clearAllConfigurators();
        this.resourcePanel.clear();
        this.floatView.clearAllWidgets();
        if (this.currentProject != null) {
            this.currentProject.onLoad(this);
        }
    }

    public void setCopy(String copyType, Object copied) {
        this.copied = copied;
        this.copyType = copyType;
    }

    public void ifCopiedPresent(String copyType, Consumer<Object> consumer) {
        if (Objects.equals(copyType, this.copyType)) {
            consumer.accept(this.copied);
        }
    }

    public void askToSaveProject(BooleanConsumer result) {
        DialogWidget.showCheckBox(this, "ldlib.gui.editor.tips.save_project", "ldlib.gui.editor.tips.ask_to_save", isSave -> {
            if (isSave) {
                this.saveProject(result);
            } else {
                result.accept(false);
            }
        });
    }

    public void saveProject(BooleanConsumer result) {
        if (this.currentProject != null) {
            if (this.currentProjectFile == null) {
                this.saveAsProject(result);
            } else {
                this.currentProject.saveProject(this.currentProjectFile);
                DialogWidget.showNotification(this, "ldlib.gui.editor.menu.save", "ldlib.gui.compass.save_success");
                result.accept(true);
            }
        } else {
            result.accept(false);
        }
    }

    public void saveAsProject(BooleanConsumer result) {
        if (this.currentProject != null) {
            String suffix = "." + this.currentProject.getSuffix();
            DialogWidget.showFileDialog(this, "ldlib.gui.editor.tips.save_as", this.currentProject.getProjectWorkSpace(this), false, DialogWidget.suffixFilter(suffix), file -> {
                if (file != null && !file.isDirectory()) {
                    if (!file.getName().endsWith(suffix)) {
                        file = new File(file.getParentFile(), file.getName() + suffix);
                    }
                    this.currentProject.saveProject((File)file);
                    this.currentProjectFile = file;
                    result.accept(true);
                } else {
                    result.accept(false);
                }
            });
        }
    }

    public boolean isCurrentProjectSaved() {
        if (this.currentProject == null) {
            return true;
        }
        if (this.currentProjectFile == null) {
            return false;
        }
        try {
            CompoundTag tag = NbtIo.read((File)this.currentProjectFile);
            return tag != null && tag.equals(this.currentProject.serializeNBT());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.isWaitingForSave) {
                this.getGui().getModularUIGui().onClose();
                return true;
            }
            if (!this.isCurrentProjectSaved()) {
                this.isWaitingForSave = true;
                this.askToSaveProject(result -> this.getGui().getModularUIGui().onClose());
                return true;
            }
            return false;
        }
        super.keyPressed(keyCode, scanCode, modifiers);
        return true;
    }

    public File getWorkSpace() {
        return this.workSpace;
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    @Nullable
    public File getCurrentProjectFile() {
        return this.currentProjectFile;
    }

    public MenuPanel getMenuPanel() {
        return this.menuPanel;
    }

    public StringTabContainer getTabPages() {
        return this.tabPages;
    }

    public ConfigPanel getConfigPanel() {
        return this.configPanel;
    }

    public ResourcePanel getResourcePanel() {
        return this.resourcePanel;
    }

    public WidgetGroup getFloatView() {
        return this.floatView;
    }

    public ToolPanel getToolPanel() {
        return this.toolPanel;
    }

    public String getCopyType() {
        return this.copyType;
    }

    public Object getCopied() {
        return this.copied;
    }

    public List<HistoryItem> getHistory() {
        return this.history;
    }

    @Nullable
    public HistoryItem getCurrentHistory() {
        return this.currentHistory;
    }

    public boolean isWaitingForSave() {
        return this.isWaitingForSave;
    }

    public void setCurrentProjectFile(@Nullable File currentProjectFile) {
        this.currentProjectFile = currentProjectFile;
    }

    public record HistoryItem(String name, CompoundTag date, @Nullable Object source) {
    }
}

