/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.menu.MenuTab;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

public class MenuPanel
extends WidgetGroup {
    public static final int HEIGHT = 16;
    protected final Editor editor;
    protected final Map<String, MenuTab> tabs = new LinkedHashMap<String, MenuTab>();

    public MenuPanel(Editor editor) {
        super(0, 0, editor.getSize().getWidth() - 252, 16);
        this.setClientSideWidget();
        this.editor = editor;
    }

    @Override
    public void initWidget() {
        this.setBackground(ColorPattern.T_RED.rectTexture());
        this.addWidget(new ImageWidget(2, 2, 12, 12, new ResourceTexture()));
        if (this.isRemote()) {
            this.initTabs();
        }
        super.initWidget();
    }

    public <T extends MenuTab> T getTab(String name) {
        return (T)this.tabs.get(name);
    }

    protected void initTabs() {
        int x = 20;
        CompoundTag tag = new CompoundTag();
        try {
            tag = NbtIo.read((File)new File(this.editor.getWorkSpace(), "settings/menu.cfg"));
            if (tag == null) {
                tag = new CompoundTag();
            }
        }
        catch (IOException e) {
            LDLib.LOGGER.error(e.getMessage());
        }
        for (AnnotationDetector.Wrapper<LDLRegister, MenuTab> wrapper : AnnotationDetector.REGISTER_MENU_TABS) {
            if (!this.editor.name().startsWith(wrapper.annotation().group())) continue;
            MenuTab tab = wrapper.creator().get();
            this.tabs.put(wrapper.annotation().name(), tab);
            Widget button = tab.createTabWidget();
            button.addSelfPosition(x, 0);
            x += button.getSize().getWidth();
            this.addWidget(button);
            if (!tag.contains(tab.name())) continue;
            tab.deserializeNBT(tag.getCompound(tab.name()));
        }
    }

    public void saveMenuData() {
        CompoundTag tag = new CompoundTag();
        for (MenuTab tab : this.tabs.values()) {
            CompoundTag nbt = tab.serializeNBT();
            if (nbt.isEmpty()) continue;
            tag.put(tab.name(), (Tag)nbt);
        }
        try {
            NbtIo.write((CompoundTag)tag, (File)new File(this.editor.getWorkSpace(), "settings/menu.cfg"));
        }
        catch (IOException e) {
            LDLib.LOGGER.error(e.getMessage());
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Map<String, MenuTab> getTabs() {
        return this.tabs;
    }
}

