/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.menu;

import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.menu.MenuTab;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.nbt.CompoundTag;

@LDLRegister(name="view", group="editor", priority=100)
public class ViewMenu
extends MenuTab {
    public final Map<String, FloatViewWidget> openedViews = new HashMap<String, FloatViewWidget>();

    @Override
    protected TreeBuilder.Menu createMenu() {
        TreeBuilder.Menu viewMenu = TreeBuilder.Menu.start().branch("ldlib.gui.editor.menu.view.window_size", menu -> {
            Minecraft minecraft = Minecraft.getInstance();
            OptionInstance guiScale = minecraft.options.guiScale();
            int maxScale = !minecraft.isRunning() ? 0x7FFFFFFE : minecraft.getWindow().calculateScale(0, minecraft.isEnforceUnicode());
            for (int i = 0; i <= maxScale; ++i) {
                int finalI = i;
                menu.leaf((Integer)guiScale.get() == i ? Icons.CHECK : IGuiTexture.EMPTY, (String)(i == 0 ? "options.guiScale.auto" : "" + i), () -> {
                    if ((Integer)guiScale.get() != finalI) {
                        guiScale.set((Object)finalI);
                        Minecraft.getInstance().resizeDisplay();
                    }
                });
            }
        });
        for (AnnotationDetector.Wrapper<LDLRegister, FloatViewWidget> wrapper : AnnotationDetector.REGISTER_FLOAT_VIEWS) {
            if (!this.editor.name().startsWith(wrapper.annotation().group())) continue;
            String translateKey = "ldlib.gui.editor.register.%s.%s".formatted(wrapper.annotation().group(), wrapper.annotation().name());
            String name = wrapper.annotation().name();
            if (this.isViewOpened(name)) {
                viewMenu.leaf(Icons.CHECK, translateKey, () -> this.removeView(name));
                continue;
            }
            viewMenu.leaf(translateKey, () -> {
                FloatViewWidget view = (FloatViewWidget)wrapper.creator().get();
                this.openView(view);
            });
        }
        return viewMenu;
    }

    public void openView(FloatViewWidget view) {
        if (!this.isViewOpened(view.name())) {
            this.openedViews.put(view.name(), view);
            this.editor.getFloatView().addWidgetAnima(view, new Transform().duration(200L).scale(0.2f));
        }
    }

    public void removeView(String viewName) {
        if (this.isViewOpened(viewName)) {
            for (Widget widget : this.editor.getFloatView().widgets) {
                FloatViewWidget view;
                if (!(widget instanceof FloatViewWidget) || !(view = (FloatViewWidget)widget).name().equals(viewName)) continue;
                this.editor.getFloatView().removeWidgetAnima(view, new Transform().duration(200L).scale(0.2f));
            }
        }
    }

    public boolean isViewOpened(String viewName) {
        if (this.openedViews.containsKey(viewName)) {
            for (Widget widget : this.editor.getFloatView().widgets) {
                FloatViewWidget view;
                if (!(widget instanceof FloatViewWidget) || !(view = (FloatViewWidget)widget).name().equals(viewName)) continue;
                return true;
            }
            this.openedViews.remove(viewName);
        }
        return false;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }
}

