/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.factory;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.factory.UIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeldItemUIFactory
extends UIFactory<HeldItemHolder> {
    public static final HeldItemUIFactory INSTANCE = new HeldItemUIFactory();

    public HeldItemUIFactory() {
        super(LDLib.location("held_item"));
    }

    public final boolean openUI(ServerPlayer player, InteractionHand hand) {
        return this.openUI(new HeldItemHolder((Player)player, hand), player);
    }

    @Override
    protected ModularUI createUITemplate(HeldItemHolder holder, Player entityPlayer) {
        return holder.createUI(entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected HeldItemHolder readHolderFromSyncData(FriendlyByteBuf syncData) {
        LocalPlayer player = Minecraft.getInstance().player;
        return player == null ? null : new HeldItemHolder((Player)player, (InteractionHand)syncData.readEnum(InteractionHand.class));
    }

    @Override
    protected void writeHolderToSyncData(FriendlyByteBuf syncData, HeldItemHolder holder) {
        syncData.writeEnum((Enum)holder.hand);
    }

    public static class HeldItemHolder
    implements IUIHolder {
        public Player player;
        public InteractionHand hand;
        public ItemStack held;

        public HeldItemHolder(Player player, InteractionHand hand) {
            this.player = player;
            this.hand = hand;
            this.held = player.getItemInHand(hand);
        }

        @Override
        public ModularUI createUI(Player entityPlayer) {
            Item item = this.held.getItem();
            if (item instanceof IHeldItemUIHolder) {
                IHeldItemUIHolder itemUIHolder = (IHeldItemUIHolder)item;
                return itemUIHolder.createUI(entityPlayer, this);
            }
            return null;
        }

        @Override
        public boolean isInvalid() {
            return !ItemStack.isSameItemSameTags((ItemStack)this.player.getItemInHand(this.hand), (ItemStack)this.held);
        }

        @Override
        public boolean isRemote() {
            return this.player.level().isClientSide;
        }

        @Override
        public void markAsDirty() {
        }

        public Player getPlayer() {
            return this.player;
        }

        public InteractionHand getHand() {
            return this.hand;
        }

        public ItemStack getHeld() {
            return this.held;
        }
    }

    @Deprecated
    public static interface IHeldItemUIHolder
    extends IUIHolder.ItemUI {
    }
}

