/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.LinearTriggerNode;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

@LDLRegister(name="command", group="graph_processor.node.minecraft")
public class CommandNode
extends LinearTriggerNode {
    @InputPort
    public String command;
    @InputPort
    public Level level;
    @InputPort
    public Vector3f xyz;
    @OutputPort
    public String output;

    @Override
    public int getMinWidth() {
        return 100;
    }

    @Override
    public void process() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.performCommand(serverLevel);
        }
    }

    public void performCommand(ServerLevel serverLevel) {
        MinecraftServer minecraftServer;
        this.output = "";
        if (this.command != null && (minecraftServer = serverLevel.getServer()).isCommandBlockEnabled() && !StringUtil.isNullOrEmpty((String)this.command)) {
            try {
                CommandSourceStack commandSourceStack = new CommandSourceStack(new CommandSource(){

                    public void sendSystemMessage(@Nonnull Component component) {
                        CommandNode.this.output = component.getString();
                    }

                    public boolean acceptsSuccess() {
                        return false;
                    }

                    public boolean acceptsFailure() {
                        return false;
                    }

                    public boolean shouldInformAdmins() {
                        return false;
                    }
                }, this.xyz == null ? Vec3.atLowerCornerOf((Vec3i)serverLevel.getSharedSpawnPos()) : new Vec3((double)this.xyz.x, (double)this.xyz.y, (double)this.xyz.z), Vec2.ZERO, serverLevel, 5, "Server", (Component)Component.literal((String)"Server"), minecraftServer, null);
                minecraftServer.getCommands().performPrefixedCommand(commandSourceStack, this.command);
            }
            catch (Throwable var6) {
                LDLib.LOGGER.error("Error while executing command: {}", (Object)this.command, (Object)var6);
            }
        }
    }
}

