/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.block;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@LDLRegister(name="blockstate", group="graph_processor.node.minecraft.block")
public class BlockStateNode
extends BaseNode {
    @InputPort
    public Object in = null;
    @OutputPort
    public BlockState out = null;
    @Configurable(name="blockstate", canCollapse=false, collapse=false)
    public BlockState internalValue = Blocks.AIR.defaultBlockState();

    @Override
    public int getMinWidth() {
        return 100;
    }

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue;
            return;
        }
        Object object = this.in;
        if (object instanceof BlockState) {
            BlockState state;
            this.out = state = (BlockState)object;
        } else {
            object = this.in;
            if (object instanceof Block) {
                Block block = (Block)object;
                this.out = block.defaultBlockState();
            } else {
                object = this.in;
                if (object instanceof CompoundTag) {
                    CompoundTag tag = (CompoundTag)object;
                    this.out = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag);
                } else {
                    String name = this.in.toString();
                    if (ResourceLocation.isValidResourceLocation((String)name)) {
                        Block block = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(name));
                        this.out = block.defaultBlockState();
                    } else {
                        this.out = null;
                    }
                }
            }
        }
        this.internalValue = this.out;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

