/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.entity;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.LinearTriggerNode;
import net.minecraft.world.entity.Entity;
import org.joml.Vector3f;

@LDLRegister(name="entity action", group="graph_processor.node.minecraft.entity")
public class EntityActionNode
extends LinearTriggerNode {
    @InputPort
    public Entity entity;
    @InputPort
    public Vector3f xyz;
    @Configurable
    public Action action = Action.KILL;

    @Override
    public void process() {
        if (this.entity != null && this.action != null) {
            switch (this.action) {
                case KILL: {
                    this.entity.kill();
                    break;
                }
                case FIRE: {
                    this.entity.setSecondsOnFire(5);
                    break;
                }
                case MOVE: {
                    if (this.xyz == null) break;
                    this.entity.teleportTo((double)this.xyz.x, (double)this.xyz.y, (double)this.xyz.z);
                }
            }
        }
    }

    public static enum Action {
        KILL,
        MOVE,
        FIRE;

    }
}

