/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.fluid;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@LDLRegister(name="fluid", group="graph_processor.node.minecraft.fluid")
public class FluidNode
extends BaseNode {
    @InputPort
    public Object in = null;
    @OutputPort
    public Fluid out = null;
    @Configurable(showName=false)
    public Fluid internalValue = Fluids.WATER;

    @Override
    public int getMinWidth() {
        return 100;
    }

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue;
            return;
        }
        Object object = this.in;
        if (object instanceof Fluid) {
            Fluid fluid;
            this.out = fluid = (Fluid)object;
        } else {
            object = this.in;
            if (object instanceof FluidStack) {
                FluidStack fluidStack = (FluidStack)object;
                this.out = fluidStack.getFluid();
            } else {
                String name = this.in.toString();
                this.out = ResourceLocation.isValidResourceLocation((String)name) ? (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(name)) : null;
            }
        }
        this.internalValue = this.out;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

