/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.fluid;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@LDLRegister(name="fluidstack", group="graph_processor.node.minecraft.fluid")
public class FluidStackNode
extends BaseNode {
    @InputPort
    public Object in;
    @InputPort
    public Fluid fluid;
    @InputPort
    public Integer amount;
    @InputPort
    public CompoundTag tag;
    @OutputPort
    public FluidStack out;
    @Configurable(name="fluidstack", canCollapse=false, collapse=false)
    public FluidStack internalValue = FluidStack.create((Fluid)Fluids.WATER, 1000L);

    @Override
    public int getMinWidth() {
        return 100;
    }

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue.copy();
        } else {
            Object object = this.in;
            if (object instanceof FluidStack) {
                FluidStack fluidStack = (FluidStack)object;
                this.out = fluidStack.copy();
            } else {
                object = this.in;
                if (object instanceof CompoundTag) {
                    CompoundTag fluidTag = (CompoundTag)object;
                    this.out = FluidStack.loadFromTag(fluidTag);
                } else {
                    this.out = FluidStack.empty();
                }
            }
        }
        if (this.fluid != null) {
            FluidStack stack = FluidStack.create(this.fluid, this.out.getAmount());
            if (this.out.hasTag()) {
                stack.setTag(this.out.getTag());
            }
            this.out = stack;
        }
        if (this.amount != null) {
            this.out.setAmount(this.amount.intValue());
        }
        if (this.tag != null) {
            this.out.setTag(this.tag);
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

