/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.item;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

@LDLRegister(name="item", group="graph_processor.node.minecraft.item")
public class ItemNode
extends BaseNode {
    @InputPort
    public Object in = null;
    @OutputPort
    public Item out = null;
    @Configurable(showName=false)
    public Item internalValue = Items.AIR;

    @Override
    public int getMinWidth() {
        return 100;
    }

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue;
            return;
        }
        Object object = this.in;
        if (object instanceof Item) {
            Item item;
            this.out = item = (Item)object;
        } else {
            object = this.in;
            if (object instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                this.out = itemStack.getItem();
            } else {
                String name = this.in.toString();
                this.out = ResourceLocation.isValidResourceLocation((String)name) ? (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(name)) : null;
            }
        }
        this.internalValue = this.out;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

