/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.item;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@LDLRegister(name="itemstack", group="graph_processor.node.minecraft.item")
public class ItemStackNode
extends BaseNode {
    @InputPort
    public Object in;
    @InputPort
    public Item item;
    @InputPort
    public Integer count;
    @InputPort
    public CompoundTag tag;
    @OutputPort
    public ItemStack out = null;
    @Configurable(name="itemstack", canCollapse=false, collapse=false)
    public ItemStack internalValue = new ItemStack((ItemLike)Items.AIR);

    @Override
    public int getMinWidth() {
        return 100;
    }

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue.copy();
        } else {
            Object object = this.in;
            if (object instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                this.out = itemStack.copy();
            } else {
                object = this.in;
                if (object instanceof CompoundTag) {
                    CompoundTag itemTag = (CompoundTag)object;
                    this.out = ItemStack.of((CompoundTag)itemTag);
                } else {
                    this.out = new ItemStack((ItemLike)Items.AIR);
                }
            }
        }
        if (this.item != null) {
            ItemStack stack = new ItemStack((ItemLike)this.item, this.out.getCount());
            if (this.out.hasTag()) {
                stack.setTag(this.out.getTag());
            }
            this.out = stack;
        }
        if (this.count != null) {
            this.out.setCount(this.count.intValue());
        }
        if (this.tag != null) {
            this.out.setTag(this.tag);
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

