/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.widget;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ParameterNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.processor.BaseGraphProcessor;
import com.lowdragmc.lowdraglib.gui.graphprocessor.processor.TriggerProcessor;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.DebugPanelWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.NodePanelWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.NodePortWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.NodeWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.ParameterPanelWidget;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.util.TreeNode;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.FreeGraphView;
import com.lowdragmc.lowdraglib.gui.widget.MenuWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2i;

public class GraphViewWidget
extends WidgetGroup {
    private final BaseGraph graph;
    private final FreeGraphView freeGraphView;
    private final Map<BaseNode, NodeWidget> nodeMap = new HashMap<BaseNode, NodeWidget>();
    private final DebugPanelWidget debugPanel;
    private final NodePanelWidget nodePanel;
    private final ParameterPanelWidget parameterPanel;
    private NodePortWidget clickedPort;
    @Nullable
    private BaseGraphProcessor processor;
    private Map<String, List<AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode>>> nodeGroups = new LinkedHashMap<String, List<AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode>>>();
    private boolean showDebugInfo = Platform.isDevEnv();
    private boolean isRunStep = false;
    private Iterator<BaseNode> stepIterator;
    @Nullable
    private BaseNode stepNode;
    private final Set<BaseNode> selectedNodes = new HashSet<BaseNode>();
    private final Set<BaseNode> copiedNodes = new HashSet<BaseNode>();
    private boolean isDraggingArea = false;
    private double startMouseX;
    private double startMouseY;
    private int currentMouseX;
    private int currentMouseY;
    private long lastClickTick;

    public GraphViewWidget(BaseGraph graph, int x, int y, int width, int height) {
        this(graph, x, y, width, height, null);
    }

    public GraphViewWidget(BaseGraph graph, int x, int y, int width, int height, @Nullable Consumer<List<String>> additionalGroup) {
        super(x, y, width, height);
        this.graph = graph;
        this.freeGraphView = new FreeGraphView(0, 0, width, height){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected void drawWidgetsBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                GraphViewWidget.this.drawGraphLines(graphics, mouseX, mouseY, partialTicks);
                super.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
            }
        };
        this.addWidget(this.freeGraphView);
        this.freeGraphView.setDrawGrid(true);
        this.freeGraphView.setBackground(ColorPattern.SEAL_BLACK.rectTexture());
        this.processor = new TriggerProcessor(graph);
        ArrayList<String> supportNodeGroups = new ArrayList<String>();
        this.setupNodeGroups(supportNodeGroups);
        if (additionalGroup != null) {
            additionalGroup.accept(supportNodeGroups);
        }
        for (String group : supportNodeGroups) {
            for (AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode> wrapper : AnnotationDetector.REGISTER_GP_NODES.values()) {
                if (!wrapper.annotation().group().startsWith(group)) continue;
                this.nodeGroups.computeIfAbsent(wrapper.annotation().group(), k -> new ArrayList()).add(wrapper);
            }
        }
        this.loadGraph();
        this.debugPanel = new DebugPanelWidget(this);
        this.addWidget(this.debugPanel);
        this.debugPanel.setSelfPosition(this.getSizeWidth() - this.debugPanel.getSizeWidth() - 5, this.getSizeHeight() - this.debugPanel.getSizeHeight() - 5);
        this.nodePanel = new NodePanelWidget(this, 5, 5, 120, this.getSizeHeight() - 10);
        this.addWidget(this.nodePanel);
        this.nodePanel.setDraggable(false);
        this.parameterPanel = new ParameterPanelWidget(this, 130, 5, 200, 200);
        this.addWidget(this.parameterPanel);
        this.setDraggingConsumer(o -> o instanceof BaseNode, o -> {}, o -> {}, o -> {
            if (o instanceof BaseNode) {
                BaseNode baseNode = (BaseNode)o;
                this.addNode(baseNode, this.currentMouseX, this.currentMouseY);
            }
        });
        this.freeGraphView.resetFitScaleByWidgets();
    }

    protected void setupNodeGroups(List<String> supportNodeGroups) {
        supportNodeGroups.add("graph_processor.node.value");
        supportNodeGroups.add("graph_processor.node.logic");
        supportNodeGroups.add("graph_processor.node.math");
        supportNodeGroups.add("graph_processor.node.utils");
        supportNodeGroups.add("graph_processor.node.minecraft");
    }

    public void loadGraph() {
        this.freeGraphView.clearAllWidgets();
        this.nodeMap.clear();
        this.selectedNodes.clear();
        for (BaseNode node : this.graph.nodes) {
            NodeWidget nodeWidget = new NodeWidget(this, node);
            this.freeGraphView.addWidget(nodeWidget);
            this.nodeMap.put(node, nodeWidget);
        }
        this.updateComputeOrder();
    }

    public void addEdge(NodePort inputPort, NodePort outputPort) {
        this.graph.connect(inputPort, outputPort);
        this.updateComputeOrder();
    }

    public void removeEdge(NodePort port) {
        ArrayList<PortEdge> edges = new ArrayList<PortEdge>(port.getEdges());
        for (PortEdge edge : edges) {
            this.graph.disconnect(edge);
        }
        this.updateComputeOrder();
    }

    public void updateComputeOrder() {
        this.graph.updateComputeOrder(BaseGraph.ComputeOrderType.DepthFirst);
        this.stepIterator = null;
        this.stepNode = null;
        this.isRunStep = false;
        if (this.processor != null) {
            this.processor.updateComputeOrder();
        }
    }

    public void runAll() {
        if (this.isRunStep) {
            if (this.stepIterator != null) {
                while (this.stepIterator.hasNext()) {
                    this.stepNode = this.stepIterator.next();
                }
            }
            this.stepIterator = null;
            this.stepNode = null;
        }
        this.isRunStep = false;
    }

    public void runStep() {
        if (!this.isRunStep && this.processor != null) {
            this.stepIterator = this.processor.iterator();
        }
        this.isRunStep = true;
        if (this.stepIterator.hasNext()) {
            this.stepNode = this.stepIterator.next();
        } else if (this.processor != null) {
            this.stepNode = null;
            this.stepIterator = this.processor.iterator();
        }
    }

    public boolean isRunStepFinish() {
        return this.isRunStep && this.stepNode == null;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.processor != null && !this.isRunStep) {
            this.processor.run();
        }
    }

    public void setCopy(Collection<BaseNode> nodes) {
        this.copiedNodes.clear();
        this.copiedNodes.addAll(nodes);
    }

    public void pasteTo(double mouseX, double mouseY) {
        if (this.copiedNodes.isEmpty()) {
            return;
        }
        ArrayList<BaseNode> nodes = new ArrayList<BaseNode>(this.copiedNodes);
        Position firstPosition = null;
        HashMap<BaseNode, BaseNode> old2New = new HashMap<BaseNode, BaseNode>();
        ArrayList<PortEdge> edges = new ArrayList<PortEdge>();
        for (BaseNode node : nodes) {
            if (firstPosition == null) {
                firstPosition = node.position;
            }
            BaseNode newNode = node.copy();
            Vector2d newPosition = this.freeGraphView.getViewPosition(mouseX, mouseY);
            Position offset = node.position.subtract(firstPosition);
            newNode.position = new Position((int)newPosition.x + offset.x, (int)newPosition.y + offset.y);
            this.graph.addNode(newNode);
            NodeWidget nodeWidget = new NodeWidget(this, newNode);
            this.freeGraphView.addWidget(nodeWidget);
            this.nodeMap.put(newNode, nodeWidget);
            old2New.put(node, newNode);
            for (PortEdge edge : node.getAllEdges()) {
                if (!this.copiedNodes.contains(edge.inputNode) || !this.copiedNodes.contains(edge.outputNode) || edges.contains(edge)) continue;
                edges.add(edge);
            }
        }
        edges.sort(Comparator.comparingInt(this.graph.edges::indexOf));
        for (PortEdge edge : edges) {
            PortEdge copiedEdge = edge.copy();
            copiedEdge.GUID = this.graph.newGUID().toString();
            copiedEdge.inputNodeGUID = ((BaseNode)old2New.get(edge.inputNode)).getGUID();
            copiedEdge.outputNodeGUID = ((BaseNode)old2New.get(edge.outputNode)).getGUID();
            copiedEdge.initialize(this.graph);
            this.graph.edges.add(copiedEdge);
            this.graph.edgesPerGUID.put(copiedEdge.GUID, copiedEdge);
            this.graph.addGUID(copiedEdge.GUID);
            if (copiedEdge.inputPort == null || copiedEdge.outputPort == null) {
                this.graph.disconnect(copiedEdge.GUID);
                continue;
            }
            copiedEdge.inputPort.owner.onEdgeConnected(copiedEdge);
            copiedEdge.outputPort.owner.onEdgeConnected(copiedEdge);
            this.nodeMap.get(copiedEdge.inputPort.owner).reloadWidget();
            this.nodeMap.get(copiedEdge.outputPort.owner).reloadWidget();
        }
        this.updateComputeOrder();
    }

    public void renameNode(BaseNode node) {
        DialogWidget.showStringEditorDialog(this, "ldlib.gui.editor.tips.rename", node.getDisplayName(), s -> true, s -> {
            if (s != null) {
                node.setDisplayName((String)s);
                this.nodeMap.get(node).reloadWidget();
            }
        });
    }

    public void addNode(BaseNode node) {
        this.graph.addNode(node);
        NodeWidget nodeWidget = new NodeWidget(this, node);
        this.freeGraphView.addWidget(nodeWidget);
        this.nodeMap.put(node, nodeWidget);
        this.updateComputeOrder();
    }

    public void addNode(BaseNode node, int x, int y) {
        Vector2i position = this.freeGraphView.getViewPosition(x, y);
        node.position = new Position(position.x, position.y);
        this.addNode(node);
    }

    public void addNodeToCenter(BaseNode node) {
        if (node instanceof ParameterNode) {
            ParameterNode parameterNode = (ParameterNode)node;
            if (parameterNode.parameter != null && parameterNode.parameter.getAccessor() == ExposedParameter.ParameterAccessor.Set && this.graph.nodes.stream().anyMatch(n -> {
                if (!(n instanceof ParameterNode)) return false;
                ParameterNode pn = (ParameterNode)n;
                if (pn.parameter != parameterNode.parameter) return false;
                return true;
            })) {
                return;
            }
        }
        this.addNode(node, this.getSizeWidth() / 2 + LDLib.random.nextInt(-20, 20), this.getSizeHeight() / 2 + LDLib.random.nextInt(-20, 20));
    }

    public void removeNodes(Collection<BaseNode> removeNodes) {
        ArrayList<BaseNode> nodes = new ArrayList<BaseNode>(removeNodes);
        for (BaseNode node : nodes) {
            if (!node.isCanBeRemoved()) continue;
            List<PortEdge> edges = node.getAllEdges();
            edges.forEach(this.graph::disconnect);
            this.graph.removeNode(node);
            NodeWidget nodeWidget = this.nodeMap.remove(node);
            this.freeGraphView.removeWidget(nodeWidget);
            edges.forEach(edge -> {
                if (edge.inputNode == node) {
                    this.nodeMap.get(edge.outputNode).reloadWidget();
                } else {
                    this.nodeMap.get(edge.inputNode).reloadWidget();
                }
            });
        }
        this.copiedNodes.removeAll(removeNodes);
        this.updateComputeOrder();
    }

    public void openNodePanelDialog() {
    }

    public <T, C> MenuWidget<T, C> openMenu(double posX, double posY, TreeNode<T, C> menuNode) {
        MenuWidget<T, C> menu = new MenuWidget<T, C>((int)posX - this.parent.getPositionX(), (int)posY - this.parent.getPositionY(), 14, menuNode).setNodeTexture(MenuWidget.NODE_TEXTURE).setLeafTexture(MenuWidget.LEAF_TEXTURE).setNodeHoverTexture(MenuWidget.NODE_HOVER_TEXTURE);
        this.parent.waitToAdded(menu.setBackground(MenuWidget.BACKGROUND));
        return menu;
    }

    public void openMenu(double posX, double posY, TreeBuilder.Menu menuBuilder) {
        if (menuBuilder == null) {
            return;
        }
        this.openMenu(posX, posY, menuBuilder.build()).setCrossLinePredicate(TreeBuilder.Menu::isCrossLine).setKeyIconSupplier(TreeBuilder.Menu::getIcon).setKeyNameSupplier(TreeBuilder.Menu::getName).setOnNodeClicked(TreeBuilder.Menu::handle);
    }

    protected TreeBuilder.Menu createMenu(double mouseX, double mouseY) {
        TreeBuilder.Menu menu = TreeBuilder.Menu.start().branch(Icons.ADD, "add nodes", m -> this.nodeGroups.forEach((group, wrappers) -> m.branch((String)group, n -> {
            for (AnnotationDetector.Wrapper wrapper : wrappers) {
                n.leaf(((LDLRegister)wrapper.annotation()).name(), () -> this.addNode((BaseNode)wrapper.creator().get(), (int)mouseX, (int)mouseY));
            }
        })));
        if (!this.selectedNodes.isEmpty()) {
            List<BaseNode> canBeRemoved;
            menu.crossLine();
            if (this.selectedNodes.size() == 1) {
                menu.leaf("ldlib.gui.editor.menu.rename", () -> this.renameNode(this.selectedNodes.iterator().next()));
            }
            menu.leaf(Icons.COPY, "ldlib.gui.editor.menu.copy", () -> this.setCopy(this.selectedNodes));
            if (!this.copiedNodes.isEmpty()) {
                menu.leaf(Icons.PASTE, "ldlib.gui.editor.menu.paste", () -> this.pasteTo(mouseX, mouseY));
            }
            if (!(canBeRemoved = this.selectedNodes.stream().filter(BaseNode::isCanBeRemoved).toList()).isEmpty()) {
                menu.leaf(Icons.REMOVE, "ldlib.gui.editor.menu.remove", () -> {
                    this.removeNodes(canBeRemoved);
                    this.selectedNodes.clear();
                });
            }
        }
        return menu;
    }

    @Override
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.isDraggingArea) {
            int x = (int)Math.min(this.startMouseX, (double)mouseX);
            int y = (int)Math.min(this.startMouseY, (double)mouseY);
            int w = (int)Math.abs((double)mouseX - this.startMouseX);
            int h = (int)Math.abs((double)mouseY - this.startMouseY);
            DrawerHelper.drawBorder(graphics, x, y, w, h, ColorPattern.BLUE.color, 1);
            DrawerHelper.drawSolidRect(graphics, x, y, w, h, ColorPattern.T_LIGHT_BLUE.color);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawGraphLines(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (PortEdge edge : this.graph.edges) {
            NodePortWidget outputPort = this.nodeMap.get((Object)edge.outputNode).portMap.get(edge.outputPort);
            NodePortWidget inputPort = this.nodeMap.get((Object)edge.inputNode).portMap.get(edge.inputPort);
            if (inputPort == null) {
                LDLib.LOGGER.error("Edge {} input port {} are not existing: ", (Object)edge, (Object)edge.inputPort);
                continue;
            }
            if (outputPort == null) {
                LDLib.LOGGER.error("Edge {} output port {} are not existing: ", (Object)edge, (Object)edge.outputPort);
                continue;
            }
            Position outputPosition = outputPort.getPortPosition();
            Position inputPosition = inputPort.getPortPosition();
            this.drawEdge(graphics, outputPosition.vec2(), inputPosition.vec2(), outputPort.getPortColor(), inputPort.getPortColor());
        }
        if (this.clickedPort != null) {
            Vec2 outputPosition = this.clickedPort.isInput ? new Vec2((float)mouseX, (float)mouseY) : this.clickedPort.getPortPosition().vec2();
            Vec2 inputPosition = this.clickedPort.isInput ? this.clickedPort.getPortPosition().vec2() : new Vec2((float)mouseX, (float)mouseY);
            int inputColor = this.clickedPort.isInput ? this.clickedPort.getPortColor() : ColorPattern.BLUE.color;
            int outputColor = this.clickedPort.isInput ? ColorPattern.BLUE.color : this.clickedPort.getPortColor();
            this.drawEdge(graphics, outputPosition, inputPosition, outputColor, inputColor);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawEdge(GuiGraphics graphics, Vec2 outputPosition, Vec2 inputPosition, int startColor, int endColor) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.getBuilder();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        buffer.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        Vec2 outputController = outputPosition.add(new Vec2(20.0f, 0.0f));
        Vec2 inputController = inputPosition.add(new Vec2(-20.0f, 0.0f));
        RenderBufferUtils.drawColorLines(graphics.pose(), (VertexConsumer)buffer, List.of(outputPosition, outputController), startColor, startColor, 0.75f);
        RenderBufferUtils.drawColorLines(graphics.pose(), (VertexConsumer)buffer, List.of(outputController, inputController), startColor, endColor, 0.75f);
        RenderBufferUtils.drawColorLines(graphics.pose(), (VertexConsumer)buffer, List.of(inputController, inputPosition), endColor, endColor, 0.75f);
        tesselator.end();
        RenderSystem.defaultBlendFunc();
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (!this.selectedNodes.isEmpty() && Screen.isCopy((int)keyCode)) {
            this.setCopy(this.selectedNodes);
            return true;
        }
        if (!this.copiedNodes.isEmpty() && Screen.isPaste((int)keyCode)) {
            this.pasteTo(this.currentMouseX, this.currentMouseY);
            return true;
        }
        if (Screen.isSelectAll((int)keyCode)) {
            this.selectedNodes.clear();
            this.selectedNodes.addAll(this.nodeMap.keySet());
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (button == 1) {
                this.isDraggingArea = false;
                this.startMouseX = mouseX;
                this.startMouseY = mouseY;
                return true;
            }
            if (!GraphViewWidget.isShiftDown() && !GraphViewWidget.isCtrlDown()) {
                this.selectedNodes.clear();
            }
            if (super.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (this.lastClickTick != 0L && this.gui.getTickCount() - this.lastClickTick < 10L) {
                this.openNodePanelDialog();
                return true;
            }
            this.lastClickTick = this.gui.getTickCount();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean result = super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        this.isDraggingArea = button == 1 || this.isDraggingArea;
        return result;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean result = super.mouseReleased(mouseX, mouseY, button);
        this.clickedPort = null;
        if (!result && button == 1) {
            if (this.isDraggingArea) {
                Vector2d start = this.freeGraphView.getViewPosition(this.startMouseX, this.startMouseY);
                Vector2d end = this.freeGraphView.getViewPosition(mouseX, mouseY);
                Rect area = Rect.ofAbsolute((int)Math.min(start.x, end.x), (int)Math.max(end.x, start.x), (int)Math.min(start.y, end.y), (int)Math.max(end.y, start.y));
                this.selectedNodes.clear();
                for (NodeWidget widget : this.nodeMap.values()) {
                    if (!area.isCollide(widget.getRect())) continue;
                    this.selectedNodes.add(widget.getNode());
                }
                if (this.selectedNodes.isEmpty()) {
                    this.openMenu(mouseX, mouseY, this.createMenu(mouseX, mouseY));
                }
            } else {
                this.openMenu(mouseX, mouseY, this.createMenu(mouseX, mouseY));
            }
        }
        this.isDraggingArea = false;
        return result;
    }

    public BaseGraph getGraph() {
        return this.graph;
    }

    public FreeGraphView getFreeGraphView() {
        return this.freeGraphView;
    }

    public Map<BaseNode, NodeWidget> getNodeMap() {
        return this.nodeMap;
    }

    public DebugPanelWidget getDebugPanel() {
        return this.debugPanel;
    }

    public NodePanelWidget getNodePanel() {
        return this.nodePanel;
    }

    public ParameterPanelWidget getParameterPanel() {
        return this.parameterPanel;
    }

    public NodePortWidget getClickedPort() {
        return this.clickedPort;
    }

    @Nullable
    public BaseGraphProcessor getProcessor() {
        return this.processor;
    }

    public boolean isShowDebugInfo() {
        return this.showDebugInfo;
    }

    public boolean isRunStep() {
        return this.isRunStep;
    }

    public Iterator<BaseNode> getStepIterator() {
        return this.stepIterator;
    }

    @Nullable
    public BaseNode getStepNode() {
        return this.stepNode;
    }

    public Set<BaseNode> getSelectedNodes() {
        return this.selectedNodes;
    }

    public Set<BaseNode> getCopiedNodes() {
        return this.copiedNodes;
    }

    public boolean isDraggingArea() {
        return this.isDraggingArea;
    }

    public double getStartMouseX() {
        return this.startMouseX;
    }

    public double getStartMouseY() {
        return this.startMouseY;
    }

    public int getCurrentMouseX() {
        return this.currentMouseX;
    }

    public int getCurrentMouseY() {
        return this.currentMouseY;
    }

    public long getLastClickTick() {
        return this.lastClickTick;
    }

    public void setClickedPort(NodePortWidget clickedPort) {
        this.clickedPort = clickedPort;
    }

    public void setProcessor(@Nullable BaseGraphProcessor processor) {
        this.processor = processor;
    }

    public Map<String, List<AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode>>> getNodeGroups() {
        return this.nodeGroups;
    }

    public void setShowDebugInfo(boolean showDebugInfo) {
        this.showDebugInfo = showDebugInfo;
    }
}

