/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.widget;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.TriggerLink;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.NodeWidget;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TypeAdapter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class NodePortWidget
extends Widget {
    public final NodeWidget nodeWidget;
    public final boolean isInput;
    public final NodePort port;

    public NodePortWidget(NodeWidget nodeWidget, boolean isInput, NodePort port) {
        super(Position.ORIGIN, Size.ZERO);
        this.nodeWidget = nodeWidget;
        this.isInput = isInput;
        this.port = port;
        this.initPortInformation();
    }

    public void initPortInformation() {
        int width = 18;
        if (LDLib.isClient()) {
            width = 18 + Minecraft.getInstance().font.width(this.port.portData.displayName);
        }
        this.setSize(width, 15);
        ArrayList<String> tooltips = new ArrayList<String>();
        tooltips.add("Type: %s".formatted(this.getPortTypeName()));
        if (this.port.portData.tooltip != null && !this.port.portData.tooltip.isEmpty()) {
            tooltips.addAll(this.port.portData.tooltip);
        }
        this.setHoverTooltips(tooltips.toArray(new String[0]));
    }

    public String getDisplayName() {
        return this.port.portData.displayName;
    }

    public String getPortTypeName() {
        return TypeAdapter.getTypeDisplayName(this.port.portData.displayType);
    }

    public int getPortColor() {
        Class type = this.port.portData.displayType;
        if (type != null) {
            return TypeAdapter.getTypeColor(type);
        }
        return ColorPattern.BLUE.color;
    }

    public Position getPortPosition() {
        return this.isInput ? this.getPosition().add(7, 7) : this.getPosition().add(this.getSizeWidth() - 7, 7);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ResourceTexture icon;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        boolean isConnecting = !this.port.getEdges().isEmpty();
        boolean isTriggerLink = this.port.portData.displayType == TriggerLink.class;
        ResourceTexture resourceTexture = icon = isConnecting ? Icons.RADIOBOX_MARKED : Icons.RADIOBOX_BLANK;
        if (isTriggerLink) {
            icon = isConnecting ? Icons.CHECKBOX_MARKED : Icons.CHECKBOX_BLANK;
        }
        int color = this.getPortColor();
        boolean isHover = this.isMouseOverElement(mouseX, mouseY);
        NodePortWidget clickedPort = this.nodeWidget.getGraphView().getClickedPort();
        if (clickedPort == null) {
            color = isHover ? ColorPattern.GREEN.color : color;
        } else if (isHover && clickedPort != this && clickedPort.isInput != this.isInput) {
            NodePort inputPort;
            NodePort outputPort = clickedPort.isInput ? this.port : clickedPort.port;
            NodePort nodePort = inputPort = clickedPort.isInput ? clickedPort.port : this.port;
            if (BaseGraph.areTypesConnectable(outputPort.portData.displayType, inputPort.portData.displayType)) {
                color = ColorPattern.GREEN.color;
            }
        }
        if (this.isInput) {
            icon.copy().setColor(color).draw(graphics, mouseX, mouseY, this.getPositionX() + 4, this.getPositionY() + 3, 8, 8);
            graphics.drawString(Minecraft.getInstance().font, this.getDisplayName(), this.getPositionX() + 15, this.getPositionY() + 3, -1);
        } else {
            graphics.drawString(Minecraft.getInstance().font, this.getDisplayName(), this.getPositionX() + 3, this.getPositionY() + 3, -1);
            icon.copy().setColor(color).draw(graphics, mouseX, mouseY, this.getPositionX() + this.getSizeWidth() - 11, this.getPositionY() + 3, 8, 8);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && button == 0 && this.nodeWidget.getGraphView().getClickedPort() == null) {
            this.nodeWidget.getGraphView().setClickedPort(this);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        NodePortWidget clickedPort = this.nodeWidget.getGraphView().getClickedPort();
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (button == 0 && clickedPort != null && clickedPort != this && clickedPort.isInput != this.isInput) {
                NodePort inputPort;
                NodePort outputPort = clickedPort.isInput ? this.port : clickedPort.port;
                NodePort nodePort = inputPort = clickedPort.isInput ? clickedPort.port : this.port;
                if (BaseGraph.areTypesConnectable(outputPort.portData.displayType, inputPort.portData.displayType)) {
                    this.nodeWidget.getGraphView().addEdge(inputPort, outputPort);
                    this.nodeWidget.reloadWidget();
                    clickedPort.getNodeWidget().reloadWidget();
                }
            } else if (button == 1) {
                List<NodeWidget> updatedNodes = this.port.getEdges().stream().map(edge -> edge.inputNode == this.nodeWidget.getNode() ? edge.outputNode : edge.inputNode).map(node -> this.nodeWidget.getGraphView().getNodeMap().get(node)).toList();
                this.nodeWidget.getGraphView().removeEdge(this.port);
                this.nodeWidget.reloadWidget();
                updatedNodes.forEach(NodeWidget::reloadWidget);
                return true;
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public NodeWidget getNodeWidget() {
        return this.nodeWidget;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public NodePort getPort() {
        return this.port;
    }
}

