/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.IConfiguratorContainer;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.CollapsePortWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.GraphViewWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.NodePortWidget;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;

public class NodeWidget
extends WidgetGroup {
    private final BaseNode node;
    private final GraphViewWidget graphView;
    protected WidgetGroup title;
    protected WidgetGroup ports;
    protected WidgetGroup content;
    protected final Map<NodePort, NodePortWidget> portMap = new HashMap<NodePort, NodePortWidget>();
    protected boolean isDragging = false;
    protected double lastMouseX;
    protected double lastMouseY;
    protected Position lastPosition;
    protected long lastClickTime = 0L;

    public NodeWidget(GraphViewWidget graphView, BaseNode node) {
        super(node.position, new Size(node.getMinWidth(), 30));
        this.graphView = graphView;
        this.node = node;
        this.title = new WidgetGroup(0, 0, node.getMinWidth(), 15);
        this.addWidget(this.title);
        this.ports = new WidgetGroup(0, 15, node.getMinWidth(), 15);
        this.addWidget(this.ports);
        this.ports.setDynamicSized(true);
        this.ports.setLayout(Layout.HORIZONTAL_TOP);
        this.content = new WidgetGroup(0, 30, node.getMinWidth(), 0);
        this.addWidget(this.content);
        this.reloadWidget();
    }

    public void reloadWidget() {
        int width = 0;
        int height = 15;
        this.portMap.clear();
        this.title.clearAllWidgets();
        this.ports.clearAllWidgets();
        this.content.clearAllWidgets();
        if (this.node.isExpanded()) {
            width = Math.max(this.node.getMinWidth(), Minecraft.getInstance().font.width(this.node.getDisplayName()) + 10);
            WidgetGroup inputGroup = new WidgetGroup(0, 0, 0, 0);
            inputGroup.setBackground(ColorPattern.GRAY.rectTexture());
            int portHeight = Math.max(this.node.getInputPorts().size(), this.node.getOutputPorts().size()) * 15;
            int inputWidth = 0;
            for (NodePort port : this.node.getInputPorts()) {
                NodePortWidget portWidget = new NodePortWidget(this, true, port);
                inputWidth = Math.max(inputWidth, portWidget.getSizeWidth());
                inputGroup.addWidget(portWidget);
                this.portMap.put(port, portWidget);
            }
            WidgetGroup outputGroup = new WidgetGroup(0, 0, 0, 0);
            outputGroup.setBackground(ColorPattern.DARK_GRAY.rectTexture());
            int outputWidth = 0;
            for (NodePort port : this.node.getOutputPorts()) {
                NodePortWidget portWidget = new NodePortWidget(this, false, port);
                outputWidth = Math.max(outputWidth, portWidget.getSizeWidth());
                outputGroup.addWidget(portWidget);
                this.portMap.put(port, portWidget);
            }
            width = Math.max(width, inputWidth + outputWidth);
            float inputPercent = (float)inputWidth * 1.0f / (float)(inputWidth + outputWidth);
            inputGroup.setSize((int)(inputPercent * (float)width), portHeight);
            outputGroup.setSize(width - (int)(inputPercent * (float)width), portHeight);
            inputGroup.setLayout(Layout.VERTICAL_LEFT);
            outputGroup.setLayout(Layout.VERTICAL_RIGHT);
            this.ports.addWidget(inputGroup);
            this.ports.addWidget(outputGroup);
            this.ports.setVisible(true);
            height += this.ports.getSizeHeight();
            this.title.setBackground(new ColorRectTexture(this.node.getTitleColor()).setTopRadius(5.0f));
            this.title.setSize(width, 15);
            this.title.addWidget(new ImageWidget(5, 2, width - 10, 11, new TextTexture(this.node.getDisplayName()).setWidth(width - 10).setType(TextTexture.TextType.LEFT)));
            this.title.addWidget(new ImageWidget(0, -11, width, 1, new TextTexture(() -> this.graphView.isShowDebugInfo() ? "compute order: %d".formatted(this.node.getComputeOrder()) : "").setColor(ColorPattern.BRIGHT_RED.color)));
            this.title.addWidget(new ImageWidget(0, 14, width, 1, ColorPattern.BLACK.rectTexture()));
            ConfiguratorGroup group = new ConfiguratorGroup("", false);
            this.node.buildConfigurator(group);
            if (group.getConfigurators().isEmpty()) {
                this.content.setVisible(false);
                if (!inputGroup.widgets.isEmpty()) {
                    if (outputGroup.widgets.isEmpty()) {
                        inputGroup.setBackground(ColorPattern.GRAY.rectTexture().setBottomRadius(5.0f));
                    } else {
                        inputGroup.setBackground(ColorPattern.GRAY.rectTexture().setRadiusLB(5.0f));
                    }
                }
                if (!outputGroup.widgets.isEmpty()) {
                    if (inputGroup.widgets.isEmpty()) {
                        outputGroup.setBackground(ColorPattern.DARK_GRAY.rectTexture().setBottomRadius(5.0f));
                    } else {
                        outputGroup.setBackground(ColorPattern.DARK_GRAY.rectTexture().setRadiusRB(5.0f));
                    }
                }
                this.setSize(width, height);
            } else {
                IConfiguratorContainer computeLayout = this.getConfiguratorContainer(height, width, group);
                for (Configurator configurator : group.getConfigurators()) {
                    configurator.setConfiguratorContainer(computeLayout);
                    configurator.init(width - 4);
                    this.content.addWidget(configurator);
                }
                computeLayout.computeLayout();
            }
        } else {
            width = Minecraft.getInstance().font.width(this.node.getDisplayName()) + 10;
            CollapsePortWidget inputPort = null;
            for (Object port : this.node.getInputPorts()) {
                if (inputPort == null) {
                    inputPort = new CollapsePortWidget(this, (NodePort)port, true);
                }
                this.portMap.put((NodePort)port, inputPort);
            }
            CollapsePortWidget outputPort = null;
            for (NodePort port : this.node.getOutputPorts()) {
                if (outputPort == null) {
                    outputPort = new CollapsePortWidget(this, port, false);
                }
                this.portMap.put(port, outputPort);
            }
            int textWidth = width - 10;
            width += inputPort == null ? 0 : 10;
            width += outputPort == null ? 0 : 10;
            if (inputPort != null) {
                this.title.addWidget(inputPort);
                inputPort.setSelfPosition(0, 0);
            }
            if (outputPort != null) {
                this.title.addWidget(outputPort);
                outputPort.setSelfPosition(width - 15, 0);
            }
            this.title.setBackground(new ColorRectTexture(this.node.getTitleColor()).setRadius(5.0f));
            this.title.setSize(width, 15);
            this.title.addWidget(new ImageWidget(inputPort == null ? 5 : 15, 2, textWidth, 11, new TextTexture(this.node.getDisplayName()).setWidth(textWidth).setType(TextTexture.TextType.LEFT)));
            this.title.addWidget(new ImageWidget(0, -11, width, 1, new TextTexture(() -> this.graphView.isShowDebugInfo() ? "compute order: %d".formatted(this.node.getComputeOrder()) : "").setColor(ColorPattern.BRIGHT_RED.color)));
            this.content.setVisible(false);
            this.ports.setVisible(false);
            this.setSize(width, height);
        }
    }

    @NotNull
    private IConfiguratorContainer getConfiguratorContainer(int height, int width, ConfiguratorGroup group) {
        return () -> {
            int configHeight = 1;
            for (Configurator configurator : group.getConfigurators()) {
                configurator.computeHeight();
                configurator.setSelfPosition(new Position(2, configHeight));
                configHeight += configurator.getSize().height;
            }
            this.content.addWidget(new ImageWidget(0, 0, width, 1, ColorPattern.BLACK.rectTexture()));
            this.content.setVisible(true);
            this.content.setSelfPosition(new Position(0, height));
            this.content.setSize(width, configHeight);
            this.content.setBackground(new ColorRectTexture(ColorPattern.DARK_GRAY.color).setBottomRadius(5.0f));
            this.setSize(width, height + configHeight);
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Vector4f radius = new Vector4f(5.0f, 5.0f, 5.0f, 5.0f);
        if (this.isMouseOverElement(mouseX, mouseY) || this.graphView.getSelectedNodes().contains(this.node)) {
            DrawerHelper.drawFrameRoundBox(graphics, Rect.ofRelative(this.getPositionX(), this.getSizeWidth(), this.getPositionY(), this.getSizeHeight()), 1.0f, radius, radius, ColorPattern.BLUE.color);
        }
        if (this.graphView.isRunStep() && this.graphView.getStepNode() == this.node) {
            DrawerHelper.drawFrameRoundBox(graphics, Rect.ofRelative(this.getPositionX() - 3, this.getSizeWidth() + 6, this.getPositionY() - 3, this.getSizeHeight() + 6), 2.0f, radius, radius, ColorPattern.generateRainbowColor(this.gui.getTickCount()));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (button == 0 && this.title.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            long clickTime = this.gui.getTickCount();
            if (this.lastClickTime != 0L && clickTime - this.lastClickTime < 10L) {
                this.node.setExpanded(!this.node.isExpanded());
                this.reloadWidget();
                return true;
            }
            this.lastClickTime = clickTime;
            if (super.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            this.isDragging = true;
            this.lastPosition = this.getSelfPosition();
            for (BaseNode selectedNode : this.graphView.getSelectedNodes()) {
                NodeWidget widget = this.graphView.getNodeMap().get(selectedNode);
                widget.setLastPosition(widget.getSelfPosition());
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            this.setSelfPosition(this.lastPosition.add((int)(mouseX - this.lastMouseX), (int)(mouseY - this.lastMouseY)));
            this.node.setPosition(this.getSelfPosition());
            for (BaseNode selectedNode : this.graphView.getSelectedNodes()) {
                NodeWidget widget = this.graphView.getNodeMap().get(selectedNode);
                widget.setSelfPosition(widget.getLastPosition().add((int)(mouseX - this.lastMouseX), (int)(mouseY - this.lastMouseY)));
                selectedNode.setPosition(widget.getSelfPosition());
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        if (this.isMouseOverElement(mouseX, mouseY) && button == 0) {
            if (super.mouseReleased(mouseX, mouseY, button)) {
                return true;
            }
            if (!NodeWidget.isShiftDown() && !NodeWidget.isCtrlDown()) {
                this.graphView.getSelectedNodes().clear();
            }
            this.graphView.getSelectedNodes().add(this.node);
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public BaseNode getNode() {
        return this.node;
    }

    public GraphViewWidget getGraphView() {
        return this.graphView;
    }

    public WidgetGroup getTitle() {
        return this.title;
    }

    public WidgetGroup getPorts() {
        return this.ports;
    }

    public WidgetGroup getContent() {
        return this.content;
    }

    public Map<NodePort, NodePortWidget> getPortMap() {
        return this.portMap;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public double getLastMouseX() {
        return this.lastMouseX;
    }

    public double getLastMouseY() {
        return this.lastMouseY;
    }

    public Position getLastPosition() {
        return this.lastPosition;
    }

    public long getLastClickTime() {
        return this.lastClickTime;
    }

    public void setLastPosition(Position lastPosition) {
        this.lastPosition = lastPosition;
    }
}

