/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.modular;

import com.lowdragmc.lowdraglib.core.mixins.accessor.AbstractContainerMenuAccessor;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.WidgetUIAccess;
import com.lowdragmc.lowdraglib.gui.util.PerTickIntCounter;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.networking.LDLNetworking;
import com.lowdragmc.lowdraglib.networking.c2s.CPacketUIClientAction;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketUIWidgetUpdate;
import io.netty.buffer.Unpooled;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ModularUIContainer
extends AbstractContainerMenu
implements WidgetUIAccess {
    public static final MenuType<ModularUIContainer> MENUTYPE = new MenuType((i, inventory) -> new ModularUIContainer(i), FeatureFlags.DEFAULT_FLAGS);
    private final ModularUI modularUI;
    private final PerTickIntCounter transferredPerTick = new PerTickIntCounter(0);

    public ModularUIContainer(ModularUI modularUI, int windowID) {
        super(MENUTYPE, windowID);
        this.modularUI = modularUI;
        this.modularUI.setModularUIContainer(this);
        modularUI.mainGroup.setUiAccess(this);
    }

    private ModularUIContainer(int windowID) {
        super(null, windowID);
        this.modularUI = null;
    }

    @Nonnull
    public Slot addSlot(@Nonnull Slot slotHandle) {
        OptionalInt emptySlotIndex = this.slots.stream().filter(it -> it instanceof EmptySlotPlaceholder).mapToInt(slot -> slot.index).findFirst();
        if (emptySlotIndex.isPresent()) {
            slotHandle.index = emptySlotIndex.getAsInt();
            this.slots.set(slotHandle.index, (Object)slotHandle);
            ((AbstractContainerMenuAccessor)((Object)this)).getLastSlots().set(slotHandle.index, (Object)ItemStack.EMPTY);
            ((AbstractContainerMenuAccessor)((Object)this)).getRemoteSlots().set(slotHandle.index, (Object)ItemStack.EMPTY);
        } else {
            slotHandle.index = this.slots.size();
            this.slots.add((Object)slotHandle);
            ((AbstractContainerMenuAccessor)((Object)this)).getLastSlots().add((Object)ItemStack.EMPTY);
            ((AbstractContainerMenuAccessor)((Object)this)).getRemoteSlots().add((Object)ItemStack.EMPTY);
        }
        return slotHandle;
    }

    public void removeSlot(Slot slotHandle) {
        EmptySlotPlaceholder emptySlotPlaceholder = new EmptySlotPlaceholder();
        emptySlotPlaceholder.index = slotHandle.index;
        this.slots.set(slotHandle.index, (Object)emptySlotPlaceholder);
        ((AbstractContainerMenuAccessor)((Object)this)).getLastSlots().set(slotHandle.index, (Object)ItemStack.EMPTY);
        ((AbstractContainerMenuAccessor)((Object)this)).getRemoteSlots().set(slotHandle.index, (Object)ItemStack.EMPTY);
    }

    public ModularUI getModularUI() {
        return this.modularUI;
    }

    public void removed(@Nonnull Player playerIn) {
        super.removed(playerIn);
        this.modularUI.triggerCloseListeners();
    }

    public void addSlotListener(@Nonnull ContainerListener pListener) {
        super.addSlotListener(pListener);
        this.modularUI.mainGroup.detectAndSendChanges();
    }

    public void broadcastChanges() {
        Player player;
        super.broadcastChanges();
        if (this.modularUI.holder.isInvalid() && (player = this.modularUI.entityPlayer) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.closeContainer();
        }
        this.modularUI.mainGroup.detectAndSendChanges();
        this.modularUI.addTick();
    }

    public void clicked(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        if (slotId >= 0 && slotId < this.slots.size()) {
            Slot slot = this.getSlot(slotId);
            ItemStack result = this.modularUI.getSlotMap().get(slot).slotClick(dragType, clickTypeIn, player);
            if (result == null) {
                super.clicked(slotId, dragType, clickTypeIn, player);
            }
        }
        if (slotId == -999) {
            super.clicked(slotId, dragType, clickTypeIn, player);
        }
    }

    private List<SlotWidget> getShiftClickSlots(ItemStack itemStack, boolean fromContainer) {
        return this.modularUI.getSlotMap().values().stream().filter(it -> it.canMergeSlot(itemStack)).filter(it -> it.isPlayerContainer == fromContainer).sorted(Comparator.comparing(s -> (fromContainer ? -1 : 1) * s.getHandler().index)).collect(Collectors.toList());
    }

    @Override
    public boolean attemptMergeStack(ItemStack itemStack, boolean fromContainer, boolean simulate) {
        List<Slot> slots = this.getShiftClickSlots(itemStack, fromContainer).stream().map(SlotWidget::getHandler).collect(Collectors.toList());
        return ModularUIContainer.mergeItemStack(itemStack, slots, simulate);
    }

    public static boolean mergeItemStack(ItemStack itemStack, List<Slot> slots, boolean simulate) {
        if (itemStack.isEmpty()) {
            return false;
        }
        boolean merged = false;
        for (Slot slot : slots) {
            ItemStack stackInSlot;
            if (!slot.mayPlace(itemStack) || !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)(stackInSlot = slot.getItem())) || !ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)stackInSlot)) continue;
            int slotMaxStackSize = Math.min(stackInSlot.getMaxStackSize(), slot.getMaxStackSize(stackInSlot));
            int amountToInsert = Math.min(itemStack.getCount(), slotMaxStackSize - stackInSlot.getCount());
            if (amountToInsert == 0) continue;
            if (!simulate) {
                stackInSlot.grow(amountToInsert);
            }
            itemStack.shrink(amountToInsert);
            slot.setChanged();
            merged = true;
            if (!itemStack.isEmpty()) continue;
            return true;
        }
        for (Slot slot : slots) {
            int amountToInsert;
            if (!slot.mayPlace(itemStack) || slot.hasItem() || (amountToInsert = Math.min(itemStack.getCount(), slot.getMaxStackSize(itemStack))) == 0) continue;
            ItemStack stackInSlot = itemStack.split(amountToInsert);
            if (!simulate) {
                slot.set(stackInSlot);
            }
            merged = true;
            if (!itemStack.isEmpty()) continue;
            return true;
        }
        return merged;
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        boolean fromContainer;
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.mayPickup(player)) {
            return ItemStack.EMPTY;
        }
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = slot.getItem();
        ItemStack stackToMerge = stackInSlot.copy();
        boolean bl = fromContainer = !this.modularUI.getSlotMap().get((Object)slot).isPlayerContainer;
        if (!this.attemptMergeStack(stackToMerge, fromContainer, true)) {
            return ItemStack.EMPTY;
        }
        int itemsMerged = stackToMerge.isEmpty() || this.modularUI.getSlotMap().get(slot).canMergeSlot(stackToMerge) ? stackInSlot.getCount() - stackToMerge.getCount() : stackInSlot.getCount();
        int itemsToExtract = itemsMerged;
        if ((itemsMerged += this.transferredPerTick.get(player.level())) > stackInSlot.getMaxStackSize()) {
            return ItemStack.EMPTY;
        }
        this.transferredPerTick.increment(player.level(), itemsToExtract);
        ItemStack extractedStack = stackInSlot.split(itemsToExtract);
        if (stackInSlot.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        ItemStack resultStack = extractedStack.copy();
        if (!this.attemptMergeStack(extractedStack, fromContainer, false)) {
            resultStack = ItemStack.EMPTY;
        }
        if (!extractedStack.isEmpty()) {
            player.drop(extractedStack, false, false);
            resultStack = ItemStack.EMPTY;
        }
        return resultStack;
    }

    public boolean canTakeItemForPickAll(@Nonnull ItemStack stack, @Nonnull Slot slotIn) {
        return this.modularUI.getSlotMap().get(slotIn).canMergeSlot(stack);
    }

    public boolean stillValid(@Nonnull Player playerIn) {
        return true;
    }

    @Override
    public void writeClientAction(Widget widget, int updateId, Consumer<FriendlyByteBuf> payloadWriter) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
        packetBuffer.writeVarInt(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof AbstractClientPlayer) {
            LDLNetworking.NETWORK.sendToServer(new CPacketUIClientAction(this.containerId, packetBuffer));
        }
    }

    @Override
    public void writeUpdateInfo(Widget widget, int updateId, Consumer<FriendlyByteBuf> payloadWriter) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
        packetBuffer.writeVarInt(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof ServerPlayer) {
            SPacketUIWidgetUpdate widgetUpdate = new SPacketUIWidgetUpdate(this.containerId, packetBuffer);
            LDLNetworking.NETWORK.sendToPlayer(widgetUpdate, (ServerPlayer)this.modularUI.entityPlayer);
        }
    }

    public void handleClientAction(CPacketUIClientAction packet) {
        if (packet.windowId == this.containerId) {
            int updateId = packet.updateData.readVarInt();
            this.modularUI.mainGroup.handleClientAction(updateId, packet.updateData);
        }
    }

    private static class EmptySlotPlaceholder
    extends Slot {
        private static final Container EMPTY_INVENTORY = new SimpleContainer(0);

        public EmptySlotPlaceholder() {
            super(EMPTY_INVENTORY, 0, -100000, -100000);
        }

        @Nonnull
        public ItemStack getItem() {
            return ItemStack.EMPTY;
        }

        public void set(@Nonnull ItemStack stack) {
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return false;
        }

        public boolean mayPickup(@Nonnull Player playerIn) {
            return false;
        }

        public boolean isActive() {
            return false;
        }
    }
}

