/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.modular;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.core.mixins.accessor.AbstractContainerScreenAccessor;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketUIWidgetUpdate;
import com.lowdragmc.lowdraglib.side.ForgeEventHooks;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModularUIGuiContainer
extends AbstractContainerScreen<ModularUIContainer> {
    public final ModularUI modularUI;
    public Widget lastFocus;
    public boolean focused;
    public int dragSplittingLimit;
    public int dragSplittingButton;
    @Nullable
    public List<Component> tooltipTexts;
    @Nullable
    public TooltipComponent tooltipComponent;
    @Nullable
    public Font tooltipFont;
    @Nullable
    public ItemStack tooltipStack = ItemStack.EMPTY;
    protected Tuple<Object, IGuiTexture> draggingElement;
    protected int pressedButton = -1;

    public ModularUIGuiContainer(ModularUI modularUI, int windowId) {
        super((AbstractContainerMenu)new ModularUIContainer(modularUI, windowId), modularUI.entityPlayer.getInventory(), Component.nullToEmpty((String)"modularUI"));
        this.modularUI = modularUI;
        modularUI.setModularUIGui(this);
    }

    public void setHoverTooltip(List<Component> tooltipTexts, ItemStack tooltipStack, @Nullable Font tooltipFont, @Nullable TooltipComponent tooltipComponent) {
        this.tooltipTexts = tooltipTexts;
        this.tooltipStack = tooltipStack;
        this.tooltipFont = tooltipFont;
        this.tooltipComponent = tooltipComponent;
    }

    public boolean setDraggingElement(Object element, IGuiTexture renderer) {
        if (this.draggingElement != null) {
            return false;
        }
        this.draggingElement = new Tuple(element, (Object)renderer);
        return true;
    }

    @Nullable
    public Object getDraggingElement() {
        if (this.draggingElement == null) {
            return null;
        }
        return this.draggingElement.getA();
    }

    public void init() {
        this.imageWidth = this.modularUI.getWidth();
        this.imageHeight = this.modularUI.getHeight();
        super.init();
        this.modularUI.updateScreenSize(this.width, this.height);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
    }

    public void removed() {
        super.removed();
    }

    public void containerTick() {
        Player player;
        super.containerTick();
        if (this.modularUI.holder.isInvalid() && (player = this.modularUI.entityPlayer) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.closeContainer();
        }
        this.modularUI.mainGroup.updateScreen();
        this.modularUI.addTick();
    }

    public void handleWidgetUpdate(SPacketUIWidgetUpdate packet) {
        if (packet.windowId == ((ModularUIContainer)this.getMenu()).containerId) {
            int updateId = packet.updateData.readVarInt();
            this.modularUI.mainGroup.readUpdateInfo(updateId, packet.updateData);
        }
    }

    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.hoveredSlot = null;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        this.tooltipTexts = null;
        this.tooltipComponent = null;
        this.renderBackground(graphics);
        if (Platform.isForge()) {
            ForgeEventHooks.postBackgroundRenderedEvent((Screen)this, graphics);
        }
        this.modularUI.mainGroup.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (Platform.isForge()) {
            ForgeEventHooks.postRenderBackgroundEvent(this, graphics, mouseX, mouseY);
        }
        if (LDLib.isEmiLoaded()) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            EmiScreenManager.render((EmiDrawContext)EmiDrawContext.wrap((GuiGraphics)graphics), (int)mouseX, (int)mouseY, (float)partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
        }
        this.modularUI.mainGroup.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        if (this.draggingElement != null) {
            ((IGuiTexture)this.draggingElement.getB()).draw(graphics, mouseX, mouseY, mouseX - 20, mouseY - 20, 40, 40);
        }
        graphics.bufferSource().endBatch();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        PoseStack posestack = graphics.pose();
        posestack.pushPose();
        posestack.translate((float)this.leftPos, (float)this.topPos, 232.0f);
        if (Platform.isForge()) {
            ForgeEventHooks.postRenderForegroundEvent(this, graphics, mouseX, mouseY);
        }
        this.renderItemStackOnMouse(graphics, mouseX, mouseY);
        this.renderReturningItemStack(graphics);
        graphics.bufferSource().endBatch();
        posestack.popPose();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        if (LDLib.isEmiLoaded()) {
            posestack.pushPose();
            posestack.translate(0.0f, 0.0f, 200.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            EmiScreenManager.drawForeground((EmiDrawContext)EmiDrawContext.wrap((GuiGraphics)graphics), (int)mouseX, (int)mouseY, (float)partialTicks);
            posestack.popPose();
        }
        if (this.draggingElement == null && this.tooltipTexts != null && !this.tooltipTexts.isEmpty()) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 200.0f);
            DrawerHelper.drawTooltip(graphics, mouseX, mouseY, this.tooltipTexts, this.tooltipStack, this.tooltipComponent, this.tooltipFont == null ? Minecraft.getInstance().font : this.tooltipFont);
            graphics.pose().popPose();
        }
    }

    public void setHoveredSlot(Slot hoveredSlot) {
        if (this.modularUI.mainGroup.isClientSideWidget() && !this.modularUI.mainGroup.isAllowXEIIngredientOverMouse()) {
            return;
        }
        this.hoveredSlot = hoveredSlot;
    }

    private void renderItemStackOnMouse(GuiGraphics graphics, int mouseX, int mouseY) {
        ItemStack itemstack;
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        ItemStack draggedStack = ((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem();
        ItemStack itemStack = itemstack = draggedStack.isEmpty() ? ((ModularUIContainer)this.getMenu()).getCarried() : draggedStack;
        if (!itemstack.isEmpty()) {
            int k2 = draggedStack.isEmpty() ? 8 : 16;
            String s = null;
            if (!draggedStack.isEmpty() && ((AbstractContainerScreenAccessor)((Object)this)).isSplittingStack()) {
                itemstack = itemstack.copy();
                itemstack.setCount((int)Math.ceil((float)itemstack.getCount() / 2.0f));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1) {
                itemstack = itemstack.copy();
                itemstack.setCount(((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingRemainder());
                if (itemstack.isEmpty()) {
                    s = String.valueOf(ChatFormatting.YELLOW) + "0";
                }
            }
            this.renderFloatingItem(graphics, itemstack, mouseX - this.leftPos - 8, mouseY - this.topPos - k2, s);
        }
    }

    public void renderFloatingItem(GuiGraphics graphics, ItemStack stack, int x, int y, @Nullable String amountText) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 232.0f);
        graphics.renderItem(stack, x, y);
        graphics.renderItemDecorations(this.font, stack, x, y - (((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().isEmpty() ? 0 : 8), amountText);
        graphics.pose().popPose();
    }

    private void renderReturningItemStack(GuiGraphics graphics) {
        if (!((AbstractContainerScreenAccessor)((Object)this)).getSnapbackItem().isEmpty()) {
            float f = (float)(Util.getMillis() - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackTime()) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                ((AbstractContainerScreenAccessor)((Object)this)).setSnapbackItem(ItemStack.EMPTY);
            }
            int l2 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackEnd().x - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartX();
            int i3 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackEnd().y - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartY();
            int l1 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartX() + (int)((float)l2 * f);
            int i2 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartY() + (int)((float)i3 * f);
            this.renderFloatingItem(graphics, ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackItem(), l1, i2, null);
        }
    }

    public boolean switchFocus(@Nonnull Widget widget) {
        if (this.focused) {
            return false;
        }
        this.focused = true;
        if (this.lastFocus == widget) {
            return false;
        }
        Widget l = this.lastFocus;
        this.lastFocus = widget;
        if (l != null) {
            l.setFocus(false);
        }
        return true;
    }

    public Set<Slot> getQuickCraftSlots() {
        return this.quickCraftSlots;
    }

    public boolean getQuickCrafting() {
        return this.isQuickCrafting;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int pButton) {
        this.pressedButton = pButton;
        this.focused = false;
        if (this.modularUI.mainGroup.mouseClicked(mouseX, mouseY, pButton)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.mouseClicked(mouseX, mouseY, pButton)) continue;
            this.setFocused(guiEventListener);
            if (pButton == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int pButton, double pDragX, double pDragY) {
        this.focused = false;
        if (this.modularUI.mainGroup.mouseDragged(mouseX, mouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        if (this.getFocused() != null && this.isDragging() && pButton == 0) {
            return this.getFocused().mouseDragged(mouseX, mouseY, pButton, pDragX, pDragY);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int pButton) {
        this.pressedButton = -1;
        this.focused = false;
        boolean result = this.modularUI.mainGroup.mouseReleased(mouseX, mouseY, pButton);
        this.draggingElement = null;
        if (result) {
            return true;
        }
        this.setDragging(false);
        return this.getChildAt(mouseX, mouseY).filter(guiEventListener -> guiEventListener.mouseReleased(mouseX, mouseY, pButton)).isPresent();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.focused = false;
        if (this.modularUI.mainGroup.keyPressed(keyCode, scanCode, modifiers)) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double wheelDelta) {
        this.focused = false;
        if (this.modularUI.mainGroup.mouseWheelMove(mouseX, mouseY, wheelDelta)) {
            return true;
        }
        return this.getChildAt(mouseX, mouseY).filter(element -> element.mouseScrolled(mouseX, mouseY, wheelDelta)).isPresent();
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.focused = false;
        if (this.modularUI.mainGroup.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.getFocused() != null && this.getFocused().keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        this.focused = false;
        if (this.modularUI.mainGroup.charTyped(codePoint, modifiers)) {
            return true;
        }
        return this.getFocused() != null && this.getFocused().charTyped(codePoint, modifiers);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.focused = false;
        this.modularUI.mainGroup.mouseMoved(mouseX, mouseY);
    }

    public boolean isButtonPressed(int button) {
        return this.pressedButton == button;
    }

    public void superMouseClicked(double mouseX, double mouseY, int mouseButton) {
        try {
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void superMouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void superMouseReleased(double mouseX, double mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
    }

    public boolean superKeyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean superMouseScrolled(double mouseX, double mouseY, double wheelDelta) {
        return super.mouseScrolled(mouseX, mouseY, wheelDelta);
    }

    public boolean superKeyReleased(int keyCode, int scanCode, int modifiers) {
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean superCharTyped(char codePoint, int modifiers) {
        return super.charTyped(codePoint, modifiers);
    }

    public void superMouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
    }

    public List<Rect2i> getGuiExtraAreas() {
        return this.modularUI.mainGroup.getGuiExtraAreas(this.modularUI.mainGroup.toRectangleBox(), new ArrayList<Rect2i>());
    }
}

