/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@LDLRegister(name="animation_texture", group="texture")
public class AnimationTexture
extends TransformTexture {
    @Configurable(name="ldlib.gui.editor.name.resource")
    public ResourceLocation imageLocation;
    @Configurable(tips={"ldlib.gui.editor.tips.cell_size"})
    @NumberRange(range={1.0, 2.147483647E9})
    protected int cellSize;
    @Configurable(tips={"ldlib.gui.editor.tips.cell_from"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int from;
    @Configurable(tips={"ldlib.gui.editor.tips.cell_to"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int to;
    @Configurable(tips={"ldlib.gui.editor.tips.cell_animation"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int animation;
    @Configurable
    @NumberColor
    protected int color = -1;
    protected int currentFrame;
    protected int currentTime;
    private long lastTick;

    public AnimationTexture() {
        this("ldlib:textures/gui/particles.png");
        this.setCellSize(8).setAnimation(32, 44).setAnimation(1);
    }

    public AnimationTexture(String imageLocation) {
        this.imageLocation = new ResourceLocation(imageLocation);
    }

    public AnimationTexture(ResourceLocation imageLocation) {
        this.imageLocation = imageLocation;
    }

    @Override
    public AnimationTexture copy() {
        return new AnimationTexture(this.imageLocation).setCellSize(this.cellSize).setAnimation(this.from, this.to).setAnimation(this.animation).setColor(this.color);
    }

    public AnimationTexture setTexture(String imageLocation) {
        this.imageLocation = new ResourceLocation(imageLocation);
        return this;
    }

    public AnimationTexture setCellSize(int cellSize) {
        this.cellSize = cellSize;
        return this;
    }

    public AnimationTexture setAnimation(int from, int to) {
        this.currentFrame = from;
        this.from = from;
        this.to = to;
        return this;
    }

    public AnimationTexture setAnimation(int animation) {
        this.animation = animation;
        return this;
    }

    @Override
    public AnimationTexture setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateTick() {
        if (Minecraft.getInstance().level != null) {
            long tick = Minecraft.getInstance().level.getGameTime();
            if (tick == this.lastTick) {
                return;
            }
            this.lastTick = tick;
        }
        if (this.currentTime >= this.animation) {
            this.currentTime = 0;
            ++this.currentFrame;
        } else {
            ++this.currentTime;
        }
        if (this.currentFrame > this.to) {
            this.currentFrame = this.from;
        } else if (this.currentFrame < this.from) {
            this.currentFrame = this.from;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        this.updateTick();
        float cell = 1.0f / (float)this.cellSize;
        int X = this.currentFrame % this.cellSize;
        int Y = this.currentFrame / this.cellSize;
        float imageU = (float)X * cell;
        float imageV = (float)Y * cell;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.imageLocation);
        Matrix4f matrix4f = graphics.pose().last().pose();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.vertex(matrix4f, x, y + (float)height, 0.0f).uv(imageU, imageV + cell).color(this.color).endVertex();
        bufferbuilder.vertex(matrix4f, x + (float)width, y + (float)height, 0.0f).uv(imageU + cell, imageV + cell).color(this.color).endVertex();
        bufferbuilder.vertex(matrix4f, x + (float)width, y, 0.0f).uv(imageU + cell, imageV).color(this.color).endVertex();
        bufferbuilder.vertex(matrix4f, x, y, 0.0f).uv(imageU, imageV).color(this.color).endVertex();
        tessellator.end();
    }

    @Override
    public void createPreview(ConfiguratorGroup father) {
        super.createPreview(father);
        WrapperConfigurator base = new WrapperConfigurator("ldlib.gui.editor.group.base_image", wrapper -> {
            WidgetGroup widgetGroup = new WidgetGroup(0, 0, 100, 100);
            ImageWidget imageWidget = new ImageWidget(0, 0, 100, 100, new GuiTextureGroup(new ResourceTexture(this.imageLocation.toString()), this::drawGuides)).setBorder(2, ColorPattern.T_WHITE.color);
            widgetGroup.addWidget(imageWidget);
            widgetGroup.addWidget(new ButtonWidget(0, 0, 100, 100, IGuiTexture.EMPTY, cd -> {
                if (Editor.INSTANCE == null) {
                    return;
                }
                File path = new File(Editor.INSTANCE.getWorkSpace(), "textures");
                DialogWidget.showFileDialog(Editor.INSTANCE, "ldlib.gui.editor.tips.select_image", path, true, DialogWidget.suffixFilter(".png"), r -> {
                    if (r != null && r.isFile()) {
                        this.imageLocation = this.getTextureFromFile(path, (File)r);
                        this.cellSize = 1;
                        this.from = 0;
                        this.to = 0;
                        this.animation = 0;
                        imageWidget.setImage(new GuiTextureGroup(new ResourceTexture(this.imageLocation.toString()), this::drawGuides));
                        wrapper.notifyChanges();
                    }
                });
            }));
            return widgetGroup;
        });
        base.setTips("ldlib.gui.editor.tips.click_select_image");
        father.addConfigurators(base);
    }

    private ResourceLocation getTextureFromFile(File path, File r) {
        String id = path.getPath().replace('\\', '/').split("assets/")[1].split("/")[0];
        return new ResourceLocation(id, r.getPath().replace(path.getPath(), "textures").replace('\\', '/'));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawGuides(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        float cell = 1.0f / (float)this.cellSize;
        int X = this.from % this.cellSize;
        int Y = this.from / this.cellSize;
        float imageU = (float)X * cell;
        float imageV = (float)Y * cell;
        new ColorBorderTexture(-1, -16711936).draw(graphics, 0, 0, x + (float)width * imageU, y + (float)height * imageV, (int)((float)width * cell), (int)((float)height * cell));
        X = this.to % this.cellSize;
        Y = this.to / this.cellSize;
        imageU = (float)X * cell;
        imageV = (float)Y * cell;
        new ColorBorderTexture(-1, -65536).draw(graphics, 0, 0, x + (float)width * imageU, y + (float)height * imageV, (int)((float)width * cell), (int)((float)height * cell));
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getAnimation() {
        return this.animation;
    }

    public int getColor() {
        return this.color;
    }
}

