/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public interface IGuiTexture
extends IConfigurable {
    public static final IGuiTexture EMPTY = new IGuiTexture(){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        }
    };
    public static final IGuiTexture MISSING_TEXTURE = new IGuiTexture(){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
            Tesselator tessellator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tessellator.getBuilder();
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureManager.INTENTIONAL_MISSING_TEXTURE);
            Matrix4f matrix4f = graphics.pose().last().pose();
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.vertex(matrix4f, x, y + (float)height, 0.0f).uv(0.0f, 1.0f).endVertex();
            bufferbuilder.vertex(matrix4f, x + (float)width, y + (float)height, 0.0f).uv(1.0f, 1.0f).endVertex();
            bufferbuilder.vertex(matrix4f, x + (float)width, y, 0.0f).uv(1.0f, 0.0f).endVertex();
            bufferbuilder.vertex(matrix4f, x, y, 0.0f).uv(0.0f, 0.0f).endVertex();
            tessellator.end();
        }
    };
    public static final Function<String, AnnotationDetector.Wrapper<LDLRegister, IGuiTexture>> CACHE = Util.memoize(type -> {
        for (AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> wrapper : AnnotationDetector.REGISTER_TEXTURES) {
            if (!wrapper.annotation().name().equals(type)) continue;
            return wrapper;
        }
        return null;
    });

    default public IGuiTexture setColor(int color) {
        return this;
    }

    default public IGuiTexture rotate(float degree) {
        return this;
    }

    default public IGuiTexture scale(float scale) {
        return this;
    }

    default public IGuiTexture transform(int xOffset, int yOffset) {
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics var1, int var2, int var3, float var4, float var5, int var6, int var7);

    @OnlyIn(value=Dist.CLIENT)
    default public void updateTick() {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void drawSubArea(GuiGraphics graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        this.draw(graphics, 0, 0, x, y, (int)width, (int)height);
    }

    default public IGuiTexture copy() {
        CompoundTag tag = IGuiTexture.serializeWrapper(this);
        return tag == null ? this : IGuiTexture.deserializeWrapper(tag);
    }

    default public void createPreview(ConfiguratorGroup father) {
        father.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", new ImageWidget(0, 0, 100, 100, this).setBorder(2, ColorPattern.T_WHITE.color)));
    }

    @Override
    default public void buildConfigurator(ConfiguratorGroup father) {
        this.createPreview(father);
        IConfigurable.super.buildConfigurator(father);
    }

    @Nullable
    public static CompoundTag serializeWrapper(IGuiTexture texture) {
        if (texture.isLDLRegister()) {
            CompoundTag tag = new CompoundTag();
            tag.putString("type", texture.name());
            CompoundTag data = new CompoundTag();
            PersistedParser.serializeNBT(data, texture.getClass(), texture);
            tag.put("data", (Tag)data);
            return tag;
        }
        return null;
    }

    @NotNull
    public static IGuiTexture deserializeWrapper(CompoundTag tag) {
        String type = tag.getString("type");
        CompoundTag data = tag.getCompound("data");
        AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> wrapper = CACHE.apply(type);
        IGuiTexture value = wrapper == null ? EMPTY : wrapper.creator().get();
        PersistedParser.deserializeNBT(data, new HashMap<String, Method>(), value.getClass(), value);
        return value;
    }

    default public void setUIResource(Resource<IGuiTexture> texturesResource) {
    }
}

