/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@LDLRegister(name="resource_texture", group="texture")
public class ResourceTexture
extends TransformTexture {
    @Configurable(name="ldlib.gui.editor.name.resource", forceUpdate=false)
    public ResourceLocation imageLocation = new ResourceLocation("ldlib:textures/gui/icon.png");
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=0.02)
    public float offsetX = 0.0f;
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=0.02)
    public float offsetY = 0.0f;
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=0.02)
    public float imageWidth = 1.0f;
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=0.02)
    public float imageHeight = 1.0f;
    @Configurable
    @NumberColor
    protected int color = -1;
    protected IntSupplier dynamicColor = () -> this.color;

    public ResourceTexture(ResourceLocation imageLocation, float offsetX, float offsetY, float width, float height) {
        this.imageLocation = imageLocation;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.imageWidth = width;
        this.imageHeight = height;
    }

    public ResourceTexture(String imageLocation) {
        this(new ResourceLocation(imageLocation));
    }

    public ResourceTexture(ResourceLocation imageLocation) {
        this(imageLocation, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public ResourceTexture getSubTexture(float offsetX, float offsetY, float width, float height) {
        return new ResourceTexture(this.imageLocation, this.offsetX + this.imageWidth * offsetX, this.offsetY + this.imageHeight * offsetY, this.imageWidth * width, this.imageHeight * height);
    }

    public ResourceTexture getSubTexture(double offsetX, double offsetY, double width, double height) {
        return new ResourceTexture(this.imageLocation, this.offsetX + (float)((double)this.imageWidth * offsetX), this.offsetY + (float)((double)this.imageHeight * offsetY), this.imageWidth * (float)width, this.imageHeight * (float)height);
    }

    @Override
    public ResourceTexture copy() {
        return this.getSubTexture(0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    public ResourceTexture setColor(int color) {
        this.color = color;
        return this;
    }

    public ResourceTexture setDynamicColor(IntSupplier color) {
        this.dynamicColor = color;
        return this;
    }

    public static ResourceTexture fromSpirit(ResourceLocation texture) {
        if (LDLib.isClient()) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture);
            return new ResourceTexture(TextureAtlas.LOCATION_BLOCKS, sprite.getU0(), sprite.getV0(), sprite.getU1() - sprite.getU0(), sprite.getV1() - sprite.getV0());
        }
        return new ResourceTexture("");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        this.drawSubArea(graphics, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawSubAreaInternal(GuiGraphics graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        float imageU = this.offsetX + this.imageWidth * drawnU;
        float imageV = this.offsetY + this.imageHeight * drawnV;
        float imageWidth = this.imageWidth * drawnWidth;
        float imageHeight = this.imageHeight * drawnHeight;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.imageLocation);
        Matrix4f matrix4f = graphics.pose().last().pose();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        int color = this.dynamicColor.getAsInt();
        bufferbuilder.vertex(matrix4f, x, y + height, 0.0f).uv(imageU, imageV + imageHeight).color(color).endVertex();
        bufferbuilder.vertex(matrix4f, x + width, y + height, 0.0f).uv(imageU + imageWidth, imageV + imageHeight).color(color).endVertex();
        bufferbuilder.vertex(matrix4f, x + width, y, 0.0f).uv(imageU + imageWidth, imageV).color(color).endVertex();
        bufferbuilder.vertex(matrix4f, x, y, 0.0f).uv(imageU, imageV).color(color).endVertex();
        tessellator.end();
    }

    @Override
    public void createPreview(ConfiguratorGroup father) {
        super.createPreview(father);
        WrapperConfigurator base = new WrapperConfigurator("ldlib.gui.editor.group.base_image", wrapper -> {
            WidgetGroup widgetGroup = new WidgetGroup(0, 0, 100, 100);
            widgetGroup.addWidget(new ImageWidget(0, 0, 100, 100, () -> new GuiTextureGroup(new ResourceTexture(this.imageLocation.toString()), this::drawGuides)).setBorder(2, ColorPattern.T_WHITE.color));
            widgetGroup.addWidget(new ButtonWidget(0, 0, 100, 100, IGuiTexture.EMPTY, cd -> {
                if (Editor.INSTANCE == null) {
                    return;
                }
                File path = new File(Editor.INSTANCE.getWorkSpace(), "textures");
                DialogWidget.showFileDialog(Editor.INSTANCE, "ldlib.gui.editor.tips.select_image", path, true, DialogWidget.suffixFilter(".png"), r -> {
                    if (r != null && r.isFile()) {
                        this.imageLocation = this.getTextureFromFile(path, (File)r);
                        this.offsetX = 0.0f;
                        this.offsetY = 0.0f;
                        this.imageWidth = 1.0f;
                        this.imageHeight = 1.0f;
                        wrapper.notifyChanges();
                    }
                });
            }));
            return widgetGroup;
        });
        base.setTips("ldlib.gui.editor.tips.click_select_image");
        father.addConfigurators(base);
    }

    private ResourceLocation getTextureFromFile(File path, File r) {
        String id = path.getPath().replace('\\', '/').split("assets/")[1].split("/")[0];
        return new ResourceLocation(id, r.getPath().replace(path.getPath(), "textures").replace('\\', '/'));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawGuides(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        new ColorBorderTexture(-1, -65536).draw(graphics, 0, 0, x + (float)width * this.offsetX, y + (float)height * this.offsetY, (int)((float)width * this.imageWidth), (int)((float)height * this.imageHeight));
    }

    public ResourceTexture() {
    }
}

