/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WidgetTexture
extends TransformTexture {
    private final Widget widget;
    private int centerX;
    private int centerY;
    private boolean isDragging;
    private boolean fixedCenter;
    private int mouseX;
    private int mouseY;

    public WidgetTexture(Widget widget) {
        this.widget = widget;
        this.centerX = widget.getPosition().x + widget.getSize().width / 2;
        this.centerY = widget.getPosition().y + widget.getSize().height / 2;
        this.mouseX = this.centerX;
        this.mouseY = this.centerY;
    }

    public WidgetTexture(int mouseX, int mouseY, Widget widget) {
        this.widget = widget;
        this.centerX = mouseX;
        this.centerY = mouseY;
        this.isDragging = true;
        this.fixedCenter = true;
        this.mouseX = widget.getPosition().x + widget.getSize().width / 2;
        this.mouseY = widget.getPosition().y + widget.getSize().height / 2;
    }

    public WidgetTexture setDragging(boolean dragging) {
        this.isDragging = dragging;
        return this;
    }

    public WidgetTexture setMouse(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        int yOffset;
        int xOffset;
        float scale = 1.0f;
        if (!this.fixedCenter) {
            this.centerX = this.widget.getPosition().x + this.widget.getSize().width / 2;
            this.centerY = this.widget.getPosition().y + this.widget.getSize().height / 2;
        }
        if (this.isDragging) {
            xOffset = mouseX - this.centerX;
            yOffset = mouseY - this.centerY;
        } else {
            xOffset = (int)(x + (float)(width / 2) - (float)this.centerX);
            yOffset = (int)(y + (float)(height / 2) - (float)this.centerY);
            float scaleW = (float)width * 1.0f / (float)this.widget.getSize().width;
            float scaleH = (float)height * 1.0f / (float)this.widget.getSize().height;
            scale = Math.min(scaleW, scaleH);
        }
        float particleTick = Minecraft.getInstance().getFrameTime();
        graphics.pose().pushPose();
        graphics.pose().translate(x + (float)width / 2.0f, y + (float)height / 2.0f, 0.0f);
        graphics.pose().scale(scale, scale, 1.0f);
        graphics.pose().translate(-x + (float)(-width) / 2.0f, -y + (float)(-height) / 2.0f, 0.0f);
        graphics.pose().translate((float)xOffset, (float)yOffset, 0.0f);
        this.widget.drawInBackground(graphics, this.mouseX, this.mouseY, particleTick);
        this.widget.drawInForeground(graphics, this.mouseX, this.mouseY, particleTick);
        graphics.pose().popPose();
    }
}

