/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.util;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderProgram;
import com.lowdragmc.lowdraglib.client.shader.uniform.UniformCache;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.util.forge.DrawerHelperImpl;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class DrawerHelper {
    public static ShaderProgram ROUND;
    public static ShaderProgram PANEL_BG;
    public static ShaderProgram ROUND_BOX;
    public static ShaderProgram PROGRESS_ROUND_BOX;
    public static ShaderProgram FRAME_ROUND_BOX;
    public static ShaderProgram ROUND_LINE;

    public static void init() {
        ROUND = (ShaderProgram)Util.make((Object)new ShaderProgram(), program -> program.attach(Shaders.ROUND_F).attach(Shaders.SCREEN_V));
        PANEL_BG = (ShaderProgram)Util.make((Object)new ShaderProgram(), program -> program.attach(Shaders.PANEL_BG_F).attach(Shaders.SCREEN_V));
        ROUND_BOX = (ShaderProgram)Util.make((Object)new ShaderProgram(), program -> program.attach(Shaders.ROUND_BOX_F).attach(Shaders.SCREEN_V));
        PROGRESS_ROUND_BOX = (ShaderProgram)Util.make((Object)new ShaderProgram(), program -> program.attach(Shaders.PROGRESS_ROUND_BOX_F).attach(Shaders.SCREEN_V));
        FRAME_ROUND_BOX = (ShaderProgram)Util.make((Object)new ShaderProgram(), program -> program.attach(Shaders.FRAME_ROUND_BOX_F).attach(Shaders.SCREEN_V));
        ROUND_LINE = (ShaderProgram)Util.make((Object)new ShaderProgram(), program -> program.attach(Shaders.ROUND_LINE_F).attach(Shaders.SCREEN_V));
    }

    public static void drawFluidTexture(@Nonnull GuiGraphics graphics, float xCoord, float yCoord, TextureAtlasSprite textureSprite, float maskTop, float maskRight, float zLevel, int fluidColor) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        uMax -= maskRight / 16.0f * (uMax - uMin);
        vMax -= maskTop / 16.0f * (vMax - vMin);
        BufferBuilder buffer = Tesselator.getInstance().getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f mat = graphics.pose().last().pose();
        buffer.vertex(mat, xCoord, yCoord + 16.0f, zLevel).uv(uMin, vMax).color(fluidColor).endVertex();
        buffer.vertex(mat, xCoord + 16.0f - maskRight, yCoord + 16.0f, zLevel).uv(uMax, vMax).color(fluidColor).endVertex();
        buffer.vertex(mat, xCoord + 16.0f - maskRight, yCoord + maskTop, zLevel).uv(uMax, vMin).color(fluidColor).endVertex();
        buffer.vertex(mat, xCoord, yCoord + maskTop, zLevel).uv(uMin, vMin).color(fluidColor).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)buffer.end());
    }

    @Deprecated(since="1.21")
    public static void drawFluidForGui(@Nonnull GuiGraphics graphics, FluidStack contents, long tankCapacity, int startX, int startY, int widthT, int heightT) {
        DrawerHelper.drawFluidForGui(graphics, contents, startX, startY, widthT, heightT);
    }

    public static void drawFluidForGui(@Nonnull GuiGraphics graphics, FluidStack contents, float startX, float startY, float widthT, float heightT) {
        ResourceLocation LOCATION_BLOCKS_TEXTURE = InventoryMenu.BLOCK_ATLAS;
        TextureAtlasSprite fluidStillSprite = FluidHelper.getStillTexture(contents);
        if (fluidStillSprite == null) {
            fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(MissingTextureAtlasSprite.getLocation());
            if (Platform.isDevEnv()) {
                LDLib.LOGGER.error("Missing fluid texture for fluid: " + contents.getDisplayName().getString());
            }
        }
        int fluidColor = FluidHelper.getColor(contents) | 0xFF000000;
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION_BLOCKS_TEXTURE);
        int xTileCount = (int)(widthT / 16.0f);
        float xRemainder = widthT - (float)(xTileCount * 16);
        int yTileCount = (int)(heightT / 16.0f);
        float yRemainder = heightT - (float)(yTileCount * 16);
        float yStart = startY + heightT;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float width = xTile == xTileCount ? xRemainder : 16.0f;
                float height = yTile == yTileCount ? yRemainder : 16.0f;
                float x = startX + (float)(xTile * 16);
                float y = yStart - (float)((yTile + 1) * 16);
                if (!(width > 0.0f) || !(height > 0.0f)) continue;
                float maskTop = 16.0f - height;
                float maskRight = 16.0f - width;
                DrawerHelper.drawFluidTexture(graphics, x, y, fluidStillSprite, maskTop, maskRight, 0.0f, fluidColor);
            }
        }
        RenderSystem.enableBlend();
    }

    public static void drawBorder(@Nonnull GuiGraphics graphics, int x, int y, int width, int height, int color, int border) {
        graphics.drawManaged(() -> {
            DrawerHelper.drawSolidRect(graphics, x - border, y - border, width + 2 * border, border, color);
            DrawerHelper.drawSolidRect(graphics, x - border, y + height, width + 2 * border, border, color);
            DrawerHelper.drawSolidRect(graphics, x - border, y, border, height, color);
            DrawerHelper.drawSolidRect(graphics, x + width, y, border, height, color);
        });
    }

    public static void drawStringSized(@Nonnull GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow, float scale, boolean center) {
        graphics.pose().pushPose();
        Font fontRenderer = Minecraft.getInstance().font;
        double scaledTextWidth = center ? (double)((float)fontRenderer.width(text) * scale) : 0.0;
        graphics.pose().translate((double)x - scaledTextWidth / 2.0, (double)y, 0.0);
        graphics.pose().scale(scale, scale, scale);
        graphics.drawString(fontRenderer, text, 0, 0, color, dropShadow);
        graphics.pose().popPose();
    }

    public static void drawStringFixedCorner(@Nonnull GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow, float scale) {
        Font fontRenderer = Minecraft.getInstance().font;
        float scaledWidth = (float)fontRenderer.width(text) * scale;
        Objects.requireNonNull(fontRenderer);
        float scaledHeight = 9.0f * scale;
        DrawerHelper.drawStringSized(graphics, text, x - scaledWidth, y - scaledHeight, color, dropShadow, scale, false);
    }

    public static void drawText(@Nonnull GuiGraphics graphics, String text, float x, float y, float scale, int color) {
        DrawerHelper.drawText(graphics, text, x, y, scale, color, false);
    }

    public static void drawText(@Nonnull GuiGraphics graphics, String text, float x, float y, float scale, int color, boolean shadow) {
        Font fontRenderer = Minecraft.getInstance().font;
        RenderSystem.disableBlend();
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 0.0f);
        float sf = 1.0f / scale;
        graphics.drawString(fontRenderer, text, (int)(x * sf), (int)(y * sf), color, shadow);
        graphics.pose().popPose();
        RenderSystem.enableBlend();
    }

    public static void drawItemStack(@Nonnull GuiGraphics graphics, ItemStack itemStack, int x, int y, int color, @Nullable String altTxt) {
        float a = ColorUtils.alpha(color);
        float r = ColorUtils.red(color);
        float g = ColorUtils.green(color);
        float b = ColorUtils.blue(color);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        Minecraft mc = Minecraft.getInstance();
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 232.0f);
        graphics.renderItem(itemStack, x, y);
        graphics.renderItemDecorations(mc.font, itemStack, x, y, altTxt);
        graphics.pose().popPose();
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
    }

    public static List<Component> getItemToolTip(ItemStack itemStack) {
        Minecraft mc = Minecraft.getInstance();
        return Screen.getTooltipFromItem((Minecraft)mc, (ItemStack)itemStack);
    }

    public static void drawSolidRect(@Nonnull GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.fill(x, y, x + width, y + height, color);
        RenderSystem.enableBlend();
    }

    public static void drawSolidRect(@Nonnull GuiGraphics graphics, Rect rect, int color) {
        DrawerHelper.drawSolidRect(graphics, rect.left, rect.up, rect.right, rect.down, color);
    }

    public static void drawRectShadow(@Nonnull GuiGraphics graphics, int x, int y, int width, int height, int distance) {
        DrawerHelper.drawGradientRect(graphics, x + distance, y + height, width - distance, distance, 0x4F000000, 0, false);
        DrawerHelper.drawGradientRect(graphics, x + width, y + distance, distance, height - distance, 0x4F000000, 0, true);
        float startAlpha = 0.30980393f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        buffer.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = graphics.pose().last().pose();
        buffer.vertex(mat, (float)(x += width), (float)(y += height), 0.0f).color(0.0f, 0.0f, 0.0f, startAlpha).endVertex();
        buffer.vertex(mat, (float)x, (float)(y + distance), 0.0f).color(0, 0, 0, 0).endVertex();
        buffer.vertex(mat, (float)(x + distance), (float)(y + distance), 0.0f).color(0, 0, 0, 0).endVertex();
        buffer.vertex(mat, (float)x, (float)y, 0.0f).color(0.0f, 0.0f, 0.0f, startAlpha).endVertex();
        buffer.vertex(mat, (float)(x + distance), (float)(y + distance), 0.0f).color(0, 0, 0, 0).endVertex();
        buffer.vertex(mat, (float)(x + distance), (float)y, 0.0f).color(0, 0, 0, 0).endVertex();
        tesselator.end();
    }

    public static void drawGradientRect(@Nonnull GuiGraphics graphics, int x, int y, int width, int height, int startColor, int endColor) {
        DrawerHelper.drawGradientRect(graphics, x, y, width, height, startColor, endColor, false);
    }

    public static void drawGradientRect(@Nonnull GuiGraphics graphics, float x, float y, float width, float height, int startColor, int endColor, boolean horizontal) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Matrix4f mat = graphics.pose().last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        if (horizontal) {
            buffer.vertex(mat, x + width, y, 0.0f).color(endRed, endGreen, endBlue, endAlpha).endVertex();
            buffer.vertex(mat, x, y, 0.0f).color(startRed, startGreen, startBlue, startAlpha).endVertex();
            buffer.vertex(mat, x, y + height, 0.0f).color(startRed, startGreen, startBlue, startAlpha).endVertex();
            buffer.vertex(mat, x + width, y + height, 0.0f).color(endRed, endGreen, endBlue, endAlpha).endVertex();
            tesselator.end();
        } else {
            buffer.vertex(mat, x + width, y, 0.0f).color(startRed, startGreen, startBlue, startAlpha).endVertex();
            buffer.vertex(mat, x, y, 0.0f).color(startRed, startGreen, startBlue, startAlpha).endVertex();
            buffer.vertex(mat, x, y + height, 0.0f).color(endRed, endGreen, endBlue, endAlpha).endVertex();
            buffer.vertex(mat, x + width, y + height, 0.0f).color(endRed, endGreen, endBlue, endAlpha).endVertex();
            tesselator.end();
        }
    }

    public static void drawLines(@Nonnull GuiGraphics graphics, List<Vec2> Vec2s, int startColor, int endColor, float width) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferbuilder.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        RenderBufferUtils.drawColorLines(graphics.pose(), (VertexConsumer)bufferbuilder, Vec2s, startColor, endColor, width);
        tesselator.end();
        RenderSystem.defaultBlendFunc();
    }

    public static void drawTextureRect(@Nonnull GuiGraphics graphics, float x, float y, float width, float height) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.getBuilder();
        Matrix4f mat = graphics.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.vertex(mat, x, y + height, 0.0f).uv(0.0f, 0.0f).endVertex();
        buffer.vertex(mat, x + width, y + height, 0.0f).uv(1.0f, 0.0f).endVertex();
        buffer.vertex(mat, x + width, y, 0.0f).uv(1.0f, 1.0f).endVertex();
        buffer.vertex(mat, x, y, 0.0f).uv(0.0f, 1.0f).endVertex();
        tesselator.end();
    }

    public static void updateScreenVshUniform(@Nonnull GuiGraphics graphics, UniformCache uniform) {
        Window window = Minecraft.getInstance().getWindow();
        uniform.glUniform1F("GuiScale", (float)window.getGuiScale());
        uniform.glUniform2F("ScreenSize", window.getWidth(), window.getHeight());
        uniform.glUniformMatrix4F("PoseStack", graphics.pose().last().pose());
        uniform.glUniformMatrix4F("ProjMat", RenderSystem.getProjectionMatrix());
    }

    public static void drawRound(@Nonnull GuiGraphics graphics, int color, float radius, Position centerPos) {
        ROUND.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.fillRGBAColor("Color", color);
            uniform.glUniform1F("StepLength", 1.0f);
            uniform.glUniform1F("Radius", radius);
            uniform.glUniform2F("CenterPos", centerPos.x, centerPos.y);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawPanelBg(@Nonnull GuiGraphics graphics) {
        PANEL_BG.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform1F("Density", 5.0f);
            uniform.glUniform1F("SquareSize", 0.1f);
            float bg = 0.078431375f;
            uniform.glUniform4F("BgColor", bg, bg, bg, 0.95f);
            float square = 0.15686275f;
            uniform.glUniform4F("SquareColor", square, square, square, 0.95f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawRoundBox(@Nonnull GuiGraphics graphics, Rect square, Vector4f radius, int color) {
        ROUND_BOX.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniformMatrix4F("PoseStack", new Matrix4f());
            Vector4f point1 = new Vector4f((float)square.left - 0.25f, (float)square.up - 0.25f, 0.0f, 1.0f);
            Vector4f point2 = new Vector4f((float)square.right - 0.25f, (float)square.down - 0.25f, 0.0f, 1.0f);
            Matrix4f matrix = graphics.pose().last().pose();
            point1.mul((Matrix4fc)matrix);
            point2.mul((Matrix4fc)matrix);
            Vector4f v1 = matrix.transform(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
            Vector4f v2 = matrix.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
            float scale = v1.x - v2.x;
            uniform.glUniform4F("SquareVertex", point1.x, point1.y, point2.x, point2.y);
            uniform.glUniform4F("RoundRadius", radius.x() * scale, radius.y() * scale, radius.z() * scale, radius.w() * scale);
            uniform.fillRGBAColor("Color", color);
            uniform.glUniform1F("Blur", 2.0f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawProgressRoundBox(@Nonnull GuiGraphics graphics, Rect square, Vector4f radius, int color1, int color2, float progress) {
        PROGRESS_ROUND_BOX.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform4F("SquareVertex", square.left, square.up, square.right, square.down);
            uniform.glUniform4F("RoundRadius", radius.x(), radius.y(), radius.z(), radius.w());
            uniform.fillRGBAColor("Color1", color1);
            uniform.fillRGBAColor("Color2", color2);
            uniform.glUniform1F("Blur", 2.0f);
            uniform.glUniform1F("Progress", progress);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawFrameRoundBox(@Nonnull GuiGraphics graphics, Rect square, float thickness, Vector4f radius1, Vector4f radius2, int color) {
        FRAME_ROUND_BOX.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniformMatrix4F("PoseStack", new Matrix4f());
            Vector4f point1 = new Vector4f((float)square.left - 0.25f, (float)square.up - 0.25f, 0.0f, 1.0f);
            Vector4f point2 = new Vector4f((float)square.right - 0.25f, (float)square.down - 0.25f, 0.0f, 1.0f);
            Matrix4f matrix = graphics.pose().last().pose();
            point1.mul((Matrix4fc)matrix);
            point2.mul((Matrix4fc)matrix);
            Vector4f v1 = matrix.transform(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
            Vector4f v2 = matrix.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
            float scale = v1.x - v2.x;
            uniform.glUniform4F("SquareVertex", point1.x, point1.y, point2.x, point2.y);
            uniform.glUniform4F("RoundRadius1", radius1.x() * scale, radius1.y() * scale, radius1.z() * scale, radius1.w() * scale);
            uniform.glUniform4F("RoundRadius2", radius2.x() * scale, radius2.y() * scale, radius2.z() * scale, radius2.w() * scale);
            uniform.glUniform1F("Thickness", thickness * scale);
            uniform.fillRGBAColor("Color", color);
            uniform.glUniform1F("Blur", 2.0f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawRoundLine(@Nonnull GuiGraphics graphics, Position begin, Position end, int width, int color1, int color2) {
        ROUND_LINE.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform1F("Width", width);
            uniform.glUniform2F("Point1", begin.x, begin.y);
            uniform.glUniform2F("Point2", end.x, end.y);
            uniform.fillRGBAColor("Color1", color1);
            uniform.fillRGBAColor("Color2", color2);
            uniform.glUniform1F("Blur", 2.0f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    private static void uploadScreenPosVertex() {
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        builder.vertex(-1.0, 1.0, 0.0).endVertex();
        builder.vertex(-1.0, -1.0, 0.0).endVertex();
        builder.vertex(1.0, -1.0, 0.0).endVertex();
        builder.vertex(1.0, 1.0, 0.0).endVertex();
        BufferUploader.draw((BufferBuilder.RenderedBuffer)builder.end());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void drawTooltip(GuiGraphics graphics, int mouseX, int mouseY, List<Component> tooltipTexts, ItemStack tooltipStack, @Nullable TooltipComponent tooltipComponent, Font tooltipFont) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        DrawerHelperImpl.drawTooltip(graphics, (int)var1_1, (int)var2_2, (List<Component>)var3_3, (ItemStack)var4_4, (TooltipComponent)var5_5, (Font)var6_6);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ClientTooltipComponent getClientTooltipComponent(TooltipComponent component) {
        return DrawerHelperImpl.getClientTooltipComponent(component);
    }
}

