/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectorWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public class BlockSelectorWidget
extends WidgetGroup {
    private Consumer<BlockState> onBlockStateUpdate;
    private Block block;
    private final IItemTransfer handler;
    private final TextFieldWidget blockField;
    private final Map<Property, Comparable> properties;

    public BlockSelectorWidget(int x, int y, int width, boolean isState) {
        super(x, y, width, 20);
        this.setClientSideWidget();
        this.properties = new HashMap<Property, Comparable>();
        this.blockField = (TextFieldWidget)new TextFieldWidget(22, 0, width - (isState ? 46 : 26), 20, null, s -> {
            Block block;
            if (s != null && !s.isEmpty() && this.block != (block = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(s)))) {
                this.block = block;
                this.onUpdate();
            }
        }).setResourceLocationOnly().setHoverTooltips("ldlib.gui.tips.block_selector");
        this.handler = new ItemStackTransfer(1);
        this.addWidget(new PhantomSlotWidget(this.handler, 0, 1, 1).setClearSlotOnRightClick(true).setChangeListener(() -> {
            Item patt2196$temp;
            ItemStack stack = this.handler.getStackInSlot(0);
            if (stack.isEmpty() || !((patt2196$temp = stack.getItem()) instanceof BlockItem)) {
                IFluidTransfer fluidTransfer = FluidTransferHelper.getFluidTransfer(this.handler, 0);
                if (fluidTransfer != null && fluidTransfer.getTanks() > 0) {
                    Fluid fluid = fluidTransfer.getFluidInTank(0).getFluid();
                    this.setBlock(fluid.defaultFluidState().createLegacyBlock());
                    this.onUpdate();
                    return;
                }
                if (this.block != null) {
                    this.setBlock(null);
                    this.onUpdate();
                }
            } else {
                BlockItem itemBlock = (BlockItem)patt2196$temp;
                this.setBlock(itemBlock.getBlock().defaultBlockState());
                this.onUpdate();
            }
        }).setBackgroundTexture(new ColorBorderTexture(1, -1)));
        this.addWidget(this.blockField);
        if (isState) {
            this.addWidget(new ButtonWidget(width - 21, 0, 20, 20, new ItemStackTexture(Items.BLACK_WOOL, Items.WHITE_WOOL, Items.BLUE_WOOL, Items.GREEN_WOOL, Items.YELLOW_WOOL), cd -> {
                DraggableScrollableWidgetGroup group = new DraggableScrollableWidgetGroup(0, 0, this.getGui().mainGroup.getSize().width, this.getGui().mainGroup.getSize().height).setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1)).setXScrollBarHeight(4).setXBarStyle(null, new ColorRectTexture(-1)).setBackground((IGuiTexture)new ColorRectTexture(-1893588446));
                new DialogWidget(this.getGui().mainGroup, this.isClientSideWidget).setOnClosed(this::onUpdate).addWidget(group);
                int i = this.properties.size() - 1;
                for (Map.Entry<Property, Comparable> entry : this.properties.entrySet()) {
                    Property property = entry.getKey();
                    Comparable value = entry.getValue();
                    group.addWidget(new SelectorWidget(3, 3 + i * 20, 100, 15, property.getPossibleValues().stream().map(v -> property.getName((Comparable)v)).toList(), -1).setValue(property.getName(value)).setOnChanged(newValue -> this.properties.put(property, (Comparable)property.getValue(newValue).get())).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground((IGuiTexture)new ColorRectTexture(-5592406)));
                    group.addWidget(new LabelWidget(105, 6 + i * 20, property.getName()));
                    --i;
                }
            }).setHoverBorderTexture(1, -1).setHoverTooltips("ldlib.gui.tips.block_meta"));
        }
    }

    public BlockState getBlock() {
        BlockState state;
        if (this.block == null) {
            state = null;
        } else {
            state = this.block.defaultBlockState();
            for (Map.Entry<Property, Comparable> entry : this.properties.entrySet()) {
                state = (BlockState)state.setValue(entry.getKey(), entry.getValue());
            }
        }
        return state;
    }

    public BlockSelectorWidget setBlock(BlockState blockState) {
        this.properties.clear();
        if (blockState == null) {
            this.block = null;
            this.handler.setStackInSlot(0, ItemStack.EMPTY);
            this.blockField.setCurrentString("");
        } else {
            this.block = blockState.getBlock();
            new ItemStack((ItemLike)this.block);
            this.handler.setStackInSlot(0, new ItemStack((ItemLike)this.block));
            this.blockField.setCurrentString(BuiltInRegistries.BLOCK.getKey((Object)this.block));
            for (Property property : blockState.getBlock().getStateDefinition().getProperties()) {
                this.properties.put(property, blockState.getValue(property));
            }
        }
        return this;
    }

    public BlockSelectorWidget setOnBlockStateUpdate(Consumer<BlockState> onBlockStateUpdate) {
        this.onBlockStateUpdate = onBlockStateUpdate;
        return this;
    }

    private void onUpdate() {
        this.handler.setStackInSlot(0, this.block == null ? ItemStack.EMPTY : new ItemStack((ItemLike)this.block));
        if (this.onBlockStateUpdate != null) {
            this.onBlockStateUpdate.accept(this.getBlock());
        }
    }
}

