/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="button", group="widget.basic")
@RemapPrefixForJS(value="kjs$")
public class ButtonWidget
extends Widget
implements IConfigurableWidget {
    @Configurable(name="ldlib.gui.editor.name.clicked_texture")
    protected IGuiTexture clickedTexture;
    protected Consumer<ClickData> onPressCallback;
    protected boolean isClicked = false;

    public ButtonWidget() {
        this(0, 0, 40, 20, new GuiTextureGroup(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("Button")), null);
    }

    @Override
    public void initTemplate() {
        this.setHoverBorderTexture(1, -1);
    }

    public ButtonWidget(int xPosition, int yPosition, int width, int height, IGuiTexture buttonTexture, Consumer<ClickData> onPressed) {
        super(xPosition, yPosition, width, height);
        this.onPressCallback = onPressed;
        this.setBackground(buttonTexture);
    }

    public ButtonWidget(int xPosition, int yPosition, int width, int height, Consumer<ClickData> onPressed) {
        super(xPosition, yPosition, width, height);
        this.onPressCallback = onPressed;
    }

    public ButtonWidget setOnPressCallback(Consumer<ClickData> onPressCallback) {
        this.onPressCallback = onPressCallback;
        return this;
    }

    public ButtonWidget setButtonTexture(IGuiTexture ... buttonTexture) {
        super.setBackground(buttonTexture);
        return this;
    }

    @Override
    @HideFromJS
    public ButtonWidget setHoverTexture(IGuiTexture ... hoverTexture) {
        super.setHoverTexture(hoverTexture);
        return this;
    }

    public ButtonWidget setClickedTexture(IGuiTexture ... clickedTexture) {
        this.clickedTexture = clickedTexture.length > 1 ? new GuiTextureGroup(clickedTexture) : clickedTexture[0];
        return this;
    }

    public ButtonWidget kjs$setHoverTexture(IGuiTexture ... hoverTexture) {
        super.setHoverTexture(hoverTexture);
        return this;
    }

    public ButtonWidget setHoverBorderTexture(int border, int color) {
        super.setHoverTexture(new ColorBorderTexture(border, color));
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && button == 0) {
            this.isClicked = true;
            ClickData clickData = new ClickData();
            this.writeClientAction(1, clickData::writeToBuf);
            if (this.onPressCallback != null) {
                this.onPressCallback.accept(clickData);
            }
            ButtonWidget.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isClicked = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            ClickData clickData = ClickData.readFromBuf(buffer);
            if (this.onPressCallback != null) {
                this.onPressCallback.accept(clickData);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawBackgroundTexture(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        Size size;
        Position pos;
        boolean isHovered = this.isMouseOverElement(mouseX, mouseY);
        if (!isHovered || this.drawBackgroundWhenHover) {
            if (this.isClicked && this.clickedTexture != null) {
                pos = this.getPosition();
                size = this.getSize();
                this.clickedTexture.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
            } else if (this.backgroundTexture != null) {
                pos = this.getPosition();
                size = this.getSize();
                this.backgroundTexture.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
            }
        }
        if (this.hoverTexture != null && isHovered && this.isActive()) {
            pos = this.getPosition();
            size = this.getSize();
            this.hoverTexture.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
    }

    public boolean isClicked() {
        return this.isClicked;
    }
}

