/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.platform.Window;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector4f;

@LDLRegister(name="draggable_scrollable_group", group="widget.group")
public class DraggableScrollableWidgetGroup
extends WidgetGroup {
    protected int scrollXOffset;
    protected int scrollYOffset;
    @Configurable(name="ldlib.gui.editor.name.x_bar_height")
    @NumberRange(range={0.0, 2.147483647E9})
    protected int xBarHeight;
    @Configurable(name="ldlib.gui.editor.name.y_bar_width")
    @NumberRange(range={0.0, 2.147483647E9})
    protected int yBarWidth;
    @Configurable(name="ldlib.gui.editor.name.draggable")
    protected boolean draggable;
    @Configurable(name="ldlib.gui.editor.name.scrollable")
    protected boolean scrollable = true;
    @Configurable(name="ldlib.gui.editor.name.scroll_wheel_direction")
    protected ScrollWheelDirection scrollWheelDirection = ScrollWheelDirection.VERTICAL;
    @Configurable(name="ldlib.gui.editor.name.use_scissor")
    protected boolean useScissor;
    protected int maxHeight;
    protected int maxWidth;
    @Configurable(name="ldlib.gui.editor.name.x_bar_background")
    protected IGuiTexture xBarB;
    @Configurable(name="ldlib.gui.editor.name.x_bar_foreground")
    protected IGuiTexture xBarF;
    @Configurable(name="ldlib.gui.editor.name.y_bar_background")
    protected IGuiTexture yBarB;
    @Configurable(name="ldlib.gui.editor.name.y_bar_foreground")
    protected IGuiTexture yBarF;
    protected Widget draggedWidget;
    protected Widget selectedWidget;
    protected boolean isComputingMax;
    private boolean draggedPanel;
    private boolean draggedOnXScrollBar;
    private boolean draggedOnYScrollBar;
    private double lastDeltaX;
    private double lastDeltaY;
    private final Set<BiConsumer<Integer, Integer>> moveCallbacks = new HashSet<BiConsumer<Integer, Integer>>();

    public DraggableScrollableWidgetGroup() {
        this(0, 0, 50, 50);
    }

    @Override
    public void initTemplate() {
        this.setBackground((IGuiTexture)ColorPattern.RED.rectTexture());
        this.setYScrollBarWidth(4).setYBarStyle(ColorPattern.RED.rectTexture(), ColorPattern.WHITE.rectTexture().setRadius(2.0f));
    }

    public DraggableScrollableWidgetGroup(int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.maxHeight = height;
        this.maxWidth = width;
        this.useScissor = true;
    }

    @ConfigSetter(field="xBarHeight")
    public DraggableScrollableWidgetGroup setXScrollBarHeight(int xBar) {
        this.xBarHeight = xBar;
        this.computeMax();
        return this;
    }

    @ConfigSetter(field="yBarWidth")
    public DraggableScrollableWidgetGroup setYScrollBarWidth(int yBar) {
        this.yBarWidth = yBar;
        this.computeMax();
        return this;
    }

    public DraggableScrollableWidgetGroup setBackground(IGuiTexture background) {
        super.setBackground(background);
        return this;
    }

    public DraggableScrollableWidgetGroup setXBarStyle(IGuiTexture background, IGuiTexture bar) {
        this.xBarB = background;
        this.xBarF = bar;
        return this;
    }

    public DraggableScrollableWidgetGroup setYBarStyle(IGuiTexture background, IGuiTexture bar) {
        this.yBarB = background;
        this.yBarF = bar;
        return this;
    }

    @Override
    public WidgetGroup addWidget(int index, Widget widget) {
        this.maxHeight = Math.max(this.maxHeight - this.xBarHeight, widget.getSize().height + widget.getSelfPosition().y);
        this.maxWidth = Math.max(this.maxWidth - this.yBarWidth, widget.getSize().width + widget.getSelfPosition().x);
        Position newPos = widget.addSelfPosition(-this.scrollXOffset, -this.scrollYOffset);
        widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
        widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        return super.addWidget(index, widget);
    }

    @Override
    public void removeWidget(Widget widget) {
        super.removeWidget(widget);
        this.computeMax();
        if (widget == this.draggedWidget) {
            this.draggedWidget = null;
        }
        if (widget == this.selectedWidget) {
            this.selectedWidget = null;
        }
    }

    @Override
    public void clearAllWidgets() {
        super.clearAllWidgets();
        this.maxHeight = this.getSize().height - this.xBarHeight;
        this.maxWidth = this.getSize().width - this.yBarWidth;
        this.scrollXOffset = 0;
        this.scrollYOffset = 0;
        this.draggedWidget = null;
        this.selectedWidget = null;
    }

    @Override
    @ConfigSetter(field="size")
    public void setSize(Size size) {
        super.setSize(size);
        this.maxHeight = Math.max(size.height - this.xBarHeight, this.maxHeight);
        this.maxWidth = Math.max(size.width - this.yBarWidth, this.maxWidth);
        for (Widget widget : this.widgets) {
            Position newPos = widget.getSelfPosition();
            widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
            widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        }
    }

    @Override
    protected void onChildSelfPositionUpdate(Widget child) {
        super.onChildSelfPositionUpdate(child);
        if (!this.isComputingMax && this.isInitialized()) {
            this.computeMax();
        }
    }

    @Override
    protected void onChildSizeUpdate(Widget child) {
        super.onChildSizeUpdate(child);
        if (!this.isComputingMax && this.isInitialized()) {
            this.computeMax();
        }
    }

    public void computeMax() {
        if (this.isComputingMax) {
            return;
        }
        this.isComputingMax = true;
        int lastScrollXOffset = this.scrollXOffset;
        int lastScrollYOffset = this.scrollYOffset;
        int mh = 0;
        int mw = 0;
        for (Widget widget : this.widgets) {
            mh = Math.max(mh, widget.getSize().height + widget.getSelfPosition().y + this.scrollYOffset);
            mw = Math.max(mw, widget.getSize().width + widget.getSelfPosition().x + this.scrollXOffset);
        }
        int offsetY = 0;
        int offsetX = 0;
        if (mh > this.getSize().height - this.xBarHeight) {
            offsetY = this.maxHeight - mh;
            this.maxHeight = mh;
            if (this.scrollYOffset - offsetY < 0) {
                offsetY = this.scrollYOffset;
            }
            this.scrollYOffset -= offsetY;
        } else if (mh < this.getSize().height - this.xBarHeight) {
            offsetY = this.maxHeight - (this.getSize().height - this.xBarHeight);
            this.maxHeight = this.getSize().height - this.xBarHeight;
            if (this.scrollYOffset - offsetY < 0) {
                offsetY = this.scrollYOffset;
            }
            this.scrollYOffset -= offsetY;
        }
        if (mw > this.getSize().width - this.yBarWidth) {
            offsetX = this.maxWidth - mw;
            this.maxWidth = mw;
            if (this.scrollXOffset - offsetX < 0) {
                offsetX = this.scrollXOffset;
            }
            this.scrollXOffset -= offsetX;
        } else if (mw < this.getSize().width - this.yBarWidth) {
            offsetX = this.maxWidth - (this.getSize().width - this.yBarWidth);
            this.maxWidth = this.getSize().width - this.yBarWidth;
            if (this.scrollXOffset - offsetX < 0) {
                offsetX = this.scrollXOffset;
            }
            this.scrollXOffset -= offsetX;
        }
        offsetX += this.scrollXOffset - Math.min(this.scrollXOffset, lastScrollXOffset);
        offsetY += this.scrollYOffset - Math.min(this.scrollYOffset, lastScrollYOffset);
        this.scrollXOffset = Math.min(this.scrollXOffset, lastScrollXOffset);
        this.scrollYOffset = Math.min(this.scrollYOffset, lastScrollYOffset);
        for (Widget widget : this.widgets) {
            Position newPos = widget.addSelfPosition(offsetX, offsetY);
            widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
            widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        }
        this.isComputingMax = false;
    }

    protected int getMaxHeight() {
        return this.maxHeight + this.xBarHeight;
    }

    protected int getMaxWidth() {
        return this.maxWidth + this.yBarWidth;
    }

    public int getWidgetBottomHeight() {
        int y = 0;
        for (Widget widget : this.widgets) {
            y = Math.max(y, widget.getSize().height + widget.getSelfPosition().y);
        }
        return y;
    }

    public void setScrollXOffset(int scrollXOffset) {
        if (scrollXOffset == this.scrollXOffset) {
            return;
        }
        if (scrollXOffset < 0) {
            scrollXOffset = 0;
        }
        int offset = scrollXOffset - this.scrollXOffset;
        this.scrollXOffset = scrollXOffset;
        this.isComputingMax = true;
        for (Widget widget : this.widgets) {
            Position newPos = widget.addSelfPosition(-offset, 0);
            widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
        }
        for (BiConsumer biConsumer : this.moveCallbacks) {
            biConsumer.accept(-offset, 0);
        }
        this.isComputingMax = false;
    }

    public void setScrollYOffset(int scrollYOffset) {
        if (scrollYOffset == this.scrollYOffset) {
            return;
        }
        if (scrollYOffset < 0) {
            scrollYOffset = 0;
        }
        int offset = scrollYOffset - this.scrollYOffset;
        this.scrollYOffset = scrollYOffset;
        this.isComputingMax = true;
        for (Widget widget : this.widgets) {
            Position newPos = widget.addSelfPosition(0, -offset);
            widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        }
        for (BiConsumer biConsumer : this.moveCallbacks) {
            biConsumer.accept(0, -offset);
        }
        this.isComputingMax = false;
    }

    private boolean isOnXScrollPane(double mouseX, double mouseY) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return DraggableScrollableWidgetGroup.isMouseOver(pos.x, pos.y + size.height - this.xBarHeight, size.width, this.xBarHeight, mouseX, mouseY);
    }

    private boolean isOnYScrollPane(double mouseX, double mouseY) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return DraggableScrollableWidgetGroup.isMouseOver(pos.x + size.width - this.yBarWidth, pos.y, this.yBarWidth, size.height, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected boolean hookDrawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.useScissor) {
            Matrix4f trans = graphics.pose().last().pose();
            Vector4f realPos = trans.transform(new Vector4f((float)x, (float)y, 0.0f, 1.0f));
            Vector4f realPos2 = trans.transform(new Vector4f((float)(x + width), (float)(y + height), 0.0f, 1.0f));
            graphics.enableScissor((int)realPos.x, (int)realPos.y, (int)realPos2.x, (int)realPos2.y);
            if (!this.hookDrawInBackground(graphics, mouseX, mouseY, partialTicks)) {
                this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.disableScissor();
        } else if (!this.hookDrawInBackground(graphics, mouseX, mouseY, partialTicks)) {
            this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.xBarHeight > 0) {
            if (this.xBarB != null) {
                this.xBarB.draw(graphics, mouseX, mouseY, x, y + height - this.xBarHeight, width, this.xBarHeight);
            }
            if (this.xBarF != null) {
                int barWidth = (int)((float)width * 1.0f / (float)this.getMaxWidth() * (float)width);
                this.xBarF.draw(graphics, mouseX, mouseY, (float)x + (float)(this.scrollXOffset * width) * 1.0f / (float)this.getMaxWidth(), y + height - this.xBarHeight, barWidth, this.xBarHeight);
            }
        }
        if (this.yBarWidth > 0) {
            if (this.yBarB != null) {
                this.yBarB.draw(graphics, mouseX, mouseY, x + width - this.yBarWidth, y, this.yBarWidth, height);
            }
            if (this.yBarF != null) {
                int barHeight = (int)((float)height * 1.0f / (float)this.getMaxHeight() * (float)height);
                this.yBarF.draw(graphics, mouseX, mouseY, x + width - this.yBarWidth, (float)y + (float)(this.scrollYOffset * height) * 1.0f / (float)this.getMaxHeight(), this.yBarWidth, barHeight);
            }
        }
    }

    @Override
    public void drawOverlay(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.useScissor) {
            Matrix4f trans = graphics.pose().last().pose();
            Vector4f realPos = trans.transform(new Vector4f((float)x, (float)y, 0.0f, 1.0f));
            Vector4f realPos2 = trans.transform(new Vector4f((float)(x + width), (float)(y + height), 0.0f, 1.0f));
            graphics.enableScissor((int)realPos.x, (int)realPos.y, (int)realPos2.x, (int)realPos2.y);
            super.drawOverlay(graphics, mouseX, mouseY, partialTicks);
            graphics.disableScissor();
        } else {
            super.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.lastDeltaX = 0.0;
        this.lastDeltaY = 0.0;
        if (this.xBarHeight > 0 && this.isOnXScrollPane(mouseX, mouseY)) {
            this.draggedOnXScrollBar = true;
            this.setFocus(true);
            return true;
        }
        if (this.yBarWidth > 0 && this.isOnYScrollPane(mouseX, mouseY)) {
            this.draggedOnYScrollBar = true;
            this.setFocus(true);
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.checkClickedDragged(mouseX, mouseY, button)) {
                this.setFocus(true);
                return true;
            }
            this.setFocus(true);
            if (this.draggable) {
                this.draggedPanel = true;
                return true;
            }
        }
        this.setFocus(false);
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        double mouseY;
        Window window = Minecraft.getInstance().getWindow();
        double mouseX = Minecraft.getInstance().mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        if (this.isMouseOverElement(mouseX, mouseY = Minecraft.getInstance().mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight())) {
            for (int i = this.widgets.size() - 1; i >= 0; --i) {
                Widget widget = (Widget)this.widgets.get(i);
                if (!widget.isVisible() || !widget.isMouseOverElement(mouseX, mouseY)) continue;
                return widget.keyPressed(keyCode, scanCode, modifiers);
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected boolean checkClickedDragged(double mouseX, double mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.widgets.get(i);
            if (!widget.isVisible()) continue;
            boolean result = widget.mouseClicked(mouseX, mouseY, button);
            if (this.waitToRemoved == null || !this.waitToRemoved.contains(widget)) {
                if (widget instanceof IDraggable && ((IDraggable)((Object)widget)).allowDrag(mouseX, mouseY, button)) {
                    this.draggedWidget = widget;
                    ((IDraggable)((Object)widget)).startDrag(mouseX, mouseY);
                    if (this.selectedWidget != null && this.selectedWidget != widget) {
                        ((ISelected)((Object)this.selectedWidget)).onUnSelected();
                    }
                    this.selectedWidget = widget;
                    ((ISelected)((Object)this.selectedWidget)).onSelected();
                    return true;
                }
                if (widget instanceof ISelected && ((ISelected)((Object)widget)).allowSelected(mouseX, mouseY, button)) {
                    if (this.selectedWidget != null && this.selectedWidget != widget) {
                        ((ISelected)((Object)this.selectedWidget)).onUnSelected();
                    }
                    this.selectedWidget = widget;
                    ((ISelected)((Object)this.selectedWidget)).onSelected();
                    return true;
                }
            }
            if (!result) continue;
            return true;
        }
        this.draggedWidget = null;
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (super.mouseWheelMove(mouseX, mouseY, wheelDelta)) {
                this.setFocus(true);
                return true;
            }
            if (this.scrollable) {
                this.setFocus(true);
                if (this.isFocus()) {
                    int moveDelta = (int)(-Mth.clamp((double)wheelDelta, (double)-1.0, (double)1.0) * 13.0);
                    if (this.scrollWheelDirection == ScrollWheelDirection.VERTICAL) {
                        if (this.getMaxHeight() - this.getSize().height > 0 || this.scrollYOffset > this.getMaxHeight() - this.getSize().height) {
                            this.setScrollYOffset(Mth.clamp((int)(this.scrollYOffset + moveDelta), (int)0, (int)(this.getMaxHeight() - this.getSize().height)));
                        }
                    } else if (this.getMaxWidth() - this.getSize().width > 0 || this.scrollXOffset > this.getMaxWidth() - this.getSize().width) {
                        this.setScrollXOffset(Mth.clamp((int)(this.scrollXOffset + moveDelta), (int)0, (int)(this.getMaxWidth() - this.getSize().width)));
                    }
                }
            }
            return true;
        }
        this.setFocus(false);
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        double dx = deltaX + this.lastDeltaX;
        double dy = deltaY + this.lastDeltaY;
        deltaX = (int)dx;
        deltaY = (int)dy;
        this.lastDeltaX = dx - deltaX;
        this.lastDeltaY = dy - deltaY;
        if (this.draggedOnXScrollBar && (this.getMaxWidth() - this.getSize().width > 0 || this.scrollYOffset > this.getMaxWidth() - this.getSize().width)) {
            this.setScrollXOffset((int)Mth.clamp((double)((double)this.scrollXOffset + deltaX * (double)this.getMaxWidth() / (double)this.getSize().width), (double)0.0, (double)(this.getMaxWidth() - this.getSize().width)));
            return true;
        }
        if (this.draggedOnYScrollBar && (this.getMaxHeight() - this.getSize().height > 0 || this.scrollYOffset > this.getMaxHeight() - this.getSize().height)) {
            this.setScrollYOffset((int)Mth.clamp((double)((double)this.scrollYOffset + deltaY * (double)this.getMaxHeight() / (double)this.getSize().height), (double)0.0, (double)(this.getMaxHeight() - this.getSize().height)));
            return true;
        }
        Widget widget = this.draggedWidget;
        if (widget instanceof IDraggable) {
            IDraggable draggableWidget = (IDraggable)((Object)widget);
            if (draggableWidget.dragging(mouseX, mouseY, deltaX, deltaY)) {
                if (!draggableWidget.canDragOutRange()) {
                    if (this.draggedWidget.getPosition().x < this.getPosition().x) {
                        deltaX = this.getPosition().x - this.draggedWidget.getPosition().x;
                    } else if (this.draggedWidget.getPosition().x + this.draggedWidget.getSize().width + this.scrollXOffset > this.getPosition().x + this.getSize().width) {
                        deltaX = this.getPosition().x + this.getSize().width - (this.draggedWidget.getPosition().x + this.draggedWidget.getSize().width + this.scrollXOffset);
                    }
                    if (this.draggedWidget.getPosition().y < this.getPosition().y) {
                        deltaY = this.getPosition().y - this.draggedWidget.getPosition().y;
                    } else if (this.draggedWidget.getPosition().y + this.draggedWidget.getSize().height + this.scrollYOffset > this.getPosition().y + this.getSize().height) {
                        deltaY = this.getPosition().y + this.getSize().height - (this.draggedWidget.getPosition().y + this.draggedWidget.getSize().height + this.scrollYOffset);
                    }
                    this.isComputingMax = true;
                    this.draggedWidget.addSelfPosition((int)deltaX, (int)deltaY);
                    this.isComputingMax = false;
                } else {
                    this.draggedWidget.addSelfPosition((int)deltaX, (int)deltaY);
                }
            }
            this.computeMax();
            return true;
        }
        if (this.draggedPanel) {
            this.setScrollXOffset((int)Mth.clamp((double)((double)this.scrollXOffset - deltaX), (double)0.0, (double)Math.max(this.getMaxWidth() - this.yBarWidth - this.getSize().width, 0)));
            this.setScrollYOffset((int)Mth.clamp((double)((double)this.scrollYOffset - deltaY), (double)0.0, (double)Math.max(this.getMaxHeight() - this.xBarHeight - this.getSize().height, 0)));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.draggedOnXScrollBar) {
            this.draggedOnXScrollBar = false;
        } else if (this.draggedOnYScrollBar) {
            this.draggedOnYScrollBar = false;
        } else if (this.draggedWidget != null) {
            ((IDraggable)((Object)this.draggedWidget)).endDrag(mouseX, mouseY);
            this.draggedWidget = null;
        } else if (this.draggedPanel) {
            this.draggedPanel = false;
        } else {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Rect2i> getGuiExtraAreas(Rect2i guiRect, List<Rect2i> list) {
        Rect2i rect2i = this.toRectangleBox();
        if (rect2i.getX() < guiRect.getX() || rect2i.getX() + rect2i.getWidth() > guiRect.getX() + guiRect.getWidth() || rect2i.getY() < guiRect.getY() || rect2i.getY() + rect2i.getHeight() > guiRect.getY() + guiRect.getHeight()) {
            list.add(this.toRectangleBox());
        }
        return list;
    }

    public void setSelected(Widget widget) {
        if (widget instanceof ISelected) {
            if (this.selectedWidget != null && this.selectedWidget != widget) {
                ((ISelected)((Object)this.selectedWidget)).onUnSelected();
            }
            this.selectedWidget = widget;
            ((ISelected)((Object)this.selectedWidget)).onSelected();
        } else if (widget == null) {
            if (this.selectedWidget != null) {
                ((ISelected)((Object)this.selectedWidget)).onUnSelected();
            }
            this.selectedWidget = null;
        }
    }

    @Override
    public CompoundTag serializeInnerNBT() {
        CompoundTag tag = super.serializeInnerNBT();
        tag.putInt("scrollXOffset", this.scrollXOffset);
        tag.putInt("scrollYOffset", this.scrollYOffset);
        tag.putInt("maxHeight", this.maxHeight);
        tag.putInt("maxWidth", this.maxWidth);
        return tag;
    }

    @Override
    public void deserializeInnerNBT(CompoundTag nbt) {
        super.deserializeInnerNBT(nbt);
        this.scrollXOffset = nbt.getInt("scrollXOffset");
        this.scrollYOffset = nbt.getInt("scrollYOffset");
        this.maxHeight = nbt.getInt("maxHeight");
        this.maxWidth = nbt.getInt("maxWidth");
        this.isComputingMax = true;
        for (Widget widget : this.widgets) {
            widget.addSelfPosition(-this.scrollXOffset, -this.scrollYOffset);
        }
        this.isComputingMax = false;
    }

    public int getScrollXOffset() {
        return this.scrollXOffset;
    }

    public int getScrollYOffset() {
        return this.scrollYOffset;
    }

    public DraggableScrollableWidgetGroup setDraggable(boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public DraggableScrollableWidgetGroup setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
        return this;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public ScrollWheelDirection getScrollWheelDirection() {
        return this.scrollWheelDirection;
    }

    public DraggableScrollableWidgetGroup setScrollWheelDirection(ScrollWheelDirection scrollWheelDirection) {
        this.scrollWheelDirection = scrollWheelDirection;
        return this;
    }

    public boolean isUseScissor() {
        return this.useScissor;
    }

    public DraggableScrollableWidgetGroup setUseScissor(boolean useScissor) {
        this.useScissor = useScissor;
        return this;
    }

    public Set<BiConsumer<Integer, Integer>> getMoveCallbacks() {
        return this.moveCallbacks;
    }

    public static enum ScrollWheelDirection {
        VERTICAL,
        HORIZONTAL;

    }

    public static interface IDraggable
    extends ISelected {
        default public boolean allowDrag(double mouseX, double mouseY, int button) {
            return this.allowSelected(mouseX, mouseY, button);
        }

        default public void startDrag(double mouseX, double mouseY) {
        }

        default public boolean dragging(double mouseX, double mouseY, double deltaX, double deltaY) {
            return true;
        }

        default public void endDrag(double mouseX, double mouseY) {
        }

        default public boolean canDragOutRange() {
            return false;
        }
    }

    public static interface ISelected {
        public boolean allowSelected(double var1, double var3, int var5);

        default public void onSelected() {
        }

        default public void onUnSelected() {
        }
    }
}

