/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomFluidWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public class FluidStackSelectorWidget
extends WidgetGroup {
    private Consumer<FluidStack> onFluidStackUpdate;
    private final IFluidStorage handler;
    private final TextFieldWidget fluidField;
    private FluidStack fluid = FluidStack.empty();

    public FluidStackSelectorWidget(int x, int y, int width) {
        super(x, y, width, 20);
        this.setClientSideWidget();
        this.fluidField = (TextFieldWidget)new TextFieldWidget(22, 0, width - 46, 20, null, s -> {
            if (s != null && !s.isEmpty()) {
                Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(s));
                if (fluid == null) {
                    fluid = FluidStack.empty().getFluid();
                }
                if (!this.fluid.isFluidEqual(FluidStack.create(fluid, 1000L))) {
                    this.fluid = FluidStack.create(fluid, 1000L);
                    this.onUpdate();
                }
            }
        }).setResourceLocationOnly().setHoverTooltips("ldlib.gui.tips.fluid_selector");
        this.handler = new FluidStorage(1000L);
        this.addWidget(new PhantomFluidWidget((IFluidTransfer)this.handler, 0, 1, 1, 18, 18, this::getFluidStack, fluidStack -> {
            this.setFluidStack((FluidStack)fluidStack);
            this.onUpdate();
        }).setBackground((IGuiTexture)new ColorBorderTexture(1, -1)));
        this.addWidget(this.fluidField);
        this.addWidget(new ButtonWidget(width - 21, 0, 20, 20, null, cd -> {
            if (this.fluid.isEmpty()) {
                return;
            }
            TextFieldWidget nbtField = new TextFieldWidget(10, 10, this.getGui().mainGroup.getSize().width - 50, 20, null, s -> {
                try {
                    this.fluid.setTag(TagParser.parseTag((String)s));
                    this.onUpdate();
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            });
            new DialogWidget(this.getGui().mainGroup, this.isClientSideWidget).setOnClosed(this::onUpdate).addWidget(nbtField);
            if (this.fluid.hasTag()) {
                nbtField.setCurrentString(this.fluid.getTag().toString());
            }
        }).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("NBT", -1).setDropShadow(true)).setHoverBorderTexture(1, -1).setHoverTooltips("ldlib.gui.tips.fluid_tag"));
    }

    public FluidStack getFluidStack() {
        return this.fluid;
    }

    public FluidStackSelectorWidget setFluidStack(FluidStack fluidStack) {
        this.fluid = Objects.requireNonNullElse(fluidStack, FluidStack.empty()).copy();
        if (this.fluid != FluidStack.empty()) {
            this.fluid.setAmount(1000L);
        }
        this.handler.setFluid(this.fluid);
        this.fluidField.setCurrentString(BuiltInRegistries.FLUID.getKey((Object)this.fluid.getFluid()));
        return this;
    }

    public FluidStackSelectorWidget setOnFluidStackUpdate(Consumer<FluidStack> onFluidStackUpdate) {
        this.onFluidStackUpdate = onFluidStackUpdate;
        return this;
    }

    private void onUpdate() {
        this.handler.setFluid(this.fluid);
        if (this.onFluidStackUpdate != null) {
            this.onFluidStackUpdate.accept(this.fluid);
        }
    }
}

