/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.lowdragmc.lowdraglib.utils.Size;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector4f;

public class FreeGraphView
extends WidgetGroup {
    protected float xOffset;
    protected float yOffset;
    protected float scale = 1.0f;
    protected boolean drawGrid;
    protected int gridWidth = 50;
    protected boolean useScissor = true;
    protected double lastMouseX;
    protected double lastMouseY;
    protected boolean isDragging = false;

    public FreeGraphView(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void resetFitScaleByWidgets() {
        if (this.widgets.isEmpty()) {
            this.xOffset = 0.0f;
            this.yOffset = 0.0f;
            this.scale = 1.0f;
            return;
        }
        int minY = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (Widget widget : this.widgets) {
            Position position = widget.getPosition();
            minX = Math.min(minX, position.x - 120);
            minY = Math.min(minY, position.y - 20);
            maxX = Math.max(maxX, position.x + widget.getSize().width + 20);
            maxY = Math.max(maxY, position.y + widget.getSize().height + 20);
        }
        this.xOffset = minX;
        this.yOffset = minY;
        float scaleWidth = (float)this.getSize().width / (float)(maxX - minX);
        float scaleHeight = (float)this.getSize().height / (float)(maxY - minY);
        this.scale = Math.min(scaleWidth, scaleHeight);
        if (this.scale < 0.5f) {
            this.scale = 0.5f;
        }
        this.xOffset -= ((float)this.getSize().width / this.scale - (float)(maxX - minX)) / 2.0f;
        this.yOffset -= ((float)this.getSize().height / this.scale - (float)(maxY - minY)) / 2.0f;
    }

    public void resetFitScaleWithArea(Rect area) {
        int minX = area.left;
        int minY = area.up;
        int maxX = area.right;
        int maxY = area.down;
        this.xOffset = minX;
        this.yOffset = minY;
        float scaleWidth = (float)this.getSize().width / (float)(maxX - minX);
        float scaleHeight = (float)this.getSize().height / (float)(maxY - minY);
        this.scale = Math.min(scaleWidth, scaleHeight);
        if (this.scale < 0.5f) {
            this.scale = 0.5f;
        }
        this.xOffset -= ((float)this.getSize().width / this.scale - (float)(maxX - minX)) / 2.0f;
        this.yOffset -= ((float)this.getSize().height / this.scale - (float)(maxY - minY)) / 2.0f;
    }

    public Vector2d getViewPosition(double x, double y) {
        double realX = (x - (double)this.getPositionX()) / (double)this.scale + (double)this.xOffset;
        double realY = (y - (double)this.getPositionY()) / (double)this.scale + (double)this.yOffset;
        return new Vector2d(realX, realY);
    }

    public Vector2i getViewPosition(int x, int y) {
        float realX = (float)(x - this.getPositionX()) / this.scale + this.xOffset;
        float realY = (float)(y - this.getPositionY()) / this.scale + this.yOffset;
        return new Vector2i((int)realX, (int)realY);
    }

    public Vector2f getViewPosition(float x, float y) {
        float realX = (x - (float)this.getPositionX()) / this.scale + this.xOffset;
        float realY = (y - (float)this.getPositionY()) / this.scale + this.yOffset;
        return new Vector2f(realX, realY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        Vector2d realMouse = this.getViewPosition(mouseX, mouseY);
        if (super.mouseClicked(realMouse.x, realMouse.y, button)) {
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY) && button == 0) {
            this.isDragging = true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        Vector2d realMouse = this.getViewPosition(mouseX, mouseY);
        return super.mouseReleased(realMouse.x, realMouse.y, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            this.xOffset += (float)(this.lastMouseX - mouseX) / this.scale;
            this.yOffset += (float)(this.lastMouseY - mouseY) / this.scale;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
        Vector2d realMouse = this.getViewPosition(mouseX, mouseY);
        return super.mouseDragged(realMouse.x, realMouse.y, button, dragX /= (double)this.scale, dragY /= (double)this.scale) || this.isDragging;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        Vector2d realMouse = this.getViewPosition(mouseX, mouseY);
        if (super.mouseWheelMove(realMouse.x, realMouse.y, wheelDelta)) {
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            float newScale = (float)Mth.clamp((double)((double)this.scale + wheelDelta * (double)0.1f), (double)0.1f, (double)10.0);
            if (newScale != this.scale) {
                this.xOffset += (float)(mouseX - (double)this.getPositionX()) / this.scale - (float)(mouseX - (double)this.getPositionX()) / newScale;
                this.yOffset += (float)(mouseY - (double)this.getPositionY()) / this.scale - (float)(mouseY - (double)this.getPositionY()) / newScale;
                this.scale = newScale;
            }
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseMoved(double mouseX, double mouseY) {
        Vector2d realMouse = this.getViewPosition(mouseX, mouseY);
        return super.mouseMoved(realMouse.x, realMouse.y);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawTooltipTexts(mouseX, mouseY);
        Vector2i realMouse = this.getViewPosition(mouseX, mouseY);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.getPositionX(), (float)this.getPositionY(), 0.0f);
        graphics.pose().scale(this.scale, this.scale, 1.0f);
        graphics.pose().translate(-this.xOffset, -this.yOffset, 0.0f);
        this.drawWidgetsForeground(graphics, realMouse.x, realMouse.y, partialTicks);
        graphics.pose().popPose();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
        Vector2i realMouse = this.getViewPosition(mouseX, mouseY);
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.useScissor) {
            Matrix4f trans = graphics.pose().last().pose();
            Vector4f realPos = trans.transform(new Vector4f((float)pos.x, (float)pos.y, 0.0f, 1.0f));
            Vector4f realPos2 = trans.transform(new Vector4f((float)(pos.x + size.width), (float)(pos.y + size.height), 0.0f, 1.0f));
            graphics.enableScissor((int)realPos.x, (int)realPos.y, (int)realPos2.x, (int)realPos2.y);
        }
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.getPositionX(), (float)this.getPositionY(), 0.0f);
        graphics.pose().scale(this.scale, this.scale, 1.0f);
        graphics.pose().translate(-this.xOffset, -this.yOffset, 0.0f);
        if (this.drawGrid) {
            graphics.drawManaged(() -> {
                float w = (float)size.width / this.scale;
                float h = (float)size.height / this.scale;
                int sx = (int)((float)pos.x / this.scale + this.xOffset - w - this.xOffset % (float)this.gridWidth);
                int sy = (int)((float)pos.y / this.scale + this.yOffset - h - this.yOffset % (float)this.gridWidth);
                sx -= sx % this.gridWidth;
                sy -= sy % this.gridWidth;
                int x = sx;
                while ((float)x < (float)sx + 3.0f * w) {
                    int y = sy;
                    while ((float)y < (float)sy + 3.0f * h) {
                        DrawerHelper.drawSolidRect(graphics, x, sy, 1, (int)(3.0f * h), ColorPattern.T_GRAY.color);
                        DrawerHelper.drawSolidRect(graphics, sx, y, (int)(3.0f * w), 1, ColorPattern.T_GRAY.color);
                        y += this.gridWidth;
                    }
                    x += this.gridWidth;
                }
            });
        }
        this.drawWidgetsBackground(graphics, realMouse.x, realMouse.y, partialTicks);
        graphics.pose().popPose();
        if (this.useScissor) {
            graphics.disableScissor();
        }
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public void setXOffset(float xOffset) {
        this.xOffset = xOffset;
    }

    public void setYOffset(float yOffset) {
        this.yOffset = yOffset;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGrid(boolean drawGrid) {
        this.drawGrid = drawGrid;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int gridWidth) {
        this.gridWidth = gridWidth;
    }

    public boolean isUseScissor() {
        return this.useScissor;
    }

    public void setUseScissor(boolean useScissor) {
        this.useScissor = useScissor;
    }
}

