/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@LDLRegister(name="color", group="widget.basic")
public class HsbColorWidget
extends Widget
implements IConfigurableWidget {
    @Configurable(name="ldlib.gui.editor.name.gap")
    @NumberRange(range={0.0, 2.147483647E9})
    private int gap = 10;
    @Configurable(name="ldlib.gui.editor.name.barWidth")
    @NumberRange(range={0.0, 2.147483647E9})
    private int barWidth = 10;
    private float h = 204.0f;
    private float s = 0.72f;
    private float b = 0.94f;
    private float alpha = 1.0f;
    private int argb;
    private boolean isDraggingMain;
    private boolean isDraggingColorSlider;
    private boolean isDraggingAlphaSlider;
    private HSB_MODE mode = HSB_MODE.H;
    private IntSupplier colorSupplier;
    private IntConsumer onChanged;
    @Configurable(name="ldlib.gui.editor.name.showRGB")
    private boolean showRGB = true;
    @Configurable(name="ldlib.gui.editor.name.showAlpha")
    private boolean showAlpha = true;

    public HsbColorWidget() {
        this(0, 0, 100, 100);
    }

    public HsbColorWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.refreshRGB();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.isClientSideWidget && this.colorSupplier != null) {
            this.setColor(this.colorSupplier.getAsInt());
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.colorSupplier != null && !this.isClientSideWidget) {
            int lastColor = this.argb;
            this.setColor(this.colorSupplier.getAsInt());
            if (lastColor != this.argb) {
                this.writeUpdateInfo(-1, buffer -> buffer.writeVarInt(this.argb));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull @NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Matrix4f pose = graphics.pose().last().pose();
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.showRGB) {
            BufferBuilder builder = Tesselator.getInstance().getBuilder();
            this.drawHsbContext(pose, builder, x, y, width - this.barWidth - this.gap, height - this.barWidth - this.gap);
        }
        if (this.showAlpha) {
            DrawerHelper.drawGradientRect(graphics, x, y + height - this.barWidth, width - this.barWidth - this.gap, this.barWidth, this.argb & 0xFFFFFF, this.argb | 0xFF000000, true);
        }
        DrawerHelper.drawSolidRect(graphics, x + width - this.barWidth, y + height - this.barWidth, this.barWidth, this.barWidth, this.argb);
        float color = 0.0f;
        float mainX = 0.0f;
        float mainY = 0.0f;
        switch (this.mode) {
            case H: {
                mainX = this.s;
                mainY = 1.0f - this.b;
                color = 1.0f - this.h / 360.0f;
                break;
            }
            case S: {
                mainX = this.h / 360.0f;
                mainY = 1.0f - this.b;
                color = 1.0f - this.s;
                break;
            }
            case B: {
                mainX = this.h / 360.0f;
                mainY = 1.0f - this.s;
                color = 1.0f - this.b;
            }
        }
        if (this.showRGB) {
            DrawerHelper.drawSolidRect(graphics, (int)((float)x + mainX * (float)(width - this.barWidth - this.gap)) - 1, (int)((float)y + mainY * (float)(height - this.barWidth - this.gap)) - 1, 3, 3, -65536);
            DrawerHelper.drawSolidRect(graphics, x + width - this.barWidth - 2, (int)((float)y + color * (float)(height - this.barWidth - this.gap)), this.barWidth + 4, 1, -65536);
            this.renderInfo(graphics, x, y, width - this.barWidth - this.gap, height - this.barWidth - this.gap);
            DrawerHelper.drawBorder(graphics, x, y, width - this.barWidth - this.gap, height - this.barWidth - this.gap, ColorPattern.WHITE.color, 2);
        }
        if (this.showAlpha) {
            DrawerHelper.drawSolidRect(graphics, (int)((float)x + this.alpha * (float)(width - this.barWidth - this.gap)), y + height - this.barWidth - 2, 1, this.barWidth + 4, -65536);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawHsbContext(Matrix4f pose, BufferBuilder builder, int x, int y, int width, int height) {
        RenderSystem.setShader(Shaders::getHsbShader);
        builder.begin(VertexFormat.Mode.QUADS, Shaders.HSB_VERTEX_FORMAT);
        this.renderMain(pose, builder, x, y, width, height);
        this.renderColorSlide(pose, builder, x, y, width, height);
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderMain(Matrix4f pose, BufferBuilder builder, int x, int y, int width, int height) {
        float _h = 0.0f;
        float _s = 0.0f;
        float _b = 0.0f;
        switch (this.mode) {
            case H: {
                _h = this.h;
                _s = 0.0f;
                _b = 1.0f;
                break;
            }
            case S: {
                _h = 0.0f;
                _s = this.s;
                _b = 1.0f;
                break;
            }
            case B: {
                _h = 0.0f;
                _s = 1.0f;
                _b = this.b;
            }
        }
        builder.vertex(pose, (float)x, (float)y, 0.0f);
        this.putColor(builder, _h, _s, _b).nextElement();
        builder.endVertex();
        switch (this.mode) {
            case H: {
                _h = this.h;
                _s = 0.0f;
                _b = 0.0f;
                break;
            }
            case S: {
                _h = 0.0f;
                _s = this.s;
                _b = 0.0f;
                break;
            }
            case B: {
                _h = 0.0f;
                _s = 0.0f;
                _b = this.b;
            }
        }
        builder.vertex(pose, (float)x, (float)(y + height), 0.0f);
        this.putColor(builder, _h, _s, _b).nextElement();
        builder.endVertex();
        switch (this.mode) {
            case H: {
                _h = this.h;
                _s = 1.0f;
                _b = 0.0f;
                break;
            }
            case S: {
                _h = 360.0f;
                _s = this.s;
                _b = 0.0f;
                break;
            }
            case B: {
                _h = 360.0f;
                _s = 0.0f;
                _b = this.b;
            }
        }
        builder.vertex(pose, (float)(x + width), (float)(y + height), 0.0f);
        this.putColor(builder, _h, _s, _b).nextElement();
        builder.endVertex();
        switch (this.mode) {
            case H: {
                _h = this.h;
                _s = 1.0f;
                _b = 1.0f;
                break;
            }
            case S: {
                _h = 360.0f;
                _s = this.s;
                _b = 1.0f;
                break;
            }
            case B: {
                _h = 360.0f;
                _s = 1.0f;
                _b = this.b;
            }
        }
        builder.vertex(pose, (float)(x + width), (float)y, 0.0f);
        this.putColor(builder, _h, _s, _b).nextElement();
        builder.endVertex();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderColorSlide(Matrix4f pose, BufferBuilder builder, int x, int y, int width, int height) {
        float _h = 0.0f;
        float _s = 0.0f;
        float _b = 0.0f;
        int barX = x + width + this.gap;
        switch (this.mode) {
            case H: {
                _h = 0.0f;
                _s = 1.0f;
                _b = 1.0f;
                break;
            }
            case S: {
                _h = this.h;
                _s = 0.0f;
                _b = this.b;
                break;
            }
            case B: {
                _h = this.h;
                _s = this.s;
                _b = 0.0f;
            }
        }
        builder.vertex(pose, (float)barX, (float)(y + height), 0.0f);
        this.putColor(builder, _h, _s, _b).nextElement();
        builder.endVertex();
        builder.vertex(pose, (float)(barX + this.barWidth), (float)(y + height), 0.0f);
        this.putColor(builder, _h, _s, _b).nextElement();
        builder.endVertex();
        switch (this.mode) {
            case H: {
                _h = 360.0f;
                _s = 1.0f;
                _b = 1.0f;
                break;
            }
            case S: {
                _h = this.h;
                _s = 1.0f;
                _b = this.b;
                break;
            }
            case B: {
                _h = this.h;
                _s = this.s;
                _b = 1.0f;
            }
        }
        builder.vertex(pose, (float)(barX + this.barWidth), (float)y, 0.0f);
        this.putColor(builder, _h, _s, _b).nextElement();
        builder.endVertex();
        builder.vertex(pose, (float)barX, (float)y, 0.0f);
        this.putColor(builder, _h, _s, _b).nextElement();
        builder.endVertex();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderInfo(@Nonnull GuiGraphics graphics, int x, int y, int width, int height) {
        Font font = Minecraft.getInstance().font;
        y += 2;
        int strX = x + 10;
        float f = height;
        Objects.requireNonNull(font);
        int n = (int)Math.max(0.0f, (f - 7.0f * 9.0f) / 6.0f);
        Objects.requireNonNull(font);
        int strGapY = n + 9;
        DrawerHelper.drawText(graphics, "h:" + (int)this.h + "\u00b0", strX, y, 1.0f, -1, true);
        DrawerHelper.drawText(graphics, "s:" + (int)(this.s * 100.0f) + "%", strX, y + strGapY, 1.0f, -1, true);
        DrawerHelper.drawText(graphics, "b:" + (int)(this.b * 100.0f) + "%", strX, y + strGapY * 2, 1.0f, -1, true);
        DrawerHelper.drawText(graphics, "r:" + (this.argb >> 16 & 0xFF), strX, y + strGapY * 3, 1.0f, -1, true);
        DrawerHelper.drawText(graphics, "g:" + (this.argb >> 8 & 0xFF), strX, y + strGapY * 4, 1.0f, -1, true);
        DrawerHelper.drawText(graphics, "b:" + (this.argb & 0xFF), strX, y + strGapY * 5, 1.0f, -1, true);
        DrawerHelper.drawText(graphics, "a:" + (this.argb >> 24 & 0xFF), strX, y + strGapY * 6, 1.0f, -1, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private BufferBuilder putColor(BufferBuilder builder, float h, float s, float b) {
        return this.putColor(builder, h, s, b, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private BufferBuilder putColor(BufferBuilder builder, float h, float s, float b, float a) {
        builder.putFloat(0, h);
        builder.putFloat(4, s);
        builder.putFloat(8, b);
        builder.putFloat(12, a);
        return builder;
    }

    public boolean isMouseOverMain(double mouseX, double mouseY) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width - this.gap - this.barWidth;
        int height = this.getSize().height - this.gap - this.barWidth;
        return HsbColorWidget.isMouseOver(x, y, width, height, mouseX, mouseY);
    }

    public boolean isMouseOverColorSlider(double mouseX, double mouseY) {
        int x = this.getPosition().x + this.getSize().width - this.barWidth;
        int y = this.getPosition().y;
        int height = this.getSize().height - this.gap - this.barWidth;
        return HsbColorWidget.isMouseOver(x, y, this.barWidth, height, mouseX, mouseY);
    }

    public boolean isMouseOverAlphaSlider(double mouseX, double mouseY) {
        int x = this.getPosition().x;
        int y = this.getPosition().y + this.getSize().width - this.barWidth;
        int width = this.getSize().width - this.gap - this.barWidth;
        return HsbColorWidget.isMouseOver(x, y, width, this.barWidth, mouseX, mouseY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.isDraggingMain = false;
        this.isDraggingColorSlider = false;
        this.isDraggingAlphaSlider = false;
        if (this.isMouseOverMain(mouseX, mouseY) && this.showRGB) {
            if (button == 0) {
                this.isDraggingMain = true;
            } else if (button == 1) {
                this.mode = switch (this.mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case HSB_MODE.H -> HSB_MODE.S;
                    case HSB_MODE.S -> HSB_MODE.B;
                    case HSB_MODE.B -> HSB_MODE.H;
                };
                return true;
            }
        } else if (this.isMouseOverColorSlider(mouseX, mouseY) && this.showRGB) {
            if (button == 0) {
                this.isDraggingColorSlider = true;
            }
        } else if (this.isMouseOverAlphaSlider(mouseX, mouseY) && this.showAlpha && button == 0) {
            this.isDraggingAlphaSlider = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void refreshRGB() {
        this.argb = ColorUtils.HSBtoRGB(this.h / 360.0f, this.s, this.b);
        this.argb = ColorUtils.color(this.alpha, ColorUtils.red(this.argb), ColorUtils.green(this.argb), ColorUtils.blue(this.argb));
        if (this.onChanged != null) {
            this.onChanged.accept(this.argb);
        }
        if (this.isRemote() && !this.isClientSideWidget) {
            this.writeClientAction(-1, buffer -> buffer.writeVarInt(this.argb));
        }
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (id == -1) {
            this.setColor(buffer.readVarInt());
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Override
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == -1) {
            this.setColor(buffer.readVarInt());
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    private static float normalizeMouse(double mouse, int pos, int size) {
        if (mouse >= (double)(pos + size)) {
            return 1.0f;
        }
        if (mouse <= (double)pos) {
            return 0.0f;
        }
        double x = mouse - (double)pos;
        double y = x % (double)size / (double)size;
        if (y < 0.0) {
            x = -x;
            y = -y;
        }
        return (float)((x /= (double)size) % 2.0 > 1.0 ? 1.0 - y : y);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.isDraggingMain) {
            float normalizedX = HsbColorWidget.normalizeMouse(mouseX, x, width - this.gap - this.barWidth);
            float normalizedY = HsbColorWidget.normalizeMouse(mouseY, y, height - this.gap - this.barWidth);
            switch (this.mode) {
                case H: {
                    this.s = normalizedX;
                    this.b = 1.0f - normalizedY;
                    break;
                }
                case S: {
                    this.h = normalizedX * 360.0f;
                    this.b = 1.0f - normalizedY;
                    break;
                }
                case B: {
                    this.h = normalizedX * 360.0f;
                    this.s = 1.0f - normalizedY;
                }
            }
            this.refreshRGB();
            return true;
        }
        if (this.isDraggingColorSlider) {
            float normalizedY = HsbColorWidget.normalizeMouse(mouseY, y, height - this.gap - this.barWidth);
            switch (this.mode) {
                case H: {
                    this.h = (1.0f - normalizedY) * 360.0f;
                    break;
                }
                case S: {
                    this.s = 1.0f - normalizedY;
                    break;
                }
                case B: {
                    this.b = 1.0f - normalizedY;
                }
            }
            this.refreshRGB();
            return true;
        }
        if (this.isDraggingAlphaSlider) {
            this.alpha = HsbColorWidget.normalizeMouse(mouseX, x, width - this.gap - this.barWidth);
            this.refreshRGB();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDraggingMain = false;
        this.isDraggingColorSlider = false;
        this.isDraggingAlphaSlider = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public HsbColorWidget setColor(int argb) {
        if (this.argb == argb) {
            return this;
        }
        this.alpha = ColorUtils.alpha(argb);
        float[] hsb = ColorUtils.RGBtoHSB(argb);
        hsb[0] = hsb[0] * 360.0f;
        this.h = hsb[0];
        this.s = hsb[1];
        this.b = hsb[2];
        this.refreshRGB();
        return this;
    }

    public HsbColorWidget setGap(int gap) {
        this.gap = gap;
        return this;
    }

    public HsbColorWidget setBarWidth(int barWidth) {
        this.barWidth = barWidth;
        return this;
    }

    public HsbColorWidget setColorSupplier(IntSupplier colorSupplier) {
        this.colorSupplier = colorSupplier;
        return this;
    }

    public HsbColorWidget setOnChanged(IntConsumer onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    public HsbColorWidget setShowRGB(boolean showRGB) {
        this.showRGB = showRGB;
        return this;
    }

    public boolean isShowRGB() {
        return this.showRGB;
    }

    public HsbColorWidget setShowAlpha(boolean showAlpha) {
        this.showAlpha = showAlpha;
        return this;
    }

    public boolean isShowAlpha() {
        return this.showAlpha;
    }

    private static enum HSB_MODE {
        H("hue"),
        S("saturation"),
        B("brightness");

        private final String name;

        private HSB_MODE(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

