/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStackSelectorWidget
extends WidgetGroup {
    private Consumer<ItemStack> onItemStackUpdate;
    private final IItemTransfer handler;
    private final TextFieldWidget itemField;
    private ItemStack item = ItemStack.EMPTY;

    public ItemStackSelectorWidget(int x, int y, int width) {
        this(x, y, width, true);
    }

    public ItemStackSelectorWidget(int x, int y, int width, boolean nbt) {
        super(x, y, width, 20);
        this.setClientSideWidget();
        this.itemField = (TextFieldWidget)new TextFieldWidget(22, 0, width - 46, 20, null, s -> {
            Item item;
            if (s != null && !s.isEmpty() && !ItemStack.isSameItemSameTags((ItemStack)(item = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(s))).getDefaultInstance(), (ItemStack)this.item)) {
                this.item = item.getDefaultInstance();
                this.onUpdate();
            }
        }).setResourceLocationOnly().setHoverTooltips("ldlib.gui.tips.item_selector");
        this.handler = new ItemStackTransfer(1);
        this.addWidget(new PhantomSlotWidget(this.handler, 0, 1, 1).setClearSlotOnRightClick(true).setChangeListener(() -> {
            this.setItemStack(this.handler.getStackInSlot(0));
            this.onUpdate();
        }).setBackgroundTexture(new ColorBorderTexture(1, -1)));
        this.addWidget(this.itemField);
        if (nbt) {
            this.addWidget(new ButtonWidget(width - 21, 0, 20, 20, null, cd -> {
                if (this.item.isEmpty()) {
                    return;
                }
                TextFieldWidget nbtField = new TextFieldWidget(10, 10, this.getGui().mainGroup.getSize().width - 50, 20, null, s -> {
                    try {
                        this.item.setTag(TagParser.parseTag((String)s));
                        this.onUpdate();
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                });
                new DialogWidget(this.getGui().mainGroup, this.isClientSideWidget).setOnClosed(this::onUpdate).addWidget(nbtField);
                if (this.item.hasTag()) {
                    nbtField.setCurrentString(this.item.getTag().toString());
                }
            }).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("NBT", -1).setDropShadow(true)).setHoverBorderTexture(1, -1).setHoverTooltips("ldlib.gui.tips.item_tag"));
        }
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public ItemStackSelectorWidget setItemStack(ItemStack itemStack) {
        this.item = Objects.requireNonNullElse(itemStack, ItemStack.EMPTY).copy();
        this.handler.setStackInSlot(0, this.item);
        this.itemField.setCurrentString(BuiltInRegistries.ITEM.getKey((Object)this.item.getItem()).toString());
        return this;
    }

    public ItemStackSelectorWidget setOnItemStackUpdate(Consumer<ItemStack> onItemStackUpdate) {
        this.onItemStackUpdate = onItemStackUpdate;
        return this;
    }

    private void onUpdate() {
        this.handler.setStackInSlot(0, this.item);
        if (this.onItemStackUpdate != null) {
            this.onItemStackUpdate.accept(this.item);
        }
    }
}

