/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeNode;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MenuWidget<K, T>
extends WidgetGroup {
    public static IGuiTexture NODE_TEXTURE = new IGuiTexture(){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
            ColorPattern.BLACK.rectTexture().draw(graphics, mouseX, mouseY, x, y, width, height);
            Icons.RIGHT.draw(graphics, mouseX, mouseY, x + (float)width - (float)height + 3.0f, y + 3.0f, height - 6, height - 6);
        }
    };
    public static IGuiTexture LEAF_TEXTURE = ColorPattern.BLACK.rectTexture();
    public static IGuiTexture NODE_HOVER_TEXTURE = ColorPattern.T_GRAY.rectTexture();
    public static IGuiTexture BACKGROUND = new GuiTextureGroup(new ColorRectTexture(-12828346), ColorPattern.GRAY.borderTexture(1));
    protected final TreeNode<K, T> root;
    protected final int nodeHeight;
    @Nullable
    protected IGuiTexture nodeTexture;
    @Nullable
    protected IGuiTexture leafTexture;
    @Nullable
    protected IGuiTexture nodeHoverTexture;
    @Nullable
    protected Consumer<TreeNode<K, T>> onNodeClicked;
    @Nullable
    protected Function<K, IGuiTexture> keyIconSupplier;
    @Nullable
    protected Function<K, String> keyNameSupplier;
    @Nullable
    protected Predicate<K> crossLinePredicate;
    protected boolean autoClose;
    protected Map<TreeNode<K, T>, WidgetGroup> children;
    protected MenuWidget<K, T> opened;

    public MenuWidget(int xPosition, int yPosition, int nodeHeight, TreeNode<K, T> root) {
        super(xPosition, yPosition, 100, nodeHeight);
        this.root = root;
        this.autoClose = true;
        this.nodeHeight = nodeHeight;
        this.children = new LinkedHashMap<TreeNode<K, T>, WidgetGroup>();
    }

    public void close() {
        if (this.parent != null) {
            this.parent.waitToRemoved(this);
        }
    }

    @Override
    public void initWidget() {
        int maxWidth = this.getSize().width;
        int maxHeight = 1;
        if (!this.root.isLeaf()) {
            String name;
            K key;
            if (this.isRemote()) {
                for (TreeNode<K, T> child : this.root.getChildren()) {
                    key = child.getKey();
                    name = key.toString();
                    if (this.keyNameSupplier != null) {
                        name = this.keyNameSupplier.apply(key);
                    }
                    maxWidth = Math.max(Minecraft.getInstance().font.width(LocalizationUtils.format(name, new Object[0])) + 4 + 2 * this.nodeHeight, maxWidth);
                }
            }
            for (TreeNode<K, T> child : this.root.getChildren()) {
                key = child.getKey();
                if (this.crossLinePredicate != null && this.crossLinePredicate.test(key)) {
                    ++maxHeight;
                    continue;
                }
                name = key.toString();
                if (this.keyNameSupplier != null) {
                    name = this.keyNameSupplier.apply(key);
                }
                WidgetGroup group = new WidgetGroup(0, maxHeight, maxWidth, this.nodeHeight);
                this.children.put(child, group);
                if (child.isLeaf()) {
                    group.setBackground(Objects.requireNonNullElseGet(this.leafTexture, () -> LEAF_TEXTURE));
                    group.addWidget(new ButtonWidget(0, 0, maxWidth, this.nodeHeight, null, cd -> {
                        if (this.onNodeClicked != null) {
                            this.onNodeClicked.accept(child);
                        }
                        if (this.autoClose) {
                            WidgetGroup p = this;
                            while (p != null) {
                                if (p.parent != null && !(p.parent instanceof MenuWidget)) {
                                    p.parent.waitToRemoved(p);
                                    return;
                                }
                                p = p.parent;
                            }
                        }
                    }).setHoverTexture(Objects.requireNonNullElseGet(this.nodeHoverTexture, () -> NODE_HOVER_TEXTURE)));
                } else {
                    group.setBackground(Objects.requireNonNullElseGet(this.nodeTexture, () -> NODE_TEXTURE));
                    group.addWidget(new ButtonWidget(0, 0, maxWidth, this.nodeHeight, null).setHoverTexture(Objects.requireNonNullElseGet(this.nodeHoverTexture, () -> NODE_HOVER_TEXTURE)));
                }
                if (this.keyIconSupplier != null) {
                    group.addWidget(new ImageWidget(2, 1, this.nodeHeight - 2, this.nodeHeight - 2, this.keyIconSupplier.apply(child.getKey())));
                }
                group.addWidget(new ImageWidget(this.nodeHeight + 2, 0, maxWidth - 2 * this.nodeHeight - 4, this.nodeHeight, new TextTexture(name).setType(TextTexture.TextType.LEFT)));
                this.addWidget(group);
                maxHeight += this.nodeHeight;
            }
        }
        Position pos = this.getPosition();
        this.setSize(new Size(maxWidth, maxHeight));
        int rightSpace = this.getGui().getScreenWidth() - pos.getX();
        int bottomSpace = this.getGui().getScreenHeight() - pos.getY();
        if (rightSpace < maxWidth) {
            int leftSpace;
            WidgetGroup widgetGroup = this.parent;
            if (widgetGroup instanceof MenuWidget) {
                MenuWidget menuWidget = (MenuWidget)widgetGroup;
                this.addSelfPosition(-menuWidget.getSize().width - maxWidth, 0);
            }
            if ((rightSpace = this.getGui().getScreenWidth() - this.getPosition().getX()) < maxWidth) {
                this.addSelfPosition(-(maxWidth - rightSpace), 0);
            }
            if ((leftSpace = this.getPosition().getX()) < 0) {
                this.addSelfPosition(-leftSpace, 0);
            }
        }
        if (bottomSpace < maxHeight) {
            int topSpace;
            if (this.parent instanceof MenuWidget) {
                this.addSelfPosition(0, this.nodeHeight - maxHeight);
            }
            if ((bottomSpace = this.getGui().getScreenHeight() - this.getPosition().getY()) < maxHeight) {
                this.addSelfPosition(0, -(maxHeight - bottomSpace));
            }
            if ((topSpace = this.getPosition().getY()) < 0) {
                this.addSelfPosition(0, -topSpace);
            }
        }
        super.initWidget();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!super.mouseClicked(mouseX, mouseY, button)) {
            if (this.autoClose && !(this.parent instanceof MenuWidget)) {
                this.close();
            }
            return false;
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseMoved(double mouseX, double mouseY) {
        if (super.mouseMoved(mouseX, mouseY)) {
            return true;
        }
        if (this.root.getChildren() != null) {
            int maxHeight = 0;
            for (TreeNode<K, T> node : this.root.getChildren()) {
                if (this.crossLinePredicate != null && this.crossLinePredicate.test(node.getKey())) {
                    ++maxHeight;
                    continue;
                }
                WidgetGroup widget = this.children.get(node);
                if (widget.isMouseOverElement(mouseX, mouseY)) {
                    if (this.opened != null && this.opened.root == node) {
                        return true;
                    }
                    if (this.opened != null) {
                        this.removeWidget(this.opened);
                        this.opened = null;
                    }
                    if (!node.isLeaf()) {
                        this.opened = new MenuWidget<K, T>(this.getSize().width, maxHeight, this.nodeHeight, node).setNodeHoverTexture(this.nodeHoverTexture).setNodeTexture(this.nodeTexture).setLeafTexture(this.leafTexture).setOnNodeClicked(this.onNodeClicked).setKeyIconSupplier(this.keyIconSupplier).setKeyNameSupplier(this.keyNameSupplier).setCrossLinePredicate(this.crossLinePredicate);
                        this.addWidget(this.opened.setBackground(this.backgroundTexture));
                    }
                    return true;
                }
                maxHeight += this.nodeHeight;
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        int screenHeight = this.getGui().getScreenHeight();
        if (screenHeight < size.height && this.isMouseOverElement(mouseX, mouseY)) {
            int offsetY = Mth.clamp((int)(pos.getY() + (wheelDelta > 0.0 ? -this.nodeHeight : this.nodeHeight)), (int)0, (int)(screenHeight - size.height));
            this.addSelfPosition(0, offsetY - pos.getY());
            return true;
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    public MenuWidget<K, T> setNodeTexture(@Nullable IGuiTexture nodeTexture) {
        this.nodeTexture = nodeTexture;
        return this;
    }

    public MenuWidget<K, T> setLeafTexture(@Nullable IGuiTexture leafTexture) {
        this.leafTexture = leafTexture;
        return this;
    }

    public MenuWidget<K, T> setNodeHoverTexture(@Nullable IGuiTexture nodeHoverTexture) {
        this.nodeHoverTexture = nodeHoverTexture;
        return this;
    }

    public MenuWidget<K, T> setOnNodeClicked(@Nullable Consumer<TreeNode<K, T>> onNodeClicked) {
        this.onNodeClicked = onNodeClicked;
        return this;
    }

    public MenuWidget<K, T> setKeyIconSupplier(@Nullable Function<K, IGuiTexture> keyIconSupplier) {
        this.keyIconSupplier = keyIconSupplier;
        return this;
    }

    public MenuWidget<K, T> setKeyNameSupplier(@Nullable Function<K, String> keyNameSupplier) {
        this.keyNameSupplier = keyNameSupplier;
        return this;
    }

    public MenuWidget<K, T> setCrossLinePredicate(@Nullable Predicate<K> crossLinePredicate) {
        this.crossLinePredicate = crossLinePredicate;
        return this;
    }

    public MenuWidget<K, T> setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }
}

