/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.collect.Lists;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.forge.PhantomFluidWidgetImpl;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@Deprecated(since="1.21")
public class PhantomFluidWidget
extends TankWidget
implements IGhostIngredientTarget,
IConfigurableWidget {
    private Supplier<FluidStack> phantomFluidGetter = FluidStack::empty;
    private Consumer<FluidStack> phantomFluidSetter;
    @Nullable
    protected FluidStack lastPhantomStack;

    public PhantomFluidWidget(@Nullable IFluidTransfer fluidTank, int tank, int x, int y, int width, int height, Supplier<FluidStack> phantomFluidGetter, Consumer<FluidStack> phantomFluidSetter) {
        super(fluidTank, tank, x, y, width, height, false, false);
        this.phantomFluidSetter = f -> {};
        this.phantomFluidGetter = phantomFluidGetter;
        this.phantomFluidSetter = phantomFluidSetter;
    }

    @Override
    @ConfigSetter(field="allowClickFilled")
    public PhantomFluidWidget setAllowClickFilled(boolean v) {
        return this;
    }

    @Override
    @ConfigSetter(field="allowClickDrained")
    public PhantomFluidWidget setAllowClickDrained(boolean v) {
        return this;
    }

    protected void setLastPhantomStack(FluidStack fluid) {
        if (fluid != null) {
            this.lastPhantomStack = fluid.copy();
            this.lastPhantomStack.setAmount(1L);
        } else {
            this.lastPhantomStack = null;
        }
    }

    public static FluidStack drainFrom(Object ingredient) {
        ItemStack itemStack;
        IFluidTransfer handler;
        Ingredient ing;
        ItemStack[] items;
        if (ingredient instanceof Ingredient && (items = (ing = (Ingredient)ingredient).getItems()).length > 0) {
            ingredient = items[0];
        }
        if (ingredient instanceof ItemStack && (handler = FluidTransferHelper.getFluidTransfer(new ItemStackTransfer(itemStack = (ItemStack)ingredient), 0)) != null) {
            return handler.drain(Long.MAX_VALUE, true);
        }
        return FluidStack.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Target> getPhantomTargets(Object ingredient) {
        if (LDLib.isReiLoaded() && ingredient instanceof dev.architectury.fluid.FluidStack) {
            dev.architectury.fluid.FluidStack fluidStack = (dev.architectury.fluid.FluidStack)ingredient;
            ingredient = FluidStack.create(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
        }
        if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
            EmiStack fluidEmiStack = (EmiStack)ingredient;
            Fluid fluid = (Fluid)fluidEmiStack.getKeyOfType(Fluid.class);
            if (fluid == null) {
                Item item = (Item)fluidEmiStack.getKeyOfType(Item.class);
                Object object = ingredient = item == null ? null : new ItemStack((ItemLike)item, (int)fluidEmiStack.getAmount());
                if (ingredient instanceof ItemStack) {
                    ItemStack itemStack = (ItemStack)ingredient;
                    itemStack.setTag(fluidEmiStack.getNbt());
                }
            } else {
                ingredient = FluidStack.create(fluid, fluidEmiStack.getAmount() == 0L ? 1000L : fluidEmiStack.getAmount(), fluidEmiStack.getNbt());
            }
        }
        if (LDLib.isJeiLoaded() && ingredient instanceof ITypedIngredient) {
            ITypedIngredient typedIngredient = (ITypedIngredient)ingredient;
            ingredient = PhantomFluidWidget.checkJEIIngredient(typedIngredient.getIngredient());
        }
        if (!(ingredient instanceof FluidStack) && PhantomFluidWidget.drainFrom(ingredient).isEmpty()) {
            return Collections.emptyList();
        }
        final Rect2i rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Override
            @Nonnull
            public Rect2i getArea() {
                return rectangle;
            }

            @Override
            public void accept(@Nonnull Object ingredient) {
                FluidStack ingredientStack;
                Object fluidStack;
                if (LDLib.isReiLoaded() && ingredient instanceof dev.architectury.fluid.FluidStack) {
                    fluidStack = (dev.architectury.fluid.FluidStack)ingredient;
                    ingredient = FluidStack.create(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
                }
                if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
                    EmiStack fluidEmiStack = (EmiStack)ingredient;
                    Fluid fluid = (Fluid)fluidEmiStack.getKeyOfType(Fluid.class);
                    if (fluid == null) {
                        Item item = (Item)fluidEmiStack.getKeyOfType(Item.class);
                        Object object = ingredient = item == null ? null : new ItemStack((ItemLike)item, (int)fluidEmiStack.getAmount());
                        if (ingredient instanceof ItemStack) {
                            ItemStack itemStack = (ItemStack)ingredient;
                            itemStack.setTag(fluidEmiStack.getNbt());
                        }
                    } else {
                        ingredient = FluidStack.create(fluid, fluidEmiStack.getAmount() == 0L ? 1000L : fluidEmiStack.getAmount(), fluidEmiStack.getNbt());
                    }
                }
                if (LDLib.isJeiLoaded()) {
                    ingredient = PhantomFluidWidget.checkJEIIngredient(ingredient);
                }
                if (ingredient instanceof FluidStack) {
                    fluidStack = (FluidStack)ingredient;
                    ingredientStack = fluidStack;
                } else {
                    ingredientStack = PhantomFluidWidget.drainFrom(ingredient);
                }
                if (ingredientStack != FluidStack.empty()) {
                    PhantomFluidWidget.this.writeClientAction(2, ingredientStack::writeToBuf);
                }
                if (PhantomFluidWidget.this.isClientSideWidget && PhantomFluidWidget.this.phantomFluidSetter != null) {
                    PhantomFluidWidget.this.phantomFluidSetter.accept(ingredientStack);
                }
            }
        }});
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Object checkJEIIngredient(Object ingredient) {
        return PhantomFluidWidgetImpl.checkJEIIngredient(ingredient);
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            this.handlePhantomClick();
        } else if (id == 2) {
            if (this.phantomFluidSetter != null) {
                this.phantomFluidSetter.accept(FluidStack.readFromBuf(buffer));
            }
        } else if (id == 4) {
            this.phantomFluidSetter.accept(FluidStack.empty());
        } else if (id == 5) {
            this.phantomFluidSetter.accept(FluidStack.readFromBuf(buffer));
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        FluidStack stack = this.phantomFluidGetter.get();
        if (stack == null || stack.isEmpty()) {
            if (this.lastPhantomStack != null) {
                this.setLastPhantomStack(null);
                this.writeUpdateInfo(4, buf -> {});
            }
        } else if (this.lastPhantomStack == null || !stack.isFluidEqual(this.lastPhantomStack)) {
            this.setLastPhantomStack(stack);
            this.writeUpdateInfo(5, stack::writeToBuf);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.isClientSideWidget) {
                this.handlePhantomClick();
            } else {
                this.writeClientAction(1, buffer -> {});
            }
            return true;
        }
        return false;
    }

    private void handlePhantomClick() {
        ItemStack itemStack = this.gui.getModularUIContainer().getCarried().copy();
        if (!itemStack.isEmpty()) {
            itemStack.setCount(1);
            IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(this.gui.entityPlayer, this.gui.getModularUIContainer());
            if (handler != null) {
                FluidStack resultFluid = handler.drain(Integer.MAX_VALUE, true);
                if (this.phantomFluidSetter != null) {
                    this.phantomFluidSetter.accept(resultFluid);
                }
            }
        } else if (this.phantomFluidSetter != null) {
            this.phantomFluidSetter.accept(FluidStack.empty());
        }
    }

    @Override
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.lastFluidInTank != null) {
            super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            return;
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        FluidStack stack = this.phantomFluidGetter.get();
        if (stack != null && !stack.isEmpty()) {
            RenderSystem.disableBlend();
            double progress = (double)stack.getAmount() * 1.0 / (double)Math.max(Math.max(stack.getAmount(), this.lastTankCapacity), 1L);
            float drawnU = (float)this.fillDirection.getDrawnU(progress);
            float drawnV = (float)this.fillDirection.getDrawnV(progress);
            float drawnWidth = (float)this.fillDirection.getDrawnWidth(progress);
            float drawnHeight = (float)this.fillDirection.getDrawnHeight(progress);
            int width = size.width - 2;
            int height = size.height - 2;
            int x = pos.x + 1;
            int y = pos.y + 1;
            DrawerHelper.drawFluidForGui(graphics, stack, (float)x + drawnU * (float)width, (float)y + drawnV * (float)height, (float)width * drawnWidth, (float)height * drawnHeight);
            if (this.showAmount) {
                graphics.pose().pushPose();
                graphics.pose().scale(0.5f, 0.5f, 1.0f);
                String s = TextFormattingUtil.formatLongToCompactStringBuckets(stack.getAmount(), 3) + "B";
                Font fontRenderer = Minecraft.getInstance().font;
                graphics.drawString(fontRenderer, s, (int)(((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.width(s) + 21.0f), (int)(((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f), 0xFFFFFF, true);
                graphics.pose().popPose();
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public PhantomFluidWidget() {
        this.phantomFluidSetter = f -> {};
    }

    public void setPhantomFluidGetter(Supplier<FluidStack> phantomFluidGetter) {
        this.phantomFluidGetter = phantomFluidGetter;
    }

    public void setPhantomFluidSetter(Consumer<FluidStack> phantomFluidSetter) {
        this.phantomFluidSetter = phantomFluidSetter;
    }

    @Nullable
    public FluidStack getLastPhantomStack() {
        return this.lastPhantomStack;
    }
}

