/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.collect.Lists;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.mojang.blaze3d.platform.InputConstants;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="phantom_item_slot", group="widget.container")
public class PhantomSlotWidget
extends SlotWidget
implements IGhostIngredientTarget,
IConfigurableWidget {
    private boolean clearSlotOnRightClick;
    @Configurable(name="ldlib.gui.editor.name.maxStackSize")
    @NumberRange(range={0.0, 64.0})
    private int maxStackSize = 64;

    public PhantomSlotWidget() {
    }

    public PhantomSlotWidget(IItemTransfer itemHandler, int slotIndex, int xPosition, int yPosition) {
        super(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public PhantomSlotWidget setClearSlotOnRightClick(boolean clearSlotOnRightClick) {
        this.clearSlotOnRightClick = clearSlotOnRightClick;
        return this;
    }

    @Override
    @ConfigSetter(field="canTakeItems")
    public PhantomSlotWidget setCanTakeItems(boolean v) {
        return this;
    }

    @Override
    @ConfigSetter(field="canPutItems")
    public PhantomSlotWidget setCanPutItems(boolean v) {
        return this;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.slotReference != null && this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            if (this.isClientSideWidget && !this.gui.getModularUIContainer().getCarried().isEmpty()) {
                this.slotReference.set(this.gui.getModularUIContainer().getCarried());
            } else if (button == 1 && this.clearSlotOnRightClick && !this.slotReference.getItem().isEmpty()) {
                this.slotReference.set(ItemStack.EMPTY);
                this.writeClientAction(2, buf -> {});
            } else {
                HOVER_SLOT = this.slotReference;
                this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
                HOVER_SLOT = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, Player player) {
        if (this.slotReference != null && this.gui != null) {
            ItemStack stackHeld = this.gui.getModularUIContainer().getCarried();
            return this.slotClickPhantom(this.slotReference, dragType, clickTypeIn, stackHeld);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canTakeStack(Player player) {
        return false;
    }

    @Override
    public boolean canPutStack(ItemStack stack) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Target> getPhantomTargets(Object ingredient) {
        if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
            EmiStack itemEmiStack = (EmiStack)ingredient;
            Item item = (Item)itemEmiStack.getKeyOfType(Item.class);
            Object object = ingredient = item == null ? null : new ItemStack((ItemLike)item, (int)itemEmiStack.getAmount());
            if (ingredient instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)ingredient;
                itemStack.setTag(itemEmiStack.getNbt());
            }
        }
        if (LDLib.isJeiLoaded() && ingredient instanceof ITypedIngredient) {
            ITypedIngredient itemJeiStack = (ITypedIngredient)ingredient;
            ingredient = itemJeiStack.getItemStack().orElse(ItemStack.EMPTY);
        }
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        final Rect2i rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Override
            @Nonnull
            public Rect2i getArea() {
                return rectangle;
            }

            @Override
            public void accept(@Nonnull Object ingredient) {
                ITypedIngredient itemJeiStack;
                ItemStack itemStack;
                if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
                    EmiStack itemEmiStack = (EmiStack)ingredient;
                    Item item = (Item)itemEmiStack.getKeyOfType(Item.class);
                    Object object = ingredient = item == null ? null : new ItemStack((ItemLike)item, (int)itemEmiStack.getAmount());
                    if (ingredient instanceof ItemStack) {
                        ItemStack itemStack2 = (ItemStack)ingredient;
                        itemStack2.setTag(itemEmiStack.getNbt());
                    }
                }
                if (LDLib.isJeiLoaded() && ingredient instanceof ITypedIngredient && !(itemStack = (itemJeiStack = (ITypedIngredient)ingredient).getItemStack().orElse(ItemStack.EMPTY)).isEmpty()) {
                    ingredient = itemStack;
                }
                if (PhantomSlotWidget.this.slotReference != null && ingredient instanceof ItemStack) {
                    ItemStack stack = (ItemStack)ingredient;
                    long id = Minecraft.getInstance().getWindow().getWindow();
                    boolean shiftDown = InputConstants.isKeyDown((long)id, (int)340) || InputConstants.isKeyDown((long)id, (int)340);
                    ClickType clickType = shiftDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
                    PhantomSlotWidget.this.slotClickPhantom(PhantomSlotWidget.this.slotReference, 0, clickType, stack);
                    PhantomSlotWidget.this.writeClientAction(1, buffer -> {
                        buffer.writeItem(stack);
                        buffer.writeVarInt(0);
                        buffer.writeBoolean(shiftDown);
                    });
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (this.slotReference != null && id == 1) {
            ItemStack stackHeld = buffer.readItem();
            int mouseButton = buffer.readVarInt();
            boolean shiftKeyDown = buffer.readBoolean();
            ClickType clickType = shiftKeyDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
            this.slotClickPhantom(this.slotReference, mouseButton, clickType, stackHeld);
        } else if (this.slotReference != null && id == 2) {
            this.slotReference.set(ItemStack.EMPTY);
        }
    }

    public ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickTypeIn, ItemStack stackHeld) {
        ItemStack stack = ItemStack.EMPTY;
        ItemStack stackSlot = slot.getItem();
        if (!stackSlot.isEmpty()) {
            stack = stackSlot.copy();
        }
        if (mouseButton == 2) {
            this.fillPhantomSlot(slot, ItemStack.EMPTY, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {
            if (stackSlot.isEmpty()) {
                if (!stackHeld.isEmpty()) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld.isEmpty()) {
                this.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
            } else {
                if (!this.areItemsEqual(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
                }
                this.fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        } else if (mouseButton == 5 && !slot.hasItem()) {
            this.fillPhantomSlot(slot, stackHeld, mouseButton);
        }
        return stack;
    }

    private void adjustPhantomSlot(Slot slot, int mouseButton, ClickType clickTypeIn) {
        int stackSize;
        ItemStack stackSlot = slot.getItem();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.getCount() + 1) / 2 : stackSlot.getCount() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.getCount() - 1 : stackSlot.getCount() + 1;
        }
        if (stackSize > slot.getMaxStackSize()) {
            stackSize = slot.getMaxStackSize();
        }
        stackSlot.setCount(Math.min(this.maxStackSize, stackSize));
        slot.set(stackSlot);
    }

    private void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (stackHeld.isEmpty()) {
            slot.set(ItemStack.EMPTY);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.getCount() : 1;
        if (stackSize > slot.getMaxStackSize()) {
            stackSize = slot.getMaxStackSize();
        }
        ItemStack phantomStack = stackHeld.copy();
        phantomStack.setCount(Math.min(this.maxStackSize, stackSize));
        slot.set(phantomStack);
    }

    public boolean areItemsEqual(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStack.matches((ItemStack)itemStack1, (ItemStack)itemStack2);
    }

    public boolean isClearSlotOnRightClick() {
        return this.clearSlotOnRightClick;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }
}

