/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.ISearch;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.SearchEngine;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SearchComponentWidget<T>
extends WidgetGroup {
    public final SearchEngine<T> engine;
    public final IWidgetSearch<T> search;
    public final DraggableScrollableWidgetGroup popUp;
    public final TextFieldWidget textFieldWidget;
    private int capacity = 10;
    protected boolean isShow;
    protected boolean showUp = false;
    @Nullable
    protected Function<T, IGuiTexture> iconProvider;
    @Nullable
    private T current;

    public SearchComponentWidget(int x, int y, int width, int height, IWidgetSearch<T> search) {
        this(x, y, width, height, search, false);
    }

    public SearchComponentWidget(int x, int y, int width, int height, IWidgetSearch<T> search, boolean isServer) {
        super(x, y, width, height);
        if (!isServer) {
            this.setClientSideWidget();
        }
        this.textFieldWidget = new TextFieldWidget(0, 0, width, height, null, null){

            @Override
            public void onFocusChanged(@Nullable Widget lastFocus, Widget focus) {
                if (lastFocus != null && focus != null && lastFocus.parent == focus.parent) {
                    return;
                }
                super.onFocusChanged(lastFocus, focus);
                SearchComponentWidget.this.setShow(this.isFocus());
            }
        };
        this.addWidget(this.textFieldWidget);
        this.popUp = new DraggableScrollableWidgetGroup(0, height, width, 0){

            @Override
            public void onFocusChanged(@Nullable Widget lastFocus, Widget focus) {
                if (lastFocus != null && focus != null && lastFocus.parent == focus.parent) {
                    return;
                }
                super.onFocusChanged(lastFocus, focus);
                SearchComponentWidget.this.setShow(this.isFocus());
            }
        };
        this.addWidget(this.popUp);
        this.popUp.setBackground((IGuiTexture)new ColorRectTexture(-1442840576));
        this.popUp.setVisible(false);
        this.popUp.setActive(true);
        this.search = search;
        this.engine = new SearchEngine<Object>(search, r -> {
            int size = this.popUp.getAllWidgetSize();
            this.popUp.setSize(new Size(this.getSize().width, Math.min(size + 1, this.capacity) * 15));
            if (this.showUp) {
                this.popUp.setSelfPosition(new Position(0, -Math.min(size + 1, this.capacity) * 15));
            } else {
                this.popUp.setSelfPosition(new Position(0, height));
            }
            this.popUp.waitToAdded(this.createCandidateWidget(search, r, size));
            if (isServer) {
                this.writeUpdateInfo(-2, buf -> search.serialize(r, (FriendlyByteBuf)buf));
            }
        });
        this.textFieldWidget.setTextResponder(s -> {
            this.popUp.clearAllWidgets();
            this.popUp.setSize(new Size(this.getSize().width, 0));
            if (this.showUp) {
                this.popUp.setSelfPosition(new Position(0, 0));
            } else {
                this.popUp.setSelfPosition(new Position(0, height));
            }
            this.setShow(true);
            this.engine.searchWord((String)s);
            if (isServer) {
                this.writeUpdateInfo(-1, buffer -> {});
            }
        });
    }

    public void setIconProvider(@Nonnull Function<T, IGuiTexture> iconProvider) {
        this.iconProvider = iconProvider;
        this.textFieldWidget.setSizeWidth(this.getSizeWidth() - 14);
        this.addWidget(0, new ImageWidget(this.getSizeWidth() - this.getSizeHeight(), 0, this.getSizeHeight() - 2, this.getSizeHeight() - 2, () -> this.current == null ? IGuiTexture.EMPTY : (IGuiTexture)iconProvider.apply(this.current)));
    }

    private Widget createCandidateWidget(IWidgetSearch<T> search, T result, int row) {
        int width = this.getSizeWidth();
        WidgetGroup group = new WidgetGroup(0, row * 15, width, 15);
        boolean hasIcon = this.iconProvider != null;
        group.addWidget(new TextTextureWidget(0, 0, hasIcon ? width - 14 : width, 15, search.resultDisplay(result)).textureStyle(t -> t.setType(TextTexture.TextType.ROLL)));
        if (hasIcon) {
            group.addWidget(new ImageWidget(width - 14, 1, 12, 12, this.iconProvider.apply(result)));
        }
        group.addWidget(new ButtonWidget(0, 0, width, 15, IGuiTexture.EMPTY, cd -> {
            search.selectResult(result);
            this.setShow(false);
            this.setCurrent(result);
        }).setHoverBorderTexture(-1, -1));
        return group;
    }

    @Override
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == -1) {
            this.popUp.clearAllWidgets();
            this.popUp.setSize(new Size(this.getSize().width, 0));
            if (this.showUp) {
                this.popUp.setSelfPosition(new Position(0, 0));
            } else {
                this.popUp.setSelfPosition(new Position(0, this.getSize().height));
            }
        } else if (id == -2) {
            T r = this.search.deserialize(buffer);
            int size = this.popUp.getAllWidgetSize();
            this.popUp.setSize(new Size(this.getSize().width, Math.min(size + 1, this.capacity) * 15));
            if (this.showUp) {
                this.popUp.setSelfPosition(new Position(0, -Math.min(size + 1, this.capacity) * 15));
            } else {
                this.popUp.setSelfPosition(new Position(0, this.getSize().height));
            }
            this.popUp.addWidget(this.createCandidateWidget(this.search, r, size));
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    public SearchComponentWidget<T> setCapacity(int capacity) {
        this.capacity = capacity;
        this.popUp.setSize(new Size(this.getSize().width, Math.min(this.popUp.getAllWidgetSize(), capacity) * 15));
        if (this.showUp) {
            this.popUp.setSelfPosition(new Position(0, -Math.min(this.popUp.getAllWidgetSize(), capacity) * 15));
        } else {
            this.popUp.setSelfPosition(new Position(0, this.getSize().height));
        }
        return this;
    }

    public SearchComponentWidget<T> setCurrent(@Nullable T content) {
        this.current = content;
        if (content != null) {
            this.textFieldWidget.setCurrentString(this.search.resultDisplay(content));
        } else {
            this.textFieldWidget.setCurrentString("");
        }
        return this;
    }

    public void setShow(boolean isShow) {
        this.isShow = isShow;
        this.popUp.setVisible(isShow);
        this.popUp.setActive(isShow);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean lastVisible = this.popUp.isVisible();
        this.popUp.setVisible(false);
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        this.popUp.setVisible(lastVisible);
        if (this.isShow) {
            graphics.pose().translate(0.0f, 0.0f, 200.0f);
            this.popUp.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            this.popUp.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            graphics.pose().translate(0.0f, 0.0f, -200.0f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean lastVisible = this.popUp.isVisible();
        this.popUp.setVisible(false);
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        this.popUp.setVisible(lastVisible);
    }

    public void setShowUp(boolean showUp) {
        this.showUp = showUp;
    }

    @Nullable
    public T getCurrent() {
        return this.current;
    }

    public static interface IWidgetSearch<T>
    extends ISearch<T> {
        public String resultDisplay(T var1);

        public void selectResult(T var1);

        default public void serialize(T value, FriendlyByteBuf buf) {
            buf.writeUtf(this.resultDisplay(value));
        }

        default public T deserialize(FriendlyByteBuf buf) {
            return (T)buf.readUtf();
        }
    }
}

