/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="selector", group="widget.basic")
public class SelectorWidget
extends WidgetGroup {
    protected List<SelectableWidgetGroup> selectables;
    @Configurable(name="ldlib.gui.editor.name.candidates")
    protected List<String> candidates;
    @Configurable(name="ldlib.gui.editor.name.currentValue")
    protected String currentValue;
    @Configurable(name="ldlib.gui.editor.name.maxCount")
    @NumberRange(range={1.0, 20.0})
    protected int maxCount = 5;
    @Configurable(name="ldlib.gui.editor.name.color")
    @NumberColor
    protected int fontColor = -1;
    @Configurable(name="ldlib.gui.editor.name.showUp")
    protected boolean showUp;
    protected boolean isShow;
    protected IGuiTexture popUpTexture = new ColorRectTexture(-1442840576);
    private Supplier<List<String>> candidatesSupplier;
    private Supplier<String> supplier;
    private Consumer<String> onChanged;
    public final TextTexture textTexture;
    protected final DraggableScrollableWidgetGroup popUp;
    protected final ButtonWidget button;

    public SelectorWidget() {
        this(0, 0, 60, 15, List.of(), -1);
    }

    @Override
    public void initTemplate() {
        this.setCandidates(new ArrayList<String>(List.of("A", "B", "C", "D", "E", "F", "G")));
        this.setButtonBackground(ColorPattern.T_GRAY.rectTexture());
        this.setValue("D");
    }

    public SelectorWidget(int x, int y, int width, int height, List<String> candidates, int fontColor) {
        super(new Position(x, y), new Size(width, height));
        this.button = new ButtonWidget(0, 0, width, height, IGuiTexture.EMPTY, d -> {
            if (d.isRemote) {
                this.setShow(!this.isShow);
            }
        });
        this.candidates = candidates;
        this.selectables = new ArrayList<SelectableWidgetGroup>();
        this.addWidget(this.button);
        this.textTexture = new TextTexture("", fontColor).setWidth(width).setType(TextTexture.TextType.ROLL);
        this.addWidget(new ImageWidget(0, 1, width, height - 1, this.textTexture));
        this.popUp = new DraggableScrollableWidgetGroup(0, height, width, 15);
        this.addWidget(this.popUp);
        this.popUp.setBackground(this.popUpTexture);
        this.popUp.setVisible(false);
        this.popUp.setActive(false);
        this.currentValue = "";
        this.computeLayout();
    }

    protected void computeLayout() {
        int height = Math.min(this.maxCount, this.candidates.size()) * 15;
        this.popUp.clearAllWidgets();
        this.selectables.clear();
        this.popUp.setSize(new Size(this.getSize().width, height));
        this.popUp.setSelfPosition(this.showUp ? new Position(0, -height) : new Position(0, this.getSize().height));
        if (this.candidates.size() > this.maxCount) {
            this.popUp.setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        }
        int y = 0;
        int width = this.candidates.size() > this.maxCount ? this.getSize().width - 4 : this.getSize().width;
        for (String candidate : this.candidates) {
            SelectableWidgetGroup select = new SelectableWidgetGroup(0, y, width, 15);
            select.addWidget(new ImageWidget(0, 0, width, 15, new TextTexture(candidate, this.fontColor).setWidth(width).setType(TextTexture.TextType.ROLL)));
            select.setSelectedTexture(-1, -1);
            select.setOnSelected(s -> {
                this.setValue(candidate);
                if (this.onChanged != null) {
                    this.onChanged.accept(candidate);
                }
                this.writeClientAction(2, buffer -> buffer.writeUtf(candidate));
                this.setShow(false);
            });
            this.popUp.addWidget(select);
            this.selectables.add(select);
            y += 15;
        }
        this.popUp.setScrollYOffset(0);
    }

    @ConfigSetter(field="maxCount")
    public SelectorWidget setMaxCount(int maxCount) {
        this.maxCount = maxCount;
        this.computeLayout();
        return this;
    }

    @ConfigSetter(field="showUp")
    public SelectorWidget setIsUp(boolean isUp) {
        this.showUp = isUp;
        this.computeLayout();
        return this;
    }

    @ConfigSetter(field="fontColor")
    public SelectorWidget setFontColor(int fontColor) {
        this.fontColor = fontColor;
        this.computeLayout();
        return this;
    }

    @ConfigSetter(field="currentValue")
    public SelectorWidget setValue(String value) {
        if (!value.equals(this.currentValue)) {
            this.currentValue = value;
            int index = this.candidates.indexOf(value);
            this.textTexture.updateText(value);
            for (int i = 0; i < this.selectables.size(); ++i) {
                this.selectables.get((int)i).isSelected = index == i;
            }
        }
        return this;
    }

    @ConfigSetter(field="candidates")
    public void setCandidates(List<String> candidates) {
        this.candidates = candidates;
        this.computeLayout();
    }

    public SelectorWidget setButtonBackground(IGuiTexture ... guiTexture) {
        super.setBackground(guiTexture);
        return this;
    }

    @ConfigSetter(field="popUpTexture")
    public SelectorWidget setBackground(IGuiTexture background) {
        this.popUpTexture = background;
        this.popUp.setBackground(background);
        return this;
    }

    @Override
    public void setSize(Size size) {
        super.setSize(size);
        this.button.setSize(size);
        this.computeLayout();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setShow(boolean isShow) {
        if (isShow) {
            this.setFocus(true);
        }
        this.isShow = isShow;
        this.popUp.setVisible(isShow);
        this.popUp.setActive(isShow);
    }

    public String getValue() {
        return this.currentValue;
    }

    public SelectorWidget setCandidatesSupplier(Supplier<List<String>> candidatesSupplier) {
        this.candidatesSupplier = candidatesSupplier;
        return this;
    }

    public SelectorWidget setOnChanged(Consumer<String> onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    public SelectorWidget setSupplier(Supplier<String> supplier) {
        this.supplier = supplier;
        return this;
    }

    @Override
    public boolean isMouseOverElement(double mouseX, double mouseY) {
        return super.isMouseOverElement(mouseX, mouseY) || this.isShow && this.popUp.isMouseOverElement(mouseX, mouseY);
    }

    @Override
    @Nullable
    public Widget getHoverElement(double mouseX, double mouseY) {
        return this.isMouseOverElement(mouseX, mouseY) ? this : null;
    }

    @Override
    public void onFocusChanged(@Nullable Widget lastFocus, Widget focus) {
        if (lastFocus != null && !lastFocus.isParent(this) && focus != this) {
            this.setShow(false);
        }
    }

    @Override
    public void updateScreen() {
        ModularUIGuiContainer container;
        super.updateScreen();
        if (this.isClientSideWidget) {
            List<String> latest;
            if (this.candidatesSupplier != null && !(latest = this.candidatesSupplier.get()).equals(this.candidates)) {
                this.setCandidates(latest);
            }
            if (this.supplier != null) {
                this.setValue(this.supplier.get());
            }
        }
        if (this.gui != null && (container = this.gui.getModularUIGui()) != null && container.lastFocus != null && container.lastFocus.isParent(this)) {
            this.setFocus(true);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (!this.isClientSideWidget) {
            List<String> latest;
            if (this.candidatesSupplier != null && !(latest = this.candidatesSupplier.get()).equals(this.candidates)) {
                this.setCandidates(latest);
                this.writeUpdateInfo(4, buffer -> {
                    buffer.writeVarInt(latest.size());
                    for (String candidate : latest) {
                        buffer.writeUtf(candidate);
                    }
                });
            }
            if (this.supplier != null) {
                String last = this.currentValue;
                this.setValue(this.supplier.get());
                if (!last.equals(this.currentValue)) {
                    this.writeUpdateInfo(3, buffer -> buffer.writeUtf(this.currentValue));
                }
            }
        }
    }

    @Override
    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        if (this.supplier != null) {
            this.setValue(this.supplier.get());
        }
        buffer.writeUtf(this.currentValue);
    }

    @Override
    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        this.setValue(buffer.readUtf());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean lastVisible = this.popUp.isVisible();
        this.popUp.setVisible(false);
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        this.popUp.setVisible(lastVisible);
        if (this.isShow) {
            graphics.pose().translate(0.0f, 0.0f, 200.0f);
            this.popUp.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            this.popUp.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            graphics.pose().translate(0.0f, 0.0f, -200.0f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean lastVisible = this.popUp.isVisible();
        this.popUp.setVisible(false);
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        this.popUp.setVisible(lastVisible);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!super.mouseClicked(mouseX, mouseY, button)) {
            this.setFocus(false);
            return false;
        }
        return true;
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        super.handleClientAction(id, buffer);
        if (id == 2) {
            this.setValue(buffer.readUtf());
            if (this.onChanged != null) {
                this.onChanged.accept(this.getValue());
            }
        }
    }

    @Override
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 3) {
            this.setValue(buffer.readUtf());
        } else if (id == 4) {
            int size = buffer.readVarInt();
            ArrayList<String> latest = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                latest.add(buffer.readUtf());
            }
            this.setCandidates(latest);
        }
    }

    @Override
    public void addWidgetsConfigurator(ConfiguratorGroup father) {
    }

    @Override
    public boolean canWidgetAccepted(IConfigurableWidget widget) {
        return false;
    }
}

