/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.core.mixins.accessor.SlotAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TagOrCycleItemStackTransfer;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@LDLRegister(name="item_slot", group="widget.container")
public class SlotWidget
extends Widget
implements IRecipeIngredientSlot,
IConfigurableWidget {
    public static final ResourceBorderTexture ITEM_SLOT_TEXTURE = new ResourceBorderTexture("ldlib:textures/gui/slot.png", 18, 18, 1, 1);
    @Nullable
    protected static Slot HOVER_SLOT = null;
    @Nullable
    protected Slot slotReference;
    @Configurable(name="ldlib.gui.editor.name.canTakeItems")
    protected boolean canTakeItems;
    @Configurable(name="ldlib.gui.editor.name.canPutItems")
    protected boolean canPutItems;
    public boolean isPlayerContainer;
    public boolean isPlayerHotBar;
    @Configurable(name="ldlib.gui.editor.name.drawHoverOverlay")
    public boolean drawHoverOverlay = true;
    @Configurable(name="ldlib.gui.editor.name.drawHoverTips")
    public boolean drawHoverTips = true;
    protected Runnable changeListener;
    protected BiConsumer<SlotWidget, List<Component>> onAddedTooltips;
    protected Function<ItemStack, ItemStack> itemHook;
    protected IngredientIO ingredientIO = IngredientIO.RENDER_ONLY;
    protected float XEIChance = 1.0f;
    private ItemStack lastItem = ItemStack.EMPTY;

    public SlotWidget() {
        super(new Position(0, 0), new Size(18, 18));
    }

    @Override
    public void initTemplate() {
        this.setBackgroundTexture(ITEM_SLOT_TEXTURE);
        this.canTakeItems = true;
        this.canPutItems = true;
    }

    public SlotWidget(Container inventory, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.setBackgroundTexture(ITEM_SLOT_TEXTURE);
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.setContainerSlot(inventory, slotIndex);
    }

    public SlotWidget(IItemTransfer itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.setBackgroundTexture(ITEM_SLOT_TEXTURE);
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.setHandlerSlot(itemHandler, slotIndex);
    }

    protected Slot createSlot(Container inventory, int index) {
        return new WidgetSlot(inventory, index, 0, 0);
    }

    protected Slot createSlot(IItemTransfer itemHandler, int index) {
        return new WidgetSlotItemTransfer(itemHandler, index, 0, 0);
    }

    public SlotWidget setContainerSlot(Container inventory, int slotIndex) {
        this.updateSlot(this.createSlot(inventory, slotIndex));
        return this;
    }

    public SlotWidget setHandlerSlot(IItemTransfer itemHandler, int slotIndex) {
        this.updateSlot(this.createSlot(itemHandler, slotIndex));
        return this;
    }

    protected void updateSlot(Slot slot) {
        if (this.slotReference != null && this.gui != null && !this.isClientSideWidget) {
            this.getGui().removeNativeSlot(this.slotReference);
        }
        this.slotReference = slot;
        if (this.gui != null && !this.isClientSideWidget) {
            this.getGui().addNativeSlot(this.slotReference, this);
        }
    }

    public ItemStack getItem() {
        return this.slotReference == null ? ItemStack.EMPTY : this.slotReference.getItem();
    }

    public void setItem(ItemStack stack) {
        if (this.slotReference != null) {
            this.slotReference.set(stack);
        }
    }

    public void setItem(ItemStack stack, boolean notify) {
        if (this.slotReference != null) {
            Runnable lastListener = this.changeListener;
            if (!notify) {
                this.changeListener = null;
            }
            this.slotReference.set(stack);
            this.changeListener = lastListener;
        }
    }

    @Override
    public final void setSize(Size size) {
    }

    @Override
    public void setGui(ModularUI gui) {
        if (!this.isClientSideWidget && this.gui != gui) {
            if (this.gui != null && this.slotReference != null) {
                this.gui.removeNativeSlot(this.slotReference);
            }
            if (gui != null && this.slotReference != null) {
                gui.addNativeSlot(this.slotReference, this);
            }
        }
        super.setGui(gui);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        this.lastItem = this.getItem();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        this.lastItem = this.getItem();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.slotReference != null && this.drawHoverTips && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            ItemStack stack = this.slotReference.getItem();
            if (this.gui != null) {
                this.gui.getModularUIGui().setHoveredSlot(this.slotReference);
            }
            if (!stack.isEmpty() && this.gui != null) {
                this.gui.getModularUIGui().setHoverTooltip(this.getFullTooltipTexts(), stack, null, stack.getTooltipImage().orElse(null));
            } else {
                super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            }
        } else {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position pos = this.getPosition();
        if (this.slotReference != null) {
            ModularUIGuiContainer modularUIGui;
            ItemStack itemStack = this.getRealStack(this.slotReference.getItem());
            ModularUIGuiContainer modularUIGuiContainer = modularUIGui = this.gui == null ? null : this.gui.getModularUIGui();
            if (itemStack.isEmpty() && modularUIGui != null && modularUIGui.getQuickCrafting() && modularUIGui.getQuickCraftSlots().contains(this.slotReference)) {
                int splitSize = modularUIGui.getQuickCraftSlots().size();
                itemStack = this.gui.getModularUIContainer().getCarried();
                if (!itemStack.isEmpty() && splitSize > 1 && AbstractContainerMenu.canItemQuickReplace((Slot)this.slotReference, (ItemStack)itemStack, (boolean)true)) {
                    itemStack = itemStack.copy();
                    itemStack.grow(AbstractContainerMenu.getQuickCraftPlaceCount(modularUIGui.getQuickCraftSlots(), (int)modularUIGui.dragSplittingLimit, (ItemStack)itemStack));
                    int k = Math.min(itemStack.getMaxStackSize(), this.slotReference.getMaxStackSize(itemStack));
                    if (itemStack.getCount() > k) {
                        itemStack.setCount(k);
                    }
                }
            }
            if (!itemStack.isEmpty()) {
                DrawerHelper.drawItemStack(graphics, itemStack, pos.x + 1, pos.y + 1, -1, null);
            }
        }
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        if (this.drawHoverOverlay && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect(graphics, this.getPosition().x + 1, this.getPosition().y + 1, 16, 16, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.slotReference != null && this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            ItemStack stack = this.slotReference.getItem();
            if (this.canPutItems && stack.isEmpty() || this.canTakeItems && !stack.isEmpty()) {
                ModularUIGuiContainer modularUIGui = this.gui.getModularUIGui();
                boolean last = modularUIGui.getQuickCrafting();
                InputConstants.Key mouseKey = InputConstants.Type.MOUSE.getOrCreate(button);
                HOVER_SLOT = this.slotReference;
                this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
                HOVER_SLOT = null;
                if (last != modularUIGui.getQuickCrafting()) {
                    modularUIGui.dragSplittingButton = button;
                    if (button == 0) {
                        modularUIGui.dragSplittingLimit = 0;
                    } else if (button == 1) {
                        modularUIGui.dragSplittingLimit = 1;
                    } else if (Minecraft.getInstance().options.keyPickItem.matchesMouse(mouseKey.getValue())) {
                        modularUIGui.dragSplittingLimit = 2;
                    }
                }
                return true;
            }
            if (LDLib.isEmiLoaded()) {
                Object object = this.getXEICurrentIngredient();
                if (object instanceof EmiStack) {
                    EmiStack emiStack = (EmiStack)object;
                    EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)emiStack), bind -> bind.matchesMouse(button));
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Object object;
        double mouseY;
        Window window = Minecraft.getInstance().getWindow();
        double mouseX = Minecraft.getInstance().mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        if (this.isMouseOverElement(mouseX, mouseY = Minecraft.getInstance().mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight()) && LDLib.isEmiLoaded() && (object = this.getXEICurrentIngredient()) instanceof EmiStack) {
            EmiStack emiStack = (EmiStack)object;
            EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)emiStack), bind -> bind.matchesKey(keyCode, scanCode));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            HOVER_SLOT = this.slotReference;
            this.gui.getModularUIGui().superMouseReleased(mouseX, mouseY, button);
            HOVER_SLOT = null;
            return this.getIngredientIO() == IngredientIO.RENDER_ONLY && (this.canPutItems || this.canTakeItems);
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            this.gui.getModularUIGui().superMouseDragged(mouseX, mouseY, button, dragX, dragY);
            return true;
        }
        return false;
    }

    @Override
    protected void onPositionUpdate() {
        if (this.gui != null) {
            Position position = this.getPosition();
            if (this.slotReference != null) {
                ((SlotAccessor)this.slotReference).setX(position.x + 1 - this.gui.getGuiLeft());
                ((SlotAccessor)this.slotReference).setY(position.y + 1 - this.gui.getGuiTop());
            }
        }
    }

    public SlotWidget(IItemTransfer itemHandler, int slotIndex, int xPosition, int yPosition) {
        this(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget(Container inventory, int slotIndex, int xPosition, int yPosition) {
        this(inventory, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget setBackgroundTexture(IGuiTexture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public boolean canPutStack(ItemStack stack) {
        return this.isEnabled() && this.canPutItems;
    }

    public boolean canTakeStack(Player player) {
        return this.isEnabled() && this.canTakeItems;
    }

    public boolean isEnabled() {
        return this.isActive() && this.isVisible();
    }

    public boolean canMergeSlot(ItemStack stack) {
        return this.isEnabled();
    }

    public void onSlotChanged() {
        if (this.gui == null) {
            return;
        }
        this.gui.holder.markAsDirty();
    }

    public ItemStack slotClick(int dragType, ClickType clickTypeIn, Player player) {
        return null;
    }

    @Nullable
    public final Slot getHandler() {
        return this.slotReference;
    }

    public SlotWidget setLocationInfo(boolean isPlayerContainer, boolean isPlayerHotBar) {
        this.isPlayerHotBar = isPlayerHotBar;
        this.isPlayerContainer = isPlayerContainer;
        return this;
    }

    @Override
    public List<Component> getTooltipTexts() {
        List<Component> tooltips = this.getAdditionalToolTips(new ArrayList<Component>());
        tooltips.addAll(this.tooltipTexts);
        return tooltips;
    }

    public List<Component> getAdditionalToolTips(List<Component> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        return list;
    }

    @Override
    public List<Component> getFullTooltipTexts() {
        ItemStack stack;
        if (this.slotReference != null && !(stack = this.slotReference.getItem()).isEmpty()) {
            ArrayList<Component> tips = new ArrayList<Component>(DrawerHelper.getItemToolTip(stack));
            tips.addAll(this.getTooltipTexts());
            return tips;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        if (this.self().isMouseOverElement(mouseX, mouseY)) {
            Slot handler = this.getHandler();
            if (handler == null) {
                return null;
            }
            ItemStack realStack = this.getRealStack(handler.getItem());
            if (handler instanceof WidgetSlotItemTransfer) {
                WidgetSlotItemTransfer widgetSlotItemTransfer = (WidgetSlotItemTransfer)handler;
                IItemTransfer iItemTransfer = widgetSlotItemTransfer.itemHandler;
                if (iItemTransfer instanceof CycleItemStackHandler) {
                    CycleItemStackHandler cycleItemStackHandler = (CycleItemStackHandler)iItemTransfer;
                    return this.getXEIIngredientsFromCycleTransferClickable(cycleItemStackHandler, widgetSlotItemTransfer.index);
                }
                iItemTransfer = widgetSlotItemTransfer.itemHandler;
                if (iItemTransfer instanceof TagOrCycleItemStackTransfer) {
                    TagOrCycleItemStackTransfer transfer = (TagOrCycleItemStackTransfer)iItemTransfer;
                    return this.getXEIIngredientsFromTagOrCycleTransferClickable(transfer, widgetSlotItemTransfer.index);
                }
            }
            if (LDLib.isJeiLoaded() && !realStack.isEmpty()) {
                return JEIPlugin.getItemIngredient(realStack, this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height);
            }
            if (LDLib.isReiLoaded()) {
                return REICallWrapper.getReiIngredients(realStack);
            }
            if (LDLib.isEmiLoaded()) {
                return EMICallWrapper.getEmiIngredients(realStack, this.getXEIChance());
            }
            return realStack;
        }
        return null;
    }

    @Override
    public List<Object> getXEIIngredients() {
        if (this.slotReference == null || this.slotReference.getItem().isEmpty()) {
            return Collections.emptyList();
        }
        Slot handler = this.getHandler();
        if (handler == null) {
            return Collections.emptyList();
        }
        ItemStack realStack = this.getRealStack(handler.getItem());
        if (handler instanceof WidgetSlotItemTransfer) {
            WidgetSlotItemTransfer widgetSlotItemTransfer = (WidgetSlotItemTransfer)handler;
            IItemTransfer iItemTransfer = widgetSlotItemTransfer.itemHandler;
            if (iItemTransfer instanceof CycleItemStackHandler) {
                CycleItemStackHandler cycleItemStackHandler = (CycleItemStackHandler)iItemTransfer;
                return this.getXEIIngredientsFromCycleTransferClickable(cycleItemStackHandler, widgetSlotItemTransfer.index);
            }
            iItemTransfer = widgetSlotItemTransfer.itemHandler;
            if (iItemTransfer instanceof TagOrCycleItemStackTransfer) {
                TagOrCycleItemStackTransfer transfer = (TagOrCycleItemStackTransfer)iItemTransfer;
                return this.getXEIIngredientsFromTagOrCycleTransferClickable(transfer, widgetSlotItemTransfer.index);
            }
        }
        if (LDLib.isJeiLoaded()) {
            Object ingredient = JEIPlugin.getItemIngredient(realStack, this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height);
            return ingredient == null ? Collections.emptyList() : List.of(ingredient);
        }
        if (LDLib.isReiLoaded()) {
            return REICallWrapper.getReiIngredients(realStack);
        }
        if (LDLib.isEmiLoaded()) {
            return EMICallWrapper.getEmiIngredients(realStack, this.getXEIChance());
        }
        return List.of(realStack);
    }

    public ItemStack getRealStack(ItemStack itemStack) {
        if (this.itemHook != null) {
            return this.itemHook.apply(itemStack);
        }
        return itemStack;
    }

    @Override
    public Object getXEICurrentIngredient() {
        if (this.slotReference == null || this.slotReference.getItem().isEmpty()) {
            return null;
        }
        Slot handler = this.getHandler();
        if (handler == null) {
            return null;
        }
        ItemStack realStack = this.getRealStack(handler.getItem());
        if (LDLib.isJeiLoaded()) {
            return JEIPlugin.getItemIngredient(realStack, this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height);
        }
        if (LDLib.isEmiLoaded()) {
            return EmiStack.of((ItemStack)realStack).setChance(this.getXEIChance());
        }
        return null;
    }

    private List<Object> getXEIIngredientsFromCycleTransfer(CycleItemStackHandler transfer, int index) {
        Stream<ItemStack> stream = transfer.getStackList(index).stream().map(this::getRealStack);
        if (LDLib.isJeiLoaded()) {
            return stream.filter(stack -> !stack.isEmpty()).collect(Collectors.toList());
        }
        if (LDLib.isReiLoaded()) {
            return REICallWrapper.getReiIngredients(stream);
        }
        if (LDLib.isEmiLoaded()) {
            return EMICallWrapper.getEmiIngredients(stream, this.getXEIChance());
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsFromCycleTransferClickable(CycleItemStackHandler transfer, int index) {
        Stream<ItemStack> stream = transfer.getStackList(index).stream().map(this::getRealStack);
        if (LDLib.isJeiLoaded()) {
            return stream.filter(stack -> !stack.isEmpty()).map(item -> JEIPlugin.getItemIngredient(item, this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height)).toList();
        }
        if (LDLib.isReiLoaded()) {
            return REICallWrapper.getReiIngredients(stream);
        }
        if (LDLib.isEmiLoaded()) {
            return EMICallWrapper.getEmiIngredients(stream, this.getXEIChance());
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsFromTagOrCycleTransfer(TagOrCycleItemStackTransfer transfer, int index) {
        Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>> either = transfer.getStacks().get(index);
        var ref = new Object(){
            List<Object> returnValue = Collections.emptyList();
        };
        either.ifLeft(list -> {
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = list.stream().flatMap(pair -> BuiltInRegistries.ITEM.getTag((TagKey)pair.getFirst()).stream().flatMap(HolderSet.ListBacked::stream).map(item -> this.getRealStack(new ItemStack((ItemLike)item.value(), ((Integer)pair.getSecond()).intValue())))).collect(Collectors.toList());
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = REICallWrapper.getReiIngredients(this::getRealStack, list);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = EMICallWrapper.getEmiIngredients(list, this.getXEIChance());
            }
        }).ifRight(items -> {
            Stream<ItemStack> stream = items.stream().map(this::getRealStack);
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = stream.filter(stack -> !stack.isEmpty()).collect(Collectors.toList());
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = REICallWrapper.getReiIngredients(stream);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = EMICallWrapper.getEmiIngredients(stream, this.getXEIChance());
            }
        });
        return ref.returnValue;
    }

    private List<Object> getXEIIngredientsFromTagOrCycleTransferClickable(TagOrCycleItemStackTransfer transfer, int index) {
        Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>> either = transfer.getStacks().get(index);
        var ref = new Object(){
            List<Object> returnValue = Collections.emptyList();
        };
        either.ifLeft(list -> {
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = list.stream().flatMap(pair -> BuiltInRegistries.ITEM.getTag((TagKey)pair.getFirst()).stream().flatMap(HolderSet.ListBacked::stream).map(item -> JEIPlugin.getItemIngredient(this.getRealStack(new ItemStack((ItemLike)item.value(), ((Integer)pair.getSecond()).intValue())), this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height))).collect(Collectors.toList());
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = REICallWrapper.getReiIngredients(this::getRealStack, list);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = EMICallWrapper.getEmiIngredients(list, this.getXEIChance());
            }
        }).ifRight(items -> {
            Stream<ItemStack> stream = items.stream().map(this::getRealStack);
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = stream.filter(stack -> !stack.isEmpty()).map(item -> JEIPlugin.getItemIngredient(item, this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height)).toList();
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = REICallWrapper.getReiIngredients(stream);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = EMICallWrapper.getEmiIngredients(stream, this.getXEIChance());
            }
        });
        return ref.returnValue;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        ItemStackTransfer handler = new ItemStackTransfer();
        handler.setStackInSlot(0, Blocks.STONE.asItem().getDefaultInstance());
        father.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", new SlotWidget(){

            @Override
            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(SlotWidget.this.tooltipTexts);
                this.backgroundTexture = SlotWidget.this.backgroundTexture;
                this.hoverTexture = SlotWidget.this.hoverTexture;
                this.drawHoverOverlay = SlotWidget.this.drawHoverOverlay;
                this.drawHoverTips = SlotWidget.this.drawHoverTips;
                this.overlay = SlotWidget.this.overlay;
            }
        }.setCanPutItems(false).setCanTakeItems(false).setHandlerSlot(handler, 0)));
        IConfigurableWidget.super.buildConfigurator(father);
    }

    public SlotWidget setCanTakeItems(boolean canTakeItems) {
        this.canTakeItems = canTakeItems;
        return this;
    }

    public SlotWidget setCanPutItems(boolean canPutItems) {
        this.canPutItems = canPutItems;
        return this;
    }

    public SlotWidget setDrawHoverOverlay(boolean drawHoverOverlay) {
        this.drawHoverOverlay = drawHoverOverlay;
        return this;
    }

    public SlotWidget setDrawHoverTips(boolean drawHoverTips) {
        this.drawHoverTips = drawHoverTips;
        return this;
    }

    public SlotWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SlotWidget setOnAddedTooltips(BiConsumer<SlotWidget, List<Component>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    public SlotWidget setItemHook(Function<ItemStack, ItemStack> itemHook) {
        this.itemHook = itemHook;
        return this;
    }

    public SlotWidget setIngredientIO(IngredientIO ingredientIO) {
        this.ingredientIO = ingredientIO;
        return this;
    }

    @Override
    public IngredientIO getIngredientIO() {
        return this.ingredientIO;
    }

    public SlotWidget setXEIChance(float XEIChance) {
        this.XEIChance = XEIChance;
        return this;
    }

    @Override
    public float getXEIChance() {
        return this.XEIChance;
    }

    public ItemStack getLastItem() {
        return this.lastItem;
    }

    protected class WidgetSlot
    extends Slot {
        public WidgetSlot(Container inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && super.mayPlace(stack);
        }

        public boolean mayPickup(@Nonnull Player playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.mayPickup(playerIn);
        }

        public void set(@Nonnull ItemStack stack) {
            super.set(stack);
        }

        public void setChanged() {
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
            SlotWidget.this.onSlotChanged();
        }

        public boolean isActive() {
            return SlotWidget.this.isEnabled() && (HOVER_SLOT == null || HOVER_SLOT == this);
        }
    }

    public class WidgetSlotItemTransfer
    extends Slot {
        private static final Container emptyInventory = new SimpleContainer(0);
        private final IItemTransfer itemHandler;
        private final int index;

        public WidgetSlotItemTransfer(IItemTransfer itemHandler, int index, int xPosition, int yPosition) {
            super(emptyInventory, index, xPosition, yPosition);
            this.itemHandler = itemHandler;
            this.index = index;
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && !stack.isEmpty() && this.itemHandler.isItemValid(this.index, stack);
        }

        public boolean mayPickup(@Nullable Player playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && !this.itemHandler.extractItem(this.index, 1, true).isEmpty();
        }

        @Nonnull
        public ItemStack getItem() {
            return this.itemHandler.getStackInSlot(this.index);
        }

        public void set(@Nonnull ItemStack stack) {
            this.itemHandler.setStackInSlot(this.index, stack);
            this.setChanged();
        }

        public void onQuickCraft(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
        }

        public int getMaxStackSize() {
            return this.itemHandler.getSlotLimit(this.index);
        }

        public int getMaxStackSize(@Nonnull ItemStack stack) {
            ItemStack maxAdd = stack.copy();
            int maxInput = stack.getMaxStackSize();
            maxAdd.setCount(maxInput);
            ItemStack currentStack = this.itemHandler.getStackInSlot(this.index);
            this.itemHandler.setStackInSlot(this.index, ItemStack.EMPTY);
            ItemStack remainder = this.itemHandler.insertItem(this.index, maxAdd, true);
            this.itemHandler.setStackInSlot(this.index, currentStack);
            return maxInput - remainder.getCount();
        }

        @NotNull
        public ItemStack remove(int amount) {
            ItemStack result = this.itemHandler.extractItem(this.index, amount, false);
            if (SlotWidget.this.changeListener != null && !this.getItem().isEmpty()) {
                SlotWidget.this.changeListener.run();
            }
            return result;
        }

        public void setChanged() {
            this.itemHandler.onContentsChanged();
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
            SlotWidget.this.onSlotChanged();
        }

        public boolean isActive() {
            return SlotWidget.this.isEnabled() && (HOVER_SLOT == null || HOVER_SLOT == this);
        }

        public IItemTransfer getItemHandler() {
            return this.itemHandler;
        }
    }

    public static final class REICallWrapper {
        public static List<Object> getReiIngredients(Stream<ItemStack> stream) {
            return List.of(EntryIngredient.of(stream.map(EntryStacks::of).toList()));
        }

        public static List<Object> getReiIngredients(UnaryOperator<ItemStack> realStack, List<Pair<TagKey<Item>, Integer>> list) {
            return list.stream().map(pair -> EntryIngredients.ofTag((TagKey)((TagKey)pair.getFirst()), holder -> EntryStacks.of((ItemStack)((ItemStack)realStack.apply(new ItemStack((ItemLike)holder.value(), ((Integer)pair.getSecond()).intValue())))))).collect(Collectors.toList());
        }

        public static List<Object> getReiIngredients(ItemStack stack) {
            return List.of(EntryStacks.of((ItemStack)stack));
        }
    }

    public static final class EMICallWrapper {
        public static List<Object> getEmiIngredients(Stream<ItemStack> stream, float xeiChance) {
            return List.of(EmiIngredient.of(stream.map(EmiStack::of).toList()).setChance(xeiChance));
        }

        public static List<Object> getEmiIngredients(List<Pair<TagKey<Item>, Integer>> list, float xeiChance) {
            return list.stream().map(pair -> EmiIngredient.of((TagKey)((TagKey)pair.getFirst())).setAmount((long)((Integer)pair.getSecond()).intValue()).setChance(xeiChance)).collect(Collectors.toList());
        }

        public static List<Object> getEmiIngredients(ItemStack stack, float xeiChance) {
            return List.of(EmiStack.of((ItemStack)stack).setChance(xeiChance));
        }
    }
}

