/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.WidgetTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

@LDLRegister(name="tab_group", group="widget.group")
public class TabContainer
extends WidgetGroup {
    public static final ResourceTexture TABS_LEFT = new ResourceTexture("ldlib:textures/gui/tabs_left.png");
    public final BiMap<TabButton, WidgetGroup> tabs = HashBiMap.create();
    public final WidgetGroup buttonGroup = new WidgetGroup(0, 0, 0, 0);
    public final WidgetGroup containerGroup = new WidgetGroup(0, 0, 0, 0);
    public WidgetGroup focus;
    public BiConsumer<WidgetGroup, WidgetGroup> onChanged;

    public TabContainer() {
        this(0, 0, 40, 60);
    }

    @Override
    public void initTemplate() {
        this.setBackground(ResourceBorderTexture.BORDERED_BACKGROUND);
        this.addTab(new TabButton(-28, 0, 32, 28).setTexture(new GuiTextureGroup(TABS_LEFT.getSubTexture(0.0f, 0.0f, 0.5f, 0.33333334f), new TextTexture("A")), new GuiTextureGroup(TABS_LEFT.getSubTexture(0.5f, 0.0f, 0.5f, 0.33333334f), new TextTexture("A"))), new WidgetGroup(0, 0, 0, 0));
        this.addTab(new TabButton(-28, 28, 32, 28).setTexture(new GuiTextureGroup(TABS_LEFT.getSubTexture(0.0f, 0.33333334f, 0.5f, 0.33333334f), new TextTexture("B")), new GuiTextureGroup(TABS_LEFT.getSubTexture(0.5f, 0.33333334f, 0.5f, 0.33333334f), new TextTexture("B"))), new WidgetGroup(0, 0, 0, 0));
    }

    public TabContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.addWidget(this.containerGroup);
        this.addWidget(this.buttonGroup);
    }

    public TabContainer setOnChanged(BiConsumer<WidgetGroup, WidgetGroup> onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    public void switchTag(WidgetGroup tabWidget) {
        if (this.focus == tabWidget) {
            return;
        }
        if (this.focus != null) {
            ((TabButton)this.tabs.inverse().get((Object)this.focus)).setPressed(false);
            this.focus.setVisible(false);
            this.focus.setActive(false);
        }
        if (this.onChanged != null) {
            this.onChanged.accept(this.focus, tabWidget);
        }
        this.focus = tabWidget;
        Optional.ofNullable((TabButton)this.tabs.inverse().get((Object)tabWidget)).ifPresent(tab -> {
            tab.setPressed(true);
            tabWidget.setActive(true);
            tabWidget.setVisible(true);
        });
    }

    public void addTab(TabButton tabButton, WidgetGroup tabWidget) {
        tabButton.setContainer(this);
        this.tabs.put((Object)tabButton, (Object)tabWidget);
        this.containerGroup.addWidget(tabWidget);
        this.buttonGroup.addWidget(tabButton);
        if (this.focus == null) {
            this.focus = tabWidget;
        }
        tabButton.setPressed(this.focus == tabWidget);
        tabWidget.setVisible(this.focus == tabWidget);
        tabWidget.setActive(this.focus == tabWidget);
    }

    public void removeTab(TabButton tabButton) {
        if (this.tabs.containsKey((Object)tabButton)) {
            this.buttonGroup.removeWidget(tabButton);
            this.containerGroup.removeWidget((Widget)this.tabs.remove((Object)tabButton));
        }
    }

    @Override
    public void clearAllWidgets() {
        this.tabs.clear();
        this.buttonGroup.clearAllWidgets();
        this.containerGroup.clearAllWidgets();
        this.focus = null;
    }

    @Override
    @Nullable
    public Widget getHoverElement(double mouseX, double mouseY) {
        WidgetGroup group;
        Widget hovered = super.getHoverElement(mouseX, mouseY);
        if (hovered instanceof WidgetGroup && this.tabs.containsValue((Object)(group = (WidgetGroup)hovered))) {
            return this;
        }
        return hovered;
    }

    @Override
    public void acceptWidget(IConfigurableWidget widget) {
        if (this.focus != null) {
            this.focus.addWidget(widget.widget());
        }
    }

    @Override
    protected void addWidgetsConfigurator(ConfiguratorGroup father) {
        ArrayConfiguratorGroup<TabButton> tabsGroup = new ArrayConfiguratorGroup<TabButton>("tabs", false, () -> new ArrayList(this.tabs.keySet()), (getter, setter) -> {
            TabButton tab = (TabButton)getter.get();
            return new WrapperConfigurator(tab.id, new ImageWidget(0, 0, 50, 50, new WidgetTexture(tab)));
        }, true);
        tabsGroup.setAddDefault(() -> new TabButton(0, 0, 32, 28).setTexture(new GuiTextureGroup(TABS_LEFT.getSubTexture(0.0f, 0.33333334f, 0.5f, 0.33333334f), new TextTexture("N")), new GuiTextureGroup(TABS_LEFT.getSubTexture(0.5f, 0.33333334f, 0.5f, 0.33333334f), new TextTexture("N"))));
        tabsGroup.setOnAdd(tab -> this.addTab((TabButton)tab, new WidgetGroup(0, 0, this.getSize().width, this.getSize().height)));
        tabsGroup.setOnRemove(tab -> {
            this.buttonGroup.removeWidget((Widget)tab);
            this.containerGroup.removeWidget((Widget)this.tabs.get(tab));
            if (this.focus == this.tabs.remove(tab)) {
                this.focus = null;
            }
        });
        ArrayConfiguratorGroup<Widget> childrenGroup = new ArrayConfiguratorGroup<Widget>("children", true, () -> this.focus == null ? new ArrayList() : this.focus.widgets, (getter, setter) -> {
            Widget child = (Widget)getter.get();
            return new WrapperConfigurator(child.id, new ImageWidget(0, 0, 50, 50, new WidgetTexture(child)));
        }, true);
        childrenGroup.setCanAdd(false);
        childrenGroup.setOnRemove(child -> {
            if (this.focus != null) {
                this.focus.removeWidget((Widget)child);
            }
        });
        childrenGroup.setOnReorder((index, widget) -> {
            if (this.focus != null) {
                this.focus.removeWidget((Widget)widget);
                this.focus.addWidget((int)index, (Widget)widget);
            }
        });
        father.addConfigurators(tabsGroup, childrenGroup);
    }

    @Override
    public CompoundTag serializeInnerNBT() {
        CompoundTag tag = new CompoundTag();
        PersistedParser.serializeNBT(tag, this.getClass(), this);
        ListTag tabs = new ListTag();
        for (Map.Entry entry : this.tabs.entrySet()) {
            TabButton button = (TabButton)entry.getKey();
            WidgetGroup group = (WidgetGroup)entry.getValue();
            CompoundTag tab = new CompoundTag();
            tab.put("button", (Tag)button.serializeInnerNBT());
            tab.put("group", (Tag)group.serializeWrapper());
            tabs.add((Object)tab);
        }
        tag.put("tabs", (Tag)tabs);
        return tag;
    }

    @Override
    public void deserializeInnerNBT(CompoundTag nbt) {
        this.clearAllWidgets();
        PersistedParser.deserializeNBT(nbt, new HashMap<String, Method>(), this.getClass(), this);
        ListTag tabs = nbt.getList("tabs", 10);
        for (Tag tag : tabs) {
            Widget widget;
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag tab = (CompoundTag)tag;
            TabButton button = new TabButton();
            button.deserializeInnerNBT(tab.getCompound("button"));
            IConfigurableWidget widget2 = IConfigurableWidget.deserializeWrapper(tab.getCompound("group"));
            if (widget2 == null || !((widget = widget2.widget()) instanceof WidgetGroup)) continue;
            WidgetGroup group = (WidgetGroup)widget;
            this.addTab(button, group);
        }
    }
}

