/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TreeNode;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class TreeListWidget<K, T>
extends Widget {
    protected int scrollOffset;
    protected List<TreeNode<K, T>> list = new ArrayList<TreeNode<K, T>>();
    protected TreeNode<K, T> selected;
    @Nullable
    protected IGuiTexture nodeTexture;
    @Nullable
    protected IGuiTexture leafTexture;
    @Nullable
    protected Consumer<TreeNode<K, T>> onSelected;
    @Nullable
    protected Consumer<TreeNode<K, T>> onDoubleClickLeaf;
    @Nullable
    protected Function<K, IGuiTexture> keyIconSupplier;
    @Nullable
    protected Function<K, String> keyNameSupplier;
    @Nullable
    protected Function<T, IGuiTexture> contentIconSupplier;
    @Nullable
    protected Function<T, String> contentNameSupplier;
    protected int lineHeight = 11;
    protected boolean canSelectNode;
    protected long lastClickTime;

    public TreeListWidget(int xPosition, int yPosition, int width, int height, TreeNode<K, T> root, Consumer<TreeNode<K, T>> onSelected) {
        super(xPosition, yPosition, width, height);
        if (root.getChildren() != null) {
            this.list.addAll(root.getChildren());
        }
        this.onSelected = onSelected;
    }

    public TreeListWidget<K, T> canSelectNode(boolean canSelectNode) {
        this.canSelectNode = canSelectNode;
        return this;
    }

    public TreeListWidget<K, T> setBackground(IGuiTexture background) {
        super.setBackground(background);
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.nodeTexture != null) {
            this.nodeTexture.updateTick();
        }
        if (this.leafTexture != null) {
            this.leafTexture.updateTick();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            int moveDelta = (int)(-Mth.clamp((double)wheelDelta, (double)-1.0, (double)1.0) * 5.0);
            this.scrollOffset = Mth.clamp((int)(this.scrollOffset + moveDelta), (int)0, (int)Math.max(this.list.size() * this.lineHeight - this.getSize().height, 0));
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        Matrix4f trans = graphics.pose().last().pose();
        Vector4f realPos = trans.transform(new Vector4f((float)x, (float)y, 0.0f, 1.0f));
        Vector4f realPos2 = trans.transform(new Vector4f((float)(x + width), (float)(y + height), 0.0f, 1.0f));
        graphics.enableScissor((int)realPos.x, (int)realPos.y, (int)realPos2.x, (int)realPos2.y);
        int minToRender = this.scrollOffset / this.lineHeight;
        int maxToRender = Math.min(this.list.size(), height / this.lineHeight + 2 + minToRender);
        for (int i = minToRender; i < maxToRender; ++i) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TreeNode<K, T> node = this.list.get(i);
            int sX = x + this.lineHeight * node.dimension + 3;
            int sY = y - this.scrollOffset + i * this.lineHeight;
            String name = node.toString();
            if (node.isLeaf()) {
                if (this.leafTexture != null) {
                    this.leafTexture.draw(graphics, mouseX, mouseY, x, sY, width, this.lineHeight);
                }
                if (node.getContent() != null) {
                    String nameS = this.contentNameSupplier == null ? null : this.contentNameSupplier.apply(node.getContent());
                    name = nameS == null ? name : nameS;
                    IGuiTexture iGuiTexture = icon = this.contentIconSupplier == null ? null : this.contentIconSupplier.apply(node.getContent());
                    if (icon != null) {
                        icon.draw(graphics, mouseX, mouseY, sX - 2 - this.lineHeight, sY, this.lineHeight, this.lineHeight);
                    }
                }
            } else {
                if (this.nodeTexture != null) {
                    this.nodeTexture.draw(graphics, mouseX, mouseY, x, sY, width, this.lineHeight);
                }
                String nameS = this.keyNameSupplier == null ? null : this.keyNameSupplier.apply(node.getKey());
                name = nameS == null ? name : nameS;
                IGuiTexture iGuiTexture = icon = this.keyIconSupplier == null ? null : this.keyIconSupplier.apply(node.getKey());
                if (icon != null) {
                    icon.draw(graphics, mouseX, mouseY, sX - 2 - this.lineHeight, sY, this.lineHeight, this.lineHeight);
                }
            }
            if (node == this.selected) {
                DrawerHelper.drawSolidRect(graphics, x + 1, sY, width - 2, this.lineHeight, 0x7F000000);
            }
            int maxWidth = Math.max(width - this.lineHeight * node.dimension, this.lineHeight - 3);
            new TextTexture(name).setType(TextTexture.TextType.LEFT_HIDE).setWidth(maxWidth).draw(graphics, mouseX, mouseY, sX, sY, maxWidth, this.lineHeight);
        }
        graphics.disableScissor();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public TreeNode<K, T> jumpTo(List<K> path) {
        this.list.removeIf(node -> node.dimension != 1);
        this.selected = null;
        int dim = 1;
        int index = 0;
        boolean flag = false;
        TreeNode<K, T> node2 = null;
        for (K key : path) {
            flag = false;
            for (int i = index; i < this.list.size(); ++i) {
                node2 = this.list.get(i);
                if (node2.dimension != dim) {
                    return null;
                }
                if (node2.getKey().equals(key)) {
                    if (!node2.isLeaf() && path.size() > dim) {
                        for (int j = 0; j < node2.getChildren().size(); ++j) {
                            this.list.add(index + 1 + j, node2.getChildren().get(j));
                        }
                    }
                    ++index;
                    ++dim;
                    flag = true;
                    break;
                }
                ++index;
            }
            if (flag) continue;
            return null;
        }
        if (flag) {
            this.selected = node2;
            this.scrollOffset = Mth.clamp((int)(this.lineHeight * (index - 1)), (int)0, (int)Math.max(this.list.size() * this.lineHeight - this.getSize().height, 0));
            return this.selected;
        }
        return null;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            int index = (int)((mouseY - (double)this.getPosition().y + (double)this.scrollOffset) / (double)this.lineHeight);
            if (index < this.list.size()) {
                TreeNode<T, K> node = this.list.get(index);
                if (node.isLeaf()) {
                    if (node != this.selected) {
                        this.selected = node;
                        if (this.onSelected != null) {
                            this.onSelected.accept(node);
                        }
                        this.lastClickTime = System.currentTimeMillis();
                    } else if (this.onDoubleClickLeaf != null && System.currentTimeMillis() - this.lastClickTime < 500L) {
                        this.onDoubleClickLeaf.accept(node);
                    } else {
                        this.lastClickTime = System.currentTimeMillis();
                    }
                } else if (this.canSelectNode && this.selected != node) {
                    this.selected = node;
                    if (this.onSelected != null) {
                        this.onSelected.accept(node);
                    }
                } else if (node.getChildren().size() > 0 && this.list.contains(node.getChildren().get(0))) {
                    this.removeNode(node);
                } else {
                    for (int i = 0; i < node.getChildren().size(); ++i) {
                        this.list.add(index + 1 + i, node.getChildren().get(i));
                    }
                }
                TreeListWidget.playButtonClickSound();
            }
            return true;
        }
        return false;
    }

    private void removeNode(TreeNode<?, T> node) {
        if (node.isLeaf()) {
            return;
        }
        for (TreeNode<?, T> child : node.getChildren()) {
            this.list.remove(child);
            this.removeNode(child);
        }
    }

    public TreeListWidget<K, T> setNodeTexture(@Nullable IGuiTexture nodeTexture) {
        this.nodeTexture = nodeTexture;
        return this;
    }

    public TreeListWidget<K, T> setLeafTexture(@Nullable IGuiTexture leafTexture) {
        this.leafTexture = leafTexture;
        return this;
    }

    public TreeListWidget<K, T> setOnSelected(@Nullable Consumer<TreeNode<K, T>> onSelected) {
        this.onSelected = onSelected;
        return this;
    }

    public TreeListWidget<K, T> setOnDoubleClickLeaf(@Nullable Consumer<TreeNode<K, T>> onDoubleClickLeaf) {
        this.onDoubleClickLeaf = onDoubleClickLeaf;
        return this;
    }

    public TreeListWidget<K, T> setKeyIconSupplier(@Nullable Function<K, IGuiTexture> keyIconSupplier) {
        this.keyIconSupplier = keyIconSupplier;
        return this;
    }

    public TreeListWidget<K, T> setKeyNameSupplier(@Nullable Function<K, String> keyNameSupplier) {
        this.keyNameSupplier = keyNameSupplier;
        return this;
    }

    public TreeListWidget<K, T> setContentIconSupplier(@Nullable Function<T, IGuiTexture> contentIconSupplier) {
        this.contentIconSupplier = contentIconSupplier;
        return this;
    }

    public TreeListWidget<K, T> setContentNameSupplier(@Nullable Function<T, String> contentNameSupplier) {
        this.contentNameSupplier = contentNameSupplier;
        return this;
    }

    public TreeListWidget<K, T> setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }
}

