/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.IIngredientSlot;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.WidgetUIAccess;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.WidgetTexture;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@LDLRegister(name="group", group="widget.group")
public class WidgetGroup
extends Widget
implements IGhostIngredientTarget,
IIngredientSlot,
IConfigurableWidgetGroup {
    public final List<Widget> widgets = new ArrayList<Widget>();
    private final WidgetGroupUIAccess groupUIAccess = new WidgetGroupUIAccess();
    @Configurable(name="ldlib.gui.editor.name.isDynamicSized", tips={"ldlib.gui.editor.tips.isDynamicSized"})
    private boolean isDynamicSized;
    @Configurable(name="ldlib.gui.editor.name.layout", tips={"ldlib.gui.editor.tips.layout"})
    private Layout layout = Layout.NONE;
    @Configurable(name="ldlib.gui.editor.name.layoutPadding", tips={"ldlib.gui.editor.tips.layoutPadding"})
    private int layoutPadding = 0;
    @Configurable(name="ldlib.gui.editor.name.allowXEIIngredientOverMouse", tips={"ldlib.gui.editor.tips.allowXEIIngredientOverMouse"})
    private boolean allowXEIIngredientOverMouse = true;
    protected final List<Widget> waitToRemoved;
    protected final List<Widget> waitToAdded;

    public WidgetGroup() {
        this(0, 0, 50, 50);
    }

    @Override
    public void initTemplate() {
        this.setBackground(ResourceBorderTexture.BORDERED_BACKGROUND);
    }

    public WidgetGroup(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.isDynamicSized = false;
        this.waitToRemoved = new ArrayList<Widget>();
        this.waitToAdded = new ArrayList<Widget>();
    }

    public WidgetGroup(Position position) {
        super(position, Size.ZERO);
        this.isDynamicSized = true;
        this.waitToRemoved = new ArrayList<Widget>();
        this.waitToAdded = new ArrayList<Widget>();
    }

    public WidgetGroup(Position position, Size size) {
        super(position, size);
        this.isDynamicSized = false;
        this.waitToRemoved = new ArrayList<Widget>();
        this.waitToAdded = new ArrayList<Widget>();
    }

    @ConfigSetter(field="layout")
    public void setLayout(Layout layout) {
        if (layout == this.layout) {
            return;
        }
        this.layout = layout;
        this.recomputeLayout();
    }

    @ConfigSetter(field="layoutPadding")
    public void setLayoutPadding(int layoutPadding) {
        if (layoutPadding == this.layoutPadding) {
            return;
        }
        this.layoutPadding = layoutPadding;
        this.recomputeLayout();
    }

    @ConfigSetter(field="isDynamicSized")
    public void setDynamicSized(boolean dynamicSized) {
        if (dynamicSized == this.isDynamicSized) {
            return;
        }
        this.isDynamicSized = dynamicSized;
        this.recomputeSize();
    }

    @Override
    public void writeInitialData(FriendlyByteBuf buffer) {
        for (Widget widget : this.widgets) {
            if (!widget.isInitialized() || widget.isClientSideWidget) continue;
            widget.writeInitialData(buffer);
        }
    }

    @Override
    public void readInitialData(FriendlyByteBuf buffer) {
        for (Widget widget : this.widgets) {
            if (!widget.isInitialized() || widget.isClientSideWidget) continue;
            widget.readInitialData(buffer);
        }
    }

    @Override
    public WidgetGroup setClientSideWidget() {
        super.setClientSideWidget();
        for (Widget widget : this.widgets) {
            widget.setClientSideWidget();
        }
        return this;
    }

    public List<Widget> getContainedWidgets(boolean includeHidden) {
        ArrayList<Widget> containedWidgets = new ArrayList<Widget>(this.widgets.size());
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() && !includeHidden) continue;
            containedWidgets.add(widget);
            if (!(widget instanceof WidgetGroup)) continue;
            containedWidgets.addAll(((WidgetGroup)widget).getContainedWidgets(includeHidden));
        }
        return containedWidgets;
    }

    @Override
    protected void onPositionUpdate() {
        Position selfPosition = this.getPosition();
        for (Widget widget : this.widgets) {
            widget.setParentPosition(selfPosition);
        }
        this.recomputeSize();
    }

    @Override
    public boolean isMouseOverElement(double mouseX, double mouseY) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isMouseOverElement(mouseX, mouseY)) continue;
            return true;
        }
        return super.isMouseOverElement(mouseX, mouseY);
    }

    @Override
    @Nullable
    public Widget getHoverElement(double mouseX, double mouseY) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || (widget = widget.getHoverElement(mouseX, mouseY)) == null) continue;
            return widget;
        }
        return super.getHoverElement(mouseX, mouseY);
    }

    protected void onChildSelfPositionUpdate(Widget child) {
        this.recomputeLayout();
        this.recomputeSize();
    }

    protected void onChildSizeUpdate(Widget child) {
        this.recomputeLayout();
        this.recomputeSize();
    }

    @Nullable
    @HideFromJS
    public Widget getFirstWidgetById(Pattern regex) {
        ArrayList<Widget> list = new ArrayList<Widget>();
        this.getWidgetsById(list, regex);
        return list.isEmpty() ? null : (Widget)list.get(0);
    }

    @HideFromJS
    public List<Widget> getWidgetsById(Pattern regex) {
        ArrayList<Widget> list = new ArrayList<Widget>();
        this.getWidgetsById(list, regex);
        return list;
    }

    @Nullable
    public Widget getFirstWidgetById(String regex) {
        return this.getFirstWidgetById(Pattern.compile(regex));
    }

    public List<Widget> getWidgetsById(String regex) {
        return this.getWidgetsById(Pattern.compile(regex));
    }

    private void getWidgetsById(List<Widget> list, Pattern regex) {
        for (Widget widget : this.widgets) {
            if (regex.matcher(widget.id).find()) {
                list.add(widget);
            }
            if (!(widget instanceof WidgetGroup)) continue;
            WidgetGroup widgetGroup = (WidgetGroup)widget;
            widgetGroup.getWidgetsById(list, regex);
        }
    }

    public <T extends Widget> List<T> getWidgetsByType(Class<T> clazz) {
        ArrayList list = new ArrayList();
        this.getWidgetsByType(list, clazz);
        return list;
    }

    private <T extends Widget> void getWidgetsByType(List<T> list, Class<T> clazz) {
        for (Widget widget : this.widgets) {
            if (clazz.isAssignableFrom(widget.getClass())) {
                list.add(widget);
            }
            if (!(widget instanceof WidgetGroup)) continue;
            WidgetGroup group = (WidgetGroup)widget;
            group.getWidgetsByType(list, clazz);
        }
    }

    protected void recomputeLayout() {
        if (this.layout != Layout.NONE) {
            Position lastPosition = new Position(0, 0);
            switch (this.layout) {
                case VERTICAL_LEFT: {
                    for (Widget widget : this.widgets) {
                        lastPosition = lastPosition.addY(this.layoutPadding);
                        widget.setSelfPosition(lastPosition);
                        lastPosition = lastPosition.add(0, widget.getSizeHeight());
                    }
                    break;
                }
                case VERTICAL_CENTER: {
                    for (Widget widget : this.widgets) {
                        lastPosition = lastPosition.addY(this.layoutPadding);
                        widget.setSelfPosition(lastPosition.add((this.getSizeWidth() - widget.getSizeWidth()) / 2, 0));
                        lastPosition = lastPosition.add(0, widget.getSizeHeight());
                    }
                    break;
                }
                case VERTICAL_RIGHT: {
                    for (Widget widget : this.widgets) {
                        lastPosition = lastPosition.addY(this.layoutPadding);
                        widget.setSelfPosition(lastPosition.add(this.getSizeWidth() - widget.getSizeWidth(), 0));
                        lastPosition = lastPosition.add(0, widget.getSizeHeight());
                    }
                    break;
                }
                case HORIZONTAL_TOP: {
                    for (Widget widget : this.widgets) {
                        lastPosition = lastPosition.addX(this.layoutPadding);
                        widget.setSelfPosition(lastPosition);
                        lastPosition = lastPosition.add(widget.getSizeWidth(), 0);
                    }
                    break;
                }
                case HORIZONTAL_CENTER: {
                    for (Widget widget : this.widgets) {
                        lastPosition = lastPosition.addX(this.layoutPadding);
                        widget.setSelfPosition(lastPosition.add(0, (this.getSizeHeight() - widget.getSizeHeight()) / 2));
                        lastPosition = lastPosition.add(widget.getSizeWidth(), 0);
                    }
                    break;
                }
                case HORIZONTAL_BOTTOM: {
                    for (Widget widget : this.widgets) {
                        lastPosition = lastPosition.addX(this.layoutPadding);
                        widget.setSelfPosition(lastPosition.add(0, this.getSizeHeight() - widget.getSizeHeight()));
                        lastPosition = lastPosition.add(widget.getSizeWidth(), 0);
                    }
                    break;
                }
            }
        }
    }

    protected boolean recomputeSize() {
        Size dynamicSize;
        Size currentSize;
        if (this.isDynamicSized && !(currentSize = this.getSize()).equals(dynamicSize = this.computeDynamicSize())) {
            this.setSize(dynamicSize);
            return true;
        }
        return false;
    }

    protected Size computeDynamicSize() {
        Position selfPosition = this.getPosition();
        Size currentSize = Size.ZERO;
        for (Widget widget : this.widgets) {
            Position size = widget.getPosition().add(widget.getSize()).subtract(selfPosition);
            if (size.x > currentSize.width) {
                currentSize = new Size(size.x, currentSize.height);
            }
            if (size.y <= currentSize.height) continue;
            currentSize = new Size(currentSize.width, size.y);
        }
        return currentSize;
    }

    @Override
    public WidgetGroup setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return this;
        }
        super.setVisible(visible);
        return this;
    }

    @Override
    public void setGui(ModularUI gui) {
        super.setGui(gui);
        for (Widget widget : this.widgets) {
            if (widget.gui == gui) continue;
            widget.setGui(gui);
        }
    }

    public boolean isChild(Widget widget) {
        return widget.isParent(this);
    }

    public WidgetGroup addWidget(Widget widget) {
        return this.addWidget(this.widgets.size(), widget);
    }

    public WidgetGroup addWidgets(Widget ... widgets) {
        for (Widget widget : widgets) {
            this.addWidget(widget);
        }
        return this;
    }

    public <T extends Widget> WidgetGroup addWidget(T widget, Consumer<T> callback) {
        this.addWidget(this.widgets.size(), widget);
        callback.accept(widget);
        return this;
    }

    public WidgetGroup addWidget(int index, Widget widget) {
        if (widget == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        if (widget == null) {
            return this;
        }
        if (this.widgets.contains(widget)) {
            throw new IllegalArgumentException("Already added");
        }
        this.widgets.add(index, widget);
        if (this.isClientSideWidget) {
            widget.setClientSideWidget();
        }
        widget.setUiAccess(this.groupUIAccess);
        if (widget.gui != this.gui) {
            widget.setGui(this.gui);
        }
        widget.setParent(this);
        widget.setParentPosition(this.getPosition());
        if (this.isInitialized() && !widget.isInitialized()) {
            widget.initWidget();
            if (!this.isRemote() && !widget.isClientSideWidget) {
                this.writeUpdateInfo(2, buffer -> {
                    buffer.writeVarInt(index);
                    widget.writeInitialData((FriendlyByteBuf)buffer);
                });
            }
        }
        this.recomputeLayout();
        this.recomputeSize();
        return this;
    }

    public void addWidgetAnima(Widget widget, Transform animation) {
        this.addWidget(widget);
        widget.animation(animation.setIn());
    }

    public void removeWidgetAnima(Widget widget, Transform animation) {
        widget.animation(animation.setOut().appendOnFinish(() -> {
            widget.setVisible(false);
            this.waitToRemoved(widget);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToRemoved(Widget widget) {
        List<Widget> list = this.waitToRemoved;
        synchronized (list) {
            this.waitToRemoved.add(widget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToAdded(Widget widget) {
        List<Widget> list = this.waitToAdded;
        synchronized (list) {
            this.waitToAdded.add(widget);
        }
    }

    public int getAllWidgetSize() {
        return this.widgets.size() - this.waitToRemoved.size() + this.waitToAdded.size();
    }

    public void removeWidget(Widget widget) {
        if (!this.widgets.contains(widget)) {
            return;
        }
        this.widgets.remove(widget);
        widget.setUiAccess(null);
        widget.setGui(null);
        widget.setParentPosition(Position.ORIGIN);
        this.recomputeLayout();
        this.recomputeSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllWidgets() {
        List<Widget> list;
        this.widgets.forEach(it -> {
            it.setUiAccess(null);
            it.setGui(null);
            it.setParentPosition(Position.ORIGIN);
        });
        this.widgets.clear();
        if (!this.waitToRemoved.isEmpty()) {
            list = this.waitToRemoved;
            synchronized (list) {
                this.waitToRemoved.clear();
            }
        }
        if (!this.waitToAdded.isEmpty()) {
            list = this.waitToAdded;
            synchronized (list) {
                this.waitToAdded.clear();
            }
        }
        this.recomputeLayout();
        this.recomputeSize();
    }

    @Override
    public void initWidget() {
        super.initWidget();
        for (Widget widget : this.widgets) {
            if (widget.gui != this.gui) {
                widget.setGui(this.gui);
            }
            widget.initWidget();
        }
    }

    @Override
    public List<Target> getPhantomTargets(Object ingredient) {
        if (!this.isVisible()) {
            return Collections.emptyList();
        }
        ArrayList<Target> targets = new ArrayList<Target>();
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() || !(widget instanceof IGhostIngredientTarget)) continue;
            targets.addAll(((IGhostIngredientTarget)((Object)widget)).getPhantomTargets(ingredient));
        }
        return targets;
    }

    @Override
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        if (!this.isVisible()) {
            return null;
        }
        if (this.allowXEIIngredientOverMouse) {
            for (Widget widget : this.widgets) {
                IIngredientSlot ingredientSlot;
                Object result;
                if (!widget.isVisible() || !(widget instanceof IIngredientSlot) || (result = (ingredientSlot = (IIngredientSlot)((Object)widget)).getXEIIngredientOverMouse(mouseX, mouseY)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public void detectAndSendChanges() {
        for (Widget widget : this.widgets) {
            if (!widget.isActive()) continue;
            widget.detectAndSendChanges();
        }
        this.handleSyncWidget();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        for (Widget widget : this.widgets) {
            if (!widget.isActive()) continue;
            widget.updateScreen();
        }
        this.handleSyncWidget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSyncWidget() {
        List<Widget> list;
        if (!this.waitToRemoved.isEmpty()) {
            list = this.waitToRemoved;
            synchronized (list) {
                this.waitToRemoved.forEach(this::removeWidget);
                this.waitToRemoved.clear();
            }
        }
        if (!this.waitToAdded.isEmpty()) {
            list = this.waitToAdded;
            synchronized (list) {
                this.waitToAdded.forEach(this::addWidget);
                this.waitToAdded.clear();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawWidgetsForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        DialogWidget dialogWidget = null;
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            DialogWidget dialog;
            Widget widget = this.widgets.get(i);
            if (!(widget instanceof DialogWidget)) continue;
            dialogWidget = dialog = (DialogWidget)widget;
            break;
        }
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() || dialogWidget != null && widget != dialogWidget) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (widget.inAnimate()) {
                widget.animation.drawInForeground(graphics, mouseX, mouseY, partialTicks);
                continue;
            }
            widget.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        this.drawWidgetsForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawWidgetsBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Widget widget : this.widgets) {
            if (!widget.isVisible()) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (widget.inAnimate()) {
                widget.animation.drawInBackground(graphics, mouseX, mouseY, partialTicks);
                continue;
            }
            widget.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOverlay(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        for (Widget widget : this.widgets) {
            if (!widget.isVisible()) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            widget.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseWheelMove(mouseX, mouseY, wheelDelta)) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseDragged(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseMoved(double mouseX, double mouseY) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseMoved(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean charTyped(char codePoint, int modifiers) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            Widget widget;
            int widgetIndex = buffer.readVarInt();
            int widgetUpdateId = buffer.readVarInt();
            if (widgetIndex < this.widgets.size()) {
                widget = this.widgets.get(widgetIndex);
            } else {
                List<Widget> list = this.waitToAdded;
                synchronized (list) {
                    widget = this.waitToAdded.get(this.widgets.size() - widgetIndex);
                }
            }
            widget.readUpdateInfo(widgetUpdateId, buffer);
        } else if (id == 2) {
            Widget widget;
            int widgetIndex = buffer.readVarInt();
            if (widgetIndex < this.widgets.size()) {
                widget = this.widgets.get(widgetIndex);
            } else {
                List<Widget> list = this.waitToAdded;
                synchronized (list) {
                    widget = this.waitToAdded.get(this.widgets.size() - widgetIndex);
                }
            }
            if (!widget.isClientSideWidget && widget.isInitialized()) {
                widget.readInitialData(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            Widget widget;
            int widgetIndex = buffer.readVarInt();
            int widgetUpdateId = buffer.readVarInt();
            if (widgetIndex < this.widgets.size()) {
                widget = this.widgets.get(widgetIndex);
            } else {
                List<Widget> list = this.waitToAdded;
                synchronized (list) {
                    widget = this.waitToAdded.get(this.widgets.size() - widgetIndex);
                }
            }
            widget.handleClientAction(widgetUpdateId, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onScreenSizeUpdate(int screenWidth, int screenHeight) {
        super.onScreenSizeUpdate(screenWidth, screenHeight);
        for (Widget widget : this.widgets) {
            widget.onScreenSizeUpdate(screenWidth, screenHeight);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Rect2i> getGuiExtraAreas(Rect2i guiRect, List<Rect2i> list) {
        for (Widget widget : this.widgets) {
            list = widget.getGuiExtraAreas(guiRect, list);
        }
        return super.getGuiExtraAreas(guiRect, list);
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        IConfigurableWidgetGroup.super.buildConfigurator(father);
        this.addWidgetsConfigurator(father);
    }

    protected void addWidgetsConfigurator(ConfiguratorGroup father) {
        ArrayConfiguratorGroup<Widget> arrayGroup = new ArrayConfiguratorGroup<Widget>("children", true, () -> this.widgets, (getter, setter) -> {
            Widget child = (Widget)getter.get();
            return new WrapperConfigurator(child.id, new ImageWidget(0, 0, 50, 50, new WidgetTexture(child)));
        }, true);
        arrayGroup.setCanAdd(false);
        arrayGroup.setOnRemove(this::removeWidget);
        arrayGroup.setOnReorder((index, widget) -> {
            this.removeWidget((Widget)widget);
            this.addWidget((int)index, (Widget)widget);
        });
        father.addConfigurators(arrayGroup);
    }

    @Override
    public boolean canWidgetAccepted(IConfigurableWidget widget) {
        if (widget == this) {
            return false;
        }
        for (WidgetGroup parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != widget) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptWidget(IConfigurableWidget widget) {
        this.addWidget(widget.widget());
    }

    @Override
    public void onWidgetRemoved(IConfigurableWidget widget) {
        this.removeWidget(widget.widget());
    }

    @Override
    public CompoundTag serializeInnerNBT() {
        CompoundTag tag = IConfigurableWidgetGroup.super.serializeInnerNBT();
        ListTag children = new ListTag();
        for (Widget widget : this.widgets) {
            IConfigurableWidget child;
            if (!(widget instanceof IConfigurableWidget) || !(child = (IConfigurableWidget)((Object)widget)).isLDLRegister()) continue;
            children.add((Object)child.serializeWrapper());
        }
        tag.put("children", (Tag)children);
        return tag;
    }

    @Override
    public void deserializeInnerNBT(CompoundTag nbt) {
        this.clearAllWidgets();
        IConfigurableWidgetGroup.super.deserializeInnerNBT(nbt);
        ListTag children = nbt.getList("children", 10);
        for (Tag tag : children) {
            CompoundTag ui;
            IConfigurableWidget child;
            if (!(tag instanceof CompoundTag) || (child = IConfigurableWidget.deserializeWrapper(ui = (CompoundTag)tag)) == null) continue;
            this.addWidget(child.widget());
        }
    }

    public boolean isDynamicSized() {
        return this.isDynamicSized;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public int getLayoutPadding() {
        return this.layoutPadding;
    }

    public boolean isAllowXEIIngredientOverMouse() {
        return this.allowXEIIngredientOverMouse;
    }

    public void setAllowXEIIngredientOverMouse(boolean allowXEIIngredientOverMouse) {
        this.allowXEIIngredientOverMouse = allowXEIIngredientOverMouse;
    }

    private class WidgetGroupUIAccess
    implements WidgetUIAccess {
        private WidgetGroupUIAccess() {
        }

        @Override
        public boolean attemptMergeStack(ItemStack itemStack, boolean fromContainer, boolean simulate) {
            WidgetUIAccess uiAccess = WidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                return uiAccess.attemptMergeStack(itemStack, fromContainer, simulate);
            }
            return false;
        }

        @Override
        public void writeClientAction(Widget widget, int updateId, Consumer<FriendlyByteBuf> dataWriter) {
            WidgetGroup.this.writeClientAction(1, buffer -> {
                buffer.writeVarInt(WidgetGroup.this.widgets.indexOf(widget));
                buffer.writeVarInt(updateId);
                dataWriter.accept((FriendlyByteBuf)buffer);
            });
        }

        @Override
        public void writeUpdateInfo(Widget widget, int updateId, Consumer<FriendlyByteBuf> dataWriter) {
            WidgetGroup.this.writeUpdateInfo(1, buffer -> {
                buffer.writeVarInt(WidgetGroup.this.widgets.indexOf(widget));
                buffer.writeVarInt(updateId);
                dataWriter.accept((FriendlyByteBuf)buffer);
            });
        }
    }
}

