/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget.codeeditor;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.CodeEditor;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.Cursor;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.StyledLine;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.StyledText;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class CodeEditorWidget
extends WidgetGroup {
    public static final ResourceLocation MONO_BOLD = LDLib.location("jetbrains_mono_bold");
    public final CodeEditor codeEditor = new CodeEditor();
    protected int scrollXOffset;
    protected int scrollYOffset;
    protected IGuiTexture xBarB = IGuiTexture.EMPTY;
    protected IGuiTexture xBarF = ColorPattern.T_GRAY.rectTexture().setRadius(2.0f);
    protected IGuiTexture yBarB = IGuiTexture.EMPTY;
    protected IGuiTexture yBarF = ColorPattern.T_GRAY.rectTexture().setRadius(2.0f);
    protected Consumer<List<String>> onTextChanged;
    private boolean isHoveringXBar;
    private boolean isHoveringYBar;
    private boolean isDraggingXBar;
    private boolean isDraggingYBar;
    private double lastDeltaX;
    private double lastDeltaY;

    public CodeEditorWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setBackground(ColorPattern.DARK_GRAY.rectTexture());
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.isFocus() && this.isActive();
    }

    public List<String> getLines() {
        return this.codeEditor.getLines();
    }

    public void setLines(List<String> lines) {
        this.codeEditor.setLines(lines);
    }

    public void notifyChanged() {
        if (this.onTextChanged != null) {
            this.onTextChanged.accept(this.codeEditor.getLines());
        }
    }

    @Nullable
    public Cursor getCursor(double mouseX, double mouseY) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        int lineHeight = 9 + 2;
        int xOffset = 2;
        int yOffset = 2;
        double x = mouseX - (double)pos.x - (double)xOffset + (double)this.scrollXOffset;
        double y = mouseY - (double)pos.y - (double)yOffset + (double)this.scrollYOffset;
        List<StyledLine> visibleLines = this.codeEditor.getVisibleStyledLines();
        int line = Mth.clamp((int)((int)Math.floor(y / (double)lineHeight)), (int)0, (int)(visibleLines.size() - 1));
        StyledLine visibleLine = visibleLines.get(line);
        int width = visibleLine.getWidth(font, Style.EMPTY.withFont(MONO_BOLD));
        double column = Math.min(1.0, x / (double)width) * (double)this.codeEditor.getDocument().getLine(visibleLine.line()).length() + 0.5;
        return new Cursor(visibleLines.get(line).line(), (int)column);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isHoveringXBar) {
            this.isDraggingXBar = true;
            return true;
        }
        if (this.isHoveringYBar) {
            this.isDraggingYBar = true;
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.setFocus(true);
            this.codeEditor.clearSelection();
            this.codeEditor.setCursor(this.getCursor(mouseX, mouseY));
            this.codeEditor.startSelection();
            this.codeEditor.startSelection();
            return true;
        }
        if (this.isFocus()) {
            this.setFocus(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        double dx = dragX + this.lastDeltaX;
        double dy = dragY + this.lastDeltaY;
        dragX = (int)dx;
        dragY = (int)dy;
        this.lastDeltaX = dx - dragX;
        this.lastDeltaY = dy - dragY;
        if (this.isDraggingXBar || this.isDraggingYBar) {
            Size size = this.getSize();
            Font font = Minecraft.getInstance().font;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 2;
            List<StyledLine> visibleLines = this.codeEditor.getVisibleStyledLines();
            int fullHeight = lineHeight * visibleLines.size();
            int fullWidth = visibleLines.stream().map(styledLine -> styledLine.getWidth(font, Style.EMPTY.withFont(MONO_BOLD))).max(Integer::compareTo).orElse(0) + 3;
            boolean hasXBar = fullWidth > size.width;
            int availableHeight = size.height - (hasXBar ? 4 : 0);
            boolean hasYBar = fullHeight > availableHeight;
            int availableWidth = size.width - (hasYBar ? 4 : 0);
            boolean bl = hasXBar = fullWidth > availableWidth;
            if (this.isDraggingXBar && hasXBar) {
                this.scrollXOffset += (int)dragX;
                this.scrollXOffset = Mth.clamp((int)this.scrollXOffset, (int)0, (int)(fullWidth - availableWidth));
            } else if (this.isDraggingYBar && hasYBar) {
                this.scrollYOffset += (int)dragY;
                this.scrollYOffset = Mth.clamp((int)this.scrollYOffset, (int)0, (int)(fullHeight - availableHeight));
            }
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY) && this.codeEditor.isSelecting()) {
            this.codeEditor.setCursor(this.getCursor(mouseX, mouseY));
            this.codeEditor.updateSelection();
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.codeEditor.endSelection();
        this.isDraggingXBar = false;
        this.isDraggingYBar = false;
        this.lastDeltaX = 0.0;
        this.lastDeltaY = 0.0;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.canConsumeInput()) {
            List<String> previous = this.getLines();
            if (Screen.isSelectAll((int)keyCode)) {
                this.codeEditor.selectAll();
            } else if (Screen.isCopy((int)keyCode)) {
                Minecraft.getInstance().keyboardHandler.setClipboard(this.codeEditor.copySelection());
            } else if (Screen.isPaste((int)keyCode)) {
                this.codeEditor.insertText(Minecraft.getInstance().keyboardHandler.getClipboard());
            } else if (Screen.isCut((int)keyCode)) {
                Minecraft.getInstance().keyboardHandler.setClipboard(this.codeEditor.copySelection());
                this.codeEditor.deleteSelection();
            } else {
                switch (keyCode) {
                    case 340: 
                    case 344: {
                        this.codeEditor.startSelection();
                        break;
                    }
                    case 257: {
                        this.codeEditor.enter();
                        break;
                    }
                    case 259: {
                        this.codeEditor.backspace();
                        break;
                    }
                    case 261: {
                        this.codeEditor.deleteForwardText();
                        break;
                    }
                    case 262: {
                        this.codeEditor.moveCursorRight();
                        if (CodeEditorWidget.isShiftDown()) {
                            this.codeEditor.updateSelection();
                            break;
                        }
                        this.codeEditor.clearSelection();
                        break;
                    }
                    case 263: {
                        this.codeEditor.moveCursorLeft();
                        if (CodeEditorWidget.isShiftDown()) {
                            this.codeEditor.updateSelection();
                            break;
                        }
                        this.codeEditor.clearSelection();
                        break;
                    }
                    case 264: {
                        this.codeEditor.moveCursorDown();
                        if (CodeEditorWidget.isShiftDown()) {
                            this.codeEditor.updateSelection();
                            break;
                        }
                        this.codeEditor.clearSelection();
                        break;
                    }
                    case 265: {
                        this.codeEditor.moveCursorUp();
                        if (CodeEditorWidget.isShiftDown()) {
                            this.codeEditor.updateSelection();
                            break;
                        }
                        this.codeEditor.clearSelection();
                        break;
                    }
                    case 258: {
                        this.codeEditor.insertText(this.codeEditor.getIndentString());
                        break;
                    }
                    case 268: {
                        this.codeEditor.moveCursorStart();
                        break;
                    }
                    case 269: {
                        this.codeEditor.moveCursorEnd();
                    }
                }
            }
            this.adaptCursor();
            if (!previous.equals(this.getLines())) {
                this.notifyChanged();
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void adaptCursor() {
        Position pos = this.getPosition();
        Size size = this.getSize();
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        int lineHeight = 9 + 2;
        int xOffset = 2;
        int yOffset = 2;
        Cursor cursorPos = this.codeEditor.getCursor();
        List<StyledLine> visibleLines = this.codeEditor.getVisibleStyledLines();
        int fullHeight = lineHeight * visibleLines.size();
        int fullWidth = visibleLines.stream().map(styledLine -> styledLine.getWidth(font, Style.EMPTY.withFont(MONO_BOLD))).max(Integer::compareTo).orElse(0) + 3;
        boolean hasXBar = fullWidth > size.width;
        int availableHeight = size.height - (hasXBar ? 4 : 0);
        boolean hasYBar = fullHeight > availableHeight;
        int availableWidth = size.width - (hasYBar ? 4 : 0);
        hasXBar = fullWidth > availableWidth;
        for (StyledLine visibleLine : visibleLines) {
            if (visibleLine.line() > cursorPos.line()) break;
            if (visibleLine.line() != cursorPos.line()) continue;
            int cursorX = font.width((FormattedText)Component.literal((String)this.codeEditor.getDocument().getLine(cursorPos.line()).substring(0, cursorPos.column())).withStyle(Style.EMPTY.withFont(MONO_BOLD))) - 1 + xOffset + pos.x - this.scrollXOffset;
            if (cursorX < pos.x) {
                this.scrollXOffset += cursorX - pos.x;
            } else if (cursorX > pos.x + availableWidth - 2) {
                this.scrollXOffset += cursorX - pos.x - availableWidth + 2;
            }
            int n = pos.y + cursorPos.line() * lineHeight;
            Objects.requireNonNull(font);
            int cursorY = n + 9 + yOffset - 2 - this.scrollYOffset;
            int n2 = pos.y;
            Objects.requireNonNull(font);
            if (cursorY < n2 + 9) {
                int n3 = cursorY - pos.y;
                Objects.requireNonNull(font);
                this.scrollYOffset += n3 - 9;
                continue;
            }
            if (cursorY <= pos.y + availableHeight) continue;
            this.scrollYOffset += cursorY - pos.y - availableHeight;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.canConsumeInput() && (keyCode == 340 || keyCode == 344)) {
            this.codeEditor.endSelection();
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean charTyped(char codePoint, int modifiers) {
        if (this.canConsumeInput()) {
            if (SharedConstants.isAllowedChatCharacter((char)codePoint)) {
                this.codeEditor.insertText(Character.toString(codePoint));
                this.adaptCursor();
                this.notifyChanged();
            }
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            boolean hasYBar;
            Position pos = this.getPosition();
            Size size = this.getSize();
            Font font = Minecraft.getInstance().font;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 2;
            List<StyledLine> visibleLines = this.codeEditor.getVisibleStyledLines();
            int fullHeight = lineHeight * visibleLines.size();
            int fullWidth = visibleLines.stream().map(styledLine -> styledLine.getWidth(font, Style.EMPTY.withFont(MONO_BOLD))).max(Integer::compareTo).orElse(0) + 3;
            boolean hasXBar = fullWidth > size.width;
            int availableHeight = size.height - (hasXBar ? 4 : 0);
            boolean bl = hasYBar = fullHeight > availableHeight;
            if (hasYBar) {
                int moveDelta = (int)(-Mth.clamp((double)wheelDelta, (double)-1.0, (double)1.0) * 13.0);
                this.scrollYOffset += moveDelta;
                this.scrollYOffset = Mth.clamp((int)this.scrollYOffset, (int)0, (int)(fullHeight - availableHeight));
            } else {
                this.scrollYOffset = 0;
            }
            return true;
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
        Position pos = this.getPosition();
        Size size = this.getSize();
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        int lineHeight = 9 + 2;
        int xOffset = 2;
        int yOffset = 2;
        List<StyledLine> visibleLines = this.codeEditor.getVisibleStyledLines();
        int fullHeight = lineHeight * visibleLines.size();
        int fullWidth = visibleLines.stream().map(styledLine -> styledLine.getWidth(font, Style.EMPTY.withFont(MONO_BOLD))).max(Integer::compareTo).orElse(0) + 3;
        boolean hasXBar = fullWidth > size.width;
        int availableHeight = size.height - (hasXBar ? 4 : 0);
        boolean hasYBar = fullHeight > availableHeight;
        int availableWidth = size.width - (hasYBar ? 4 : 0);
        boolean bl = hasXBar = fullWidth > availableWidth;
        if (hasYBar) {
            int barHeight = availableHeight * availableHeight / fullHeight;
            this.isHoveringYBar = CodeEditorWidget.isMouseOver(pos.x + size.width - 4, pos.y + this.scrollYOffset * availableHeight / fullHeight, 4, barHeight, mouseX, mouseY);
            this.scrollYOffset = Mth.clamp((int)this.scrollYOffset, (int)0, (int)(fullHeight - availableHeight));
            this.yBarB.draw(graphics, mouseX, mouseY, pos.x + size.width - 4, pos.y, 4, availableHeight);
            this.yBarF.draw(graphics, mouseX, mouseY, pos.x + size.width - 4, (float)pos.y + (float)(this.scrollYOffset * availableHeight) * 1.0f / (float)fullHeight, 4, barHeight);
        } else {
            this.scrollYOffset = 0;
            this.isHoveringYBar = false;
        }
        if (hasXBar) {
            int barWidth = size.width * availableWidth / fullWidth;
            this.isHoveringXBar = CodeEditorWidget.isMouseOver(pos.x + this.scrollXOffset * size.width / fullWidth, pos.y + size.height - 4, barWidth, 4, mouseX, mouseY);
            this.scrollXOffset = Mth.clamp((int)this.scrollXOffset, (int)0, (int)(fullWidth - availableWidth));
            this.xBarB.draw(graphics, mouseX, mouseY, pos.x, pos.y + size.height - 4, size.width, 4);
            this.xBarF.draw(graphics, mouseX, mouseY, (float)pos.x + (float)(this.scrollXOffset * size.width) * 1.0f / (float)fullWidth, pos.y + size.height - 4, barWidth, 4);
        } else {
            this.scrollXOffset = 0;
            this.isHoveringXBar = false;
        }
        Matrix4f trans = graphics.pose().last().pose();
        Vector4f realPos = trans.transform(new Vector4f((float)pos.x, (float)pos.y, 0.0f, 1.0f));
        Vector4f realPos2 = trans.transform(new Vector4f((float)(pos.x + availableWidth), (float)(pos.y + availableHeight), 0.0f, 1.0f));
        graphics.enableScissor((int)realPos.x, (int)realPos.y, (int)realPos2.x, (int)realPos2.y);
        graphics.pose().pushPose();
        graphics.pose().translate((float)(-this.scrollXOffset), (float)(-this.scrollYOffset), 0.0f);
        if (this.codeEditor.isSelectionValid()) {
            int[] range = this.codeEditor.getSelection().getSelectionRange();
            graphics.drawManaged(() -> {
                for (int i = 0; i < visibleLines.size(); ++i) {
                    StyledLine visibleLine = (StyledLine)visibleLines.get(i);
                    int line = visibleLine.line();
                    if (line < range[0]) continue;
                    if (line > range[2]) break;
                    int start = line == range[0] ? font.width((FormattedText)Component.literal((String)this.codeEditor.getDocument().getLine(line).substring(0, range[1])).withStyle(Style.EMPTY.withFont(MONO_BOLD))) - 1 : 0;
                    int end = line == range[2] ? font.width((FormattedText)Component.literal((String)this.codeEditor.getDocument().getLine(line).substring(0, range[3])).withStyle(Style.EMPTY.withFont(MONO_BOLD))) - 1 : this.getSizeWidth();
                    int n = pos.x + start + xOffset;
                    int n2 = pos.y + i * lineHeight + yOffset - 2;
                    int n3 = pos.x + end + xOffset;
                    int n4 = pos.y + i * lineHeight;
                    Objects.requireNonNull(font);
                    graphics.fill(n, n2, n3, n4 + 9 + yOffset - 2, -2130706433);
                }
            });
        }
        graphics.drawManaged(() -> {
            int y = 0;
            for (StyledLine styledLine : visibleLines) {
                int x = 0;
                for (StyledText styledText : styledLine.text()) {
                    MutableComponent literal = Component.literal((String)styledText.getText()).withStyle(styledText.getStyle().withFont(MONO_BOLD));
                    graphics.drawString(font, (Component)literal, pos.x + x + xOffset - 1, pos.y + y + yOffset, -1, false);
                    x += font.width((FormattedText)literal) - 1;
                }
                y += lineHeight;
            }
        });
        if (this.canConsumeInput() && System.currentTimeMillis() % 1000L < 500L) {
            Cursor cursorPos = this.codeEditor.getCursor();
            for (StyledLine visibleLine : visibleLines) {
                if (visibleLine.line() > cursorPos.line()) break;
                if (visibleLine.line() != cursorPos.line()) continue;
                int cursorX = font.width((FormattedText)Component.literal((String)this.codeEditor.getDocument().getLine(cursorPos.line()).substring(0, cursorPos.column())).withStyle(Style.EMPTY.withFont(MONO_BOLD))) - 1;
                int n = pos.x + cursorX + xOffset;
                int n2 = pos.y + cursorPos.line() * lineHeight + yOffset - 2;
                int n3 = pos.x + cursorX + 1 + xOffset;
                int n4 = pos.y + cursorPos.line() * lineHeight;
                Objects.requireNonNull(font);
                graphics.fill(n, n2, n3, n4 + 9 + yOffset - 2, -1);
            }
        }
        graphics.pose().popPose();
        graphics.disableScissor();
        this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
    }

    public CodeEditor getCodeEditor() {
        return this.codeEditor;
    }

    public int getScrollXOffset() {
        return this.scrollXOffset;
    }

    public int getScrollYOffset() {
        return this.scrollYOffset;
    }

    public IGuiTexture getXBarB() {
        return this.xBarB;
    }

    public IGuiTexture getXBarF() {
        return this.xBarF;
    }

    public IGuiTexture getYBarB() {
        return this.yBarB;
    }

    public IGuiTexture getYBarF() {
        return this.yBarF;
    }

    public Consumer<List<String>> getOnTextChanged() {
        return this.onTextChanged;
    }

    public boolean isHoveringXBar() {
        return this.isHoveringXBar;
    }

    public boolean isHoveringYBar() {
        return this.isHoveringYBar;
    }

    public boolean isDraggingXBar() {
        return this.isDraggingXBar;
    }

    public boolean isDraggingYBar() {
        return this.isDraggingYBar;
    }

    public double getLastDeltaX() {
        return this.lastDeltaX;
    }

    public double getLastDeltaY() {
        return this.lastDeltaY;
    }

    public void setOnTextChanged(Consumer<List<String>> onTextChanged) {
        this.onTextChanged = onTextChanged;
    }
}

