/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget.codeeditor.language;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.TokenType;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.TokenTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Style;

public class StyleManager {
    private final Map<String, Style> styleMap = new HashMap<String, Style>();
    public Style defaultStyle = Style.EMPTY.withColor(-1);

    public StyleManager() {
        this.styleMap.put(TokenTypes.KEYWORD.name, Style.EMPTY.withColor(ColorPattern.ORANGE.color));
        this.styleMap.put(TokenTypes.IDENTIFIER.name, Style.EMPTY.withColor(ColorPattern.WHITE.color));
        this.styleMap.put(TokenTypes.STRING.name, Style.EMPTY.withColor(ColorPattern.GREEN.color));
        this.styleMap.put(TokenTypes.COMMENT.name, Style.EMPTY.withColor(ColorPattern.GRAY.color));
        this.styleMap.put(TokenTypes.NUMBER.name, Style.EMPTY.withColor(ColorPattern.CYAN.color));
        this.styleMap.put(TokenTypes.OPERATOR.name, Style.EMPTY.withColor(ColorPattern.WHITE.color));
    }

    public Style getStyleForTokenType(TokenType type) {
        return this.styleMap.getOrDefault(type.name, this.defaultStyle);
    }

    public Map<String, Style> getStyleMap() {
        return this.styleMap;
    }

    public Style getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(Style defaultStyle) {
        this.defaultStyle = defaultStyle;
    }
}

