/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.jei;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.jei.ClickableIngredient;
import com.lowdragmc.lowdraglib.jei.ModularUIJeiHandler;
import com.lowdragmc.lowdraglib.test.TestJEIPlugin;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiRuntime jeiRuntime;
    public static IJeiHelpers jeiHelpers;
    private static final ModularUIJeiHandler modularUIGuiHandler;

    public JEIPlugin() {
        LDLib.LOGGER.debug("LDLib JEI Plugin created");
    }

    @Nullable
    public static Object getItemIngredient(ItemStack itemStack, int x, int y, int width, int height) {
        IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();
        return ingredientManager.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)itemStack).map(typedIngredient -> new ClickableIngredient(typedIngredient, x, y, width, height)).orElse(null);
    }

    public static boolean isJeiEnabled() {
        return jeiRuntime != null && jeiRuntime.getIngredientListOverlay().isListDisplayed();
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        JEIPlugin.jeiRuntime = jeiRuntime;
    }

    public void registerGuiHandlers(@Nonnull IGuiHandlerRegistration registration) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        registration.addGhostIngredientHandler(ModularUIGuiContainer.class, (IGhostIngredientHandler)modularUIGuiHandler);
        registration.addGenericGuiContainerHandler(ModularUIGuiContainer.class, (IGuiContainerHandler)modularUIGuiHandler);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ldlib", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
        if (Platform.isDevEnv()) {
            TestJEIPlugin.registerCategories(registration);
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Platform.isDevEnv()) {
            TestJEIPlugin.registerRecipes(registration);
        }
    }

    static {
        modularUIGuiHandler = new ModularUIJeiHandler();
    }
}

