/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.jei;

import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModularWrapper<T extends Widget>
extends ModularUIGuiContainer {
    protected T widget;
    protected boolean shouldRenderTooltips = false;
    private int lastTick;
    private int left;
    private int top;

    public ModularWrapper(T widget) {
        super(new ModularUI(((Widget)widget).getSize().width, ((Widget)widget).getSize().height, IUIHolder.EMPTY, (Player)Minecraft.getInstance().player).widget((Widget)widget), -1);
        this.modularUI.initWidgets();
        this.minecraft = Minecraft.getInstance();
        this.font = this.minecraft.font;
        this.widget = widget;
    }

    public String getUid() {
        return null;
    }

    public void setRecipeWidget(int left, int top) {
        this.modularUI.initWidgets();
        this.left = 0;
        this.top = 0;
        this.width = this.minecraft.getWindow().getGuiScaledWidth();
        this.height = this.minecraft.getWindow().getGuiScaledHeight();
        this.modularUI.updateScreenSize(this.width, this.height);
        Position displayOffset = new Position(left, top);
        this.modularUI.mainGroup.setParentPosition(displayOffset);
    }

    public void setEmiRecipeWidget(int left, int top) {
        this.modularUI.initWidgets();
        this.left = left;
        this.top = top;
        this.width = this.minecraft.getWindow().getGuiScaledWidth();
        this.height = this.minecraft.getWindow().getGuiScaledHeight();
        this.modularUI.updateScreenSize(this.width, this.height);
        Position displayOffset = new Position(left, top);
        this.modularUI.mainGroup.setParentPosition(displayOffset);
    }

    public void draw(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft.player.tickCount != this.lastTick) {
            this.updateScreen();
            this.lastTick = this.minecraft.player.tickCount;
        }
        graphics.pose().pushPose();
        graphics.pose().translate((float)(-this.left), (float)(-this.top), 0.0f);
        this.render(graphics, mouseX + this.left, mouseY + this.top, partialTicks);
        graphics.pose().popPose();
    }

    public void updateScreen() {
        this.modularUI.mainGroup.updateScreen();
    }

    @Override
    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.hoveredSlot = null;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        this.tooltipTexts = null;
        this.tooltipFont = null;
        this.tooltipStack = ItemStack.EMPTY;
        this.tooltipComponent = null;
        this.modularUI.mainGroup.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        this.modularUI.mainGroup.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        if (this.shouldRenderTooltips && this.tooltipTexts != null && !this.tooltipTexts.isEmpty()) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 240.0f);
            graphics.renderTooltip(this.font, this.tooltipTexts, Optional.ofNullable(this.tooltipComponent), mouseX, mouseY);
            graphics.pose().popPose();
            graphics.bufferSource().endLastBatch();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
    }

    public T getWidget() {
        return this.widget;
    }

    public boolean isShouldRenderTooltips() {
        return this.shouldRenderTooltips;
    }

    public void setShouldRenderTooltips(boolean shouldRenderTooltips) {
        this.shouldRenderTooltips = shouldRenderTooltips;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }
}

