/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.json.factory;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateTypeAdapterFactory
implements TypeAdapterFactory {
    public static final BlockStateTypeAdapterFactory INSTANCE = new BlockStateTypeAdapterFactory();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (BlockState.class.isAssignableFrom(type.getRawType())) {
            return new IBlockStateTypeAdapter(gson);
        }
        return null;
    }

    private static final class IBlockStateTypeAdapter
    extends TypeAdapter<BlockState> {
        private final Gson gson;

        private IBlockStateTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, BlockState value) {
            if (value == null) {
                this.gson.toJson((JsonElement)JsonNull.INSTANCE, out);
                return;
            }
            BuiltInRegistries.BLOCK.getKey((Object)value.getBlock());
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", BuiltInRegistries.BLOCK.getKey((Object)value.getBlock()).toString());
            jsonObject.addProperty("meta", (Number)value.getBlock().getStateDefinition().getPossibleStates().indexOf((Object)value));
            this.gson.toJson((JsonElement)jsonObject, out);
        }

        public BlockState read(JsonReader in) {
            JsonElement jsonElement = (JsonElement)this.gson.fromJson(in, JsonElement.class);
            if (jsonElement.isJsonNull()) {
                return null;
            }
            ResourceLocation id = new ResourceLocation(jsonElement.getAsJsonObject().get("id").getAsString());
            Block block = (Block)BuiltInRegistries.BLOCK.get(id);
            if (block == Blocks.AIR && !id.equals((Object)new ResourceLocation("air"))) {
                return null;
            }
            if (jsonElement.getAsJsonObject().has("meta")) {
                int meta = jsonElement.getAsJsonObject().get("meta").getAsInt();
                return block.getStateDefinition().getPossibleStates().size() > meta ? (BlockState)block.getStateDefinition().getPossibleStates().get(meta) : block.defaultBlockState();
            }
            return block.defaultBlockState();
        }
    }
}

