/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.kjs.ui;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.factory.UIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.kjs.ui.UIEvents;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.rhino.util.RemapForJS;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemUIJSFactory
extends UIFactory<ItemAccess> {
    public static final ItemUIJSFactory INSTANCE = new ItemUIJSFactory();

    private ItemUIJSFactory() {
        super(LDLib.location("item_js"));
    }

    @RemapForJS(value="openUI")
    public boolean kjs$openUI(Player player, InteractionHand hand, String uiName) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.openUI(new ItemAccess(hand, uiName), serverPlayer);
        }
        return false;
    }

    @Override
    protected ModularUI createUITemplate(final ItemAccess holder, final Player entityPlayer) {
        final ItemStack held = entityPlayer.getItemInHand(holder.hand);
        EventResult result = UIEvents.ITEM.post((EventJS)new UIEvents.ItemUIEventJS(entityPlayer, holder.hand, held), (Object)holder.uiName);
        Object object = result.value();
        if (object instanceof WidgetGroup) {
            WidgetGroup root = (WidgetGroup)object;
            if (!result.interruptFalse() && !result.error()) {
                return new ModularUI(root, new IUIHolder(){

                    @Override
                    public ModularUI createUI(Player entityPlayer2) {
                        return null;
                    }

                    @Override
                    public boolean isInvalid() {
                        return !ItemStack.isSameItemSameTags((ItemStack)entityPlayer.getItemInHand(holder.hand), (ItemStack)held);
                    }

                    @Override
                    public boolean isRemote() {
                        return entityPlayer.level().isClientSide;
                    }

                    @Override
                    public void markAsDirty() {
                    }
                }, entityPlayer);
            }
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected ItemAccess readHolderFromSyncData(FriendlyByteBuf syncData) {
        return new ItemAccess((InteractionHand)syncData.readEnum(InteractionHand.class), syncData.readUtf());
    }

    @Override
    protected void writeHolderToSyncData(FriendlyByteBuf syncData, ItemAccess holder) {
        syncData.writeEnum((Enum)holder.hand);
        syncData.writeUtf(holder.uiName);
    }

    public record ItemAccess(InteractionHand hand, String uiName) {
    }
}

