/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class BucketPickupTransfer
implements IFluidTransfer {
    protected final BucketPickup bucketPickupHandler;
    protected final Level world;
    protected final BlockPos blockPos;

    public BucketPickupTransfer(BucketPickup bucketPickupHandler, Level world, BlockPos blockPos) {
        this.bucketPickupHandler = bucketPickupHandler;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        FluidState fluidState;
        if (tank == 0 && !(fluidState = this.world.getFluidState(this.blockPos)).isEmpty()) {
            return FluidStack.create(fluidState.getType(), FluidHelper.getBucket());
        }
        return FluidStack.empty();
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
    }

    @Override
    public long getTankCapacity(int tank) {
        return FluidHelper.getBucket();
    }

    @Override
    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return 0L;
    }

    @Override
    @Nonnull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        FluidState fluidState;
        if (!resource.isEmpty() && FluidHelper.getBucket() <= resource.getAmount() && !(fluidState = this.world.getFluidState(this.blockPos)).isEmpty() && resource.getFluid() == fluidState.getType()) {
            if (!simulate) {
                Item item;
                ItemStack itemStack = this.bucketPickupHandler.pickupBlock((LevelAccessor)this.world, this.blockPos, this.world.getBlockState(this.blockPos));
                if (itemStack != ItemStack.EMPTY && (item = itemStack.getItem()) instanceof BucketItemAccessor) {
                    BucketItemAccessor bucket = (BucketItemAccessor)item;
                    FluidStack extracted = FluidStack.create(bucket.fabric_getFluid(), FluidHelper.getBucket());
                    if (!resource.isFluidEqual(extracted)) {
                        return FluidStack.empty();
                    }
                    return extracted;
                }
            } else {
                FluidStack extracted = FluidStack.create(fluidState.getType(), FluidHelper.getBucket());
                if (resource.isFluidEqual(extracted)) {
                    return extracted;
                }
            }
        }
        return FluidStack.empty();
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return true;
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return new Object();
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
    }
}

