/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.misc.ItemHandlerHelper;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ContainerTransfer
implements IItemTransfer {
    private final Container inv;

    public ContainerTransfer(Container inv) {
        this.inv = inv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerTransfer that = (ContainerTransfer)o;
        return this.getInv().equals(that.getInv());
    }

    public int hashCode() {
        return this.getInv().hashCode();
    }

    @Override
    public int getSlots() {
        return this.getInv().getContainerSize();
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getInv().getItem(slot);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean notifyChanges) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getItem(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.getInv().canPlaceItem(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.getInv().setItem(slot, copy);
                    if (notifyChanges) {
                        this.onContentsChanged();
                    }
                    this.getInv().setChanged();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.getInv().setItem(slot, copy);
                if (notifyChanges) {
                    this.onContentsChanged();
                }
                this.getInv().setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.getInv().canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.getInv().setItem(slot, stack.split(m));
                if (notifyChanges) {
                    this.onContentsChanged();
                }
                this.getInv().setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.getInv().setItem(slot, stack);
            if (notifyChanges) {
                this.onContentsChanged();
            }
            this.getInv().setChanged();
        }
        return ItemStack.EMPTY;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getItem(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.getInv().removeItem(slot, m);
        if (notifyChanges) {
            this.onContentsChanged();
        }
        this.getInv().setChanged();
        return decrStackSize;
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.getInv().setItem(slot, stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.getInv().getMaxStackSize();
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.getInv().canPlaceItem(slot, stack);
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        ItemStack[] copied = new ItemStack[this.inv.getContainerSize()];
        for (int i = 0; i < this.inv.getContainerSize(); ++i) {
            copied[i] = this.inv.getItem(i).copy();
        }
        return copied;
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        ItemStack[] copied;
        if (snapshot instanceof ItemStack[] && (copied = (ItemStack[])snapshot).length == this.inv.getContainerSize()) {
            for (int i = 0; i < this.inv.getContainerSize(); ++i) {
                this.inv.setItem(i, copied[i]);
            }
        }
    }

    public Container getInv() {
        return this.inv;
    }
}

