/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class FluidBlockTransfer
implements IFluidTransfer {
    protected final LiquidBlock fluidBlock;
    protected final BlockState blockState;
    protected final Level world;
    protected final BlockPos blockPos;

    public FluidBlockTransfer(LiquidBlock fluidBlock, Level world, BlockPos blockPos) {
        this.fluidBlock = fluidBlock;
        this.world = world;
        this.blockPos = blockPos;
        this.blockState = world.getBlockState(blockPos);
    }

    public Fluid getFluid() {
        return this.fluidBlock.getFluidState(this.blockState).getType();
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? FluidStack.create(this.getFluid(), FluidHelper.getBucket()) : FluidStack.empty();
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
    }

    @Override
    public long getTankCapacity(int tank) {
        return FluidHelper.getBucket();
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return stack.getFluid() == this.getFluid();
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return 0L;
    }

    @Override
    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (!resource.isEmpty() && resource.getFluid() == this.getFluid() && resource.getAmount() >= this.getTankCapacity(0)) {
            FluidStack drained = this.getFluidInTank(0).copy();
            if (!simulate) {
                this.world.setBlockAndUpdate(this.blockPos, Blocks.AIR.defaultBlockState());
            }
            return drained;
        }
        return FluidStack.empty();
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return true;
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return new Object();
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
    }
}

