/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class LiquidBlockContainerTransfer
implements IFluidTransfer {
    protected final LiquidBlockContainer liquidContainer;
    protected final Level world;
    protected final BlockPos blockPos;

    public LiquidBlockContainerTransfer(LiquidBlockContainer liquidContainer, Level world, BlockPos blockPos) {
        this.liquidContainer = liquidContainer;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.empty();
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        this.fill(0, fluidStack, false, false);
    }

    @Override
    public long getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    @Override
    @Nonnull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return FluidStack.empty();
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        BlockState state;
        if (resource.getAmount() >= FluidHelper.getBucket() && this.liquidContainer.canPlaceLiquid((BlockGetter)this.world, this.blockPos, state = this.world.getBlockState(this.blockPos), resource.getFluid()) && (simulate || this.liquidContainer.placeLiquid((LevelAccessor)this.world, this.blockPos, state, resource.getFluid().defaultFluidState()))) {
            return FluidHelper.getBucket();
        }
        return 0L;
    }

    @Override
    public boolean supportsFill(int tank) {
        return true;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return false;
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return this.world.getBlockState(this.blockPos);
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        if (snapshot instanceof BlockState) {
            BlockState state = (BlockState)snapshot;
            this.world.setBlockAndUpdate(this.blockPos, state);
        }
    }

    public static class BlockWrapper
    implements IFluidTransfer {
        protected final BlockState state;
        protected final Level world;
        protected final BlockPos blockPos;

        public BlockWrapper(BlockState state, Level world, BlockPos blockPos) {
            this.state = state;
            this.world = world;
            this.blockPos = blockPos;
        }

        @Override
        public int getTanks() {
            return 1;
        }

        @Override
        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.empty();
        }

        @Override
        public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
            this.fill(0, fluidStack, false, false);
        }

        @Override
        public long getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        @Override
        @Nonnull
        public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            return FluidStack.empty();
        }

        @Override
        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            if (resource.getAmount() < FluidHelper.getBucket()) {
                return 0L;
            }
            if (!simulate) {
                FluidTransferHelper.destroyBlockOnFluidPlacement(this.world, this.blockPos);
                this.world.setBlock(this.blockPos, this.state, 11);
            }
            return FluidHelper.getBucket();
        }

        @Override
        public boolean supportsFill(int tank) {
            return true;
        }

        @Override
        public boolean supportsDrain(int tank) {
            return false;
        }

        @Override
        @NotNull
        public Object createSnapshot() {
            return this.state;
        }

        @Override
        public void restoreFromSnapshot(Object snapshot) {
            this.world.setBlockAndUpdate(this.blockPos, this.state);
        }
    }
}

